/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inconsistentLanguageLevel;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyInspection;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InconsistentLanguageLevelInspection
extends GlobalInspectionTool {
    public boolean isGraphNeeded() {
        return false;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefModule) {
            Module module = ((RefModule)refEntity).getModule();
            if (module.isDisposed() || !scope.containsModule(module)) {
                return null;
            }
            LanguageLevel languageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                LanguageLevel dependantLanguageLevel;
                Module dependantModule;
                if (!(entry instanceof ModuleOrderEntry) || (dependantModule = ((ModuleOrderEntry)entry).getModule()) == null || languageLevel.compareTo((Enum)(dependantLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)dependantModule))) >= 0) continue;
                ModuleProblemDescriptor problemDescriptor = manager.createProblemDescriptor("Module " + module.getName() + " with language level " + languageLevel + " depends on module " + dependantModule.getName() + " with language level " + dependantLanguageLevel, module, new QuickFix[]{new UnnecessaryModuleDependencyInspection.RemoveModuleDependencyFix(dependantModule.getName()), (QuickFix)QuickFixFactory.getInstance().createShowModulePropertiesFix(module)});
                return new CommonProblemDescriptor[]{problemDescriptor};
            }
        }
        return null;
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.MODULARIZATION_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return "Inconsistent language level settings";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "InconsistentLanguageLevel";
    }
}

