/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.quickfix.JetBrainsAnnotationsExternalLibraryResolver;
import com.intellij.codeInspection.inferNullity.AnnotateTask;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectModelModificationService;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.ui.TitledSeparator;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InferNullityAnnotationsAction
extends BaseAnalysisAction {
    @NonNls
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    @NonNls
    private static final String ANNOTATE_LOCAL_VARIABLES = "annotate.local.variables";
    private JCheckBox myAnnotateLocalVariablesCb;

    public InferNullityAnnotationsAction() {
        super("Infer Nullity", INFER_NULLITY_ANNOTATIONS);
    }

    protected void analyze(final @NotNull Project project, @NotNull AnalysisScope scope) {
        PropertiesComponent.getInstance().setValue(ANNOTATE_LOCAL_VARIABLES, this.myAnnotateLocalVariablesCb.isSelected());
        ProgressManager progressManager = ProgressManager.getInstance();
        final HashSet modulesWithoutAnnotations = new HashSet();
        final HashSet modulesWithLL = new HashSet();
        final JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        final String defaultNullable = NullableNotNullManager.getInstance((Project)project).getDefaultNullable();
        final int[] fileCount = new int[]{0};
        if (!progressManager.runProcessWithProgressSynchronously(() -> scope.accept(new PsiElementVisitor(){
            private final Set processed = new HashSet();

            public void visitFile(PsiFile file) {
                fileCount[0] = fileCount[0] + 1;
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile != null) {
                    progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                }
                progressIndicator.setText(AnalysisScopeBundle.message((String)"scanning.scope.progress.title", (Object[])new Object[0]));
                if (!(file instanceof PsiJavaFile)) {
                    return;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
                if (module != null && this.processed.add(module)) {
                    if (PsiUtil.getLanguageLevel((PsiElement)file).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                        modulesWithLL.add(module);
                    } else if (javaPsiFacade.findClass(defaultNullable, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) == null) {
                        modulesWithoutAnnotations.add(module);
                    }
                }
            }
        }), "Check Applicability...", true, project)) {
            return;
        }
        if (!modulesWithLL.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)"Infer Nullity Annotations requires the project language level be set to 1.5 or greater.", (String)INFER_NULLITY_ANNOTATIONS);
            return;
        }
        if (!modulesWithoutAnnotations.isEmpty()) {
            if (InferNullityAnnotationsAction.addAnnotationsDependency(project, modulesWithoutAnnotations, defaultNullable, INFER_NULLITY_ANNOTATIONS)) {
                this.restartAnalysis(project, scope);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        UsageInfo[] usageInfos = this.findUsages(project, scope, fileCount[0]);
        if (usageInfos == null) {
            return;
        }
        this.processUsages(project, scope, usageInfos);
    }

    protected void processUsages(@NotNull Project project, @NotNull AnalysisScope scope, @NotNull UsageInfo[] usageInfos) {
        if (usageInfos.length < 5) {
            InferNullityAnnotationsAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> usageInfos)).run();
        } else {
            this.showUsageView(project, usageInfos, scope);
        }
    }

    public static boolean addAnnotationsDependency(@NotNull Project project, @NotNull Set<? extends Module> modulesWithoutAnnotations, @NotNull String annoFQN, String title) {
        Library annotationsLib = LibraryUtil.findLibraryByClass((String)annoFQN, (Project)project);
        if (annotationsLib != null) {
            String message2 = "Module" + (modulesWithoutAnnotations.size() == 1 ? " " : "s ");
            message2 = message2 + StringUtil.join(modulesWithoutAnnotations, Module::getName, (String)", ");
            message2 = message2 + (modulesWithoutAnnotations.size() == 1 ? " doesn't" : " don't");
            message2 = message2 + " refer to the existing '" + annotationsLib.getName() + "' library with IntelliJ IDEA nullity annotations. Would you like to add the dependenc";
            if (Messages.showOkCancelDialog((Project)project, (String)(message2 = message2 + (modulesWithoutAnnotations.size() == 1 ? "y" : "ies") + " now?"), (String)title, (Icon)Messages.getErrorIcon()) == 0) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    for (Module module : modulesWithoutAnnotations) {
                        ModuleRootModificationUtil.addDependency((Module)module, (Library)annotationsLib);
                    }
                });
                return true;
            }
            return false;
        }
        if (Messages.showOkCancelDialog((Project)project, (String)"JetBrains annotations library is missing.\nWithout the library, IntelliJ IDEA cannot run the analysis. Would you like to add it?", (String)title, (Icon)Messages.getErrorIcon()) == 0) {
            Module firstModule = modulesWithoutAnnotations.iterator().next();
            JavaProjectModelModificationService.getInstance(project).addDependency(modulesWithoutAnnotations, JetBrainsAnnotationsExternalLibraryResolver.getAnnotationsLibraryDescriptor(firstModule), DependencyScope.COMPILE);
            return true;
        }
        return false;
    }

    @Nullable
    protected UsageInfo[] findUsages(final @NotNull Project project, @NotNull AnalysisScope scope, final int fileCount) {
        final NullityInferrer inferrer = new NullityInferrer(this.isAnnotateLocalVariables(), project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        Runnable searchForUsages = () -> scope.accept(new PsiElementVisitor(){
            int myFileCount;

            public void visitFile(PsiFile file) {
                Document document;
                ++this.myFileCount;
                VirtualFile virtualFile = file.getVirtualFile();
                FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                if (document == null || virtualFile.getFileType().isBinary()) {
                    return;
                }
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                    progressIndicator.setFraction((double)this.myFileCount / (double)fileCount);
                }
                if (file instanceof PsiJavaFile) {
                    inferrer.collect(file);
                }
            }
        });
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(searchForUsages, INFER_NULLITY_ANNOTATIONS, true, project)) {
                return null;
            }
        } else {
            searchForUsages.run();
        }
        ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        inferrer.collect(usages);
        return usages.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected boolean isAnnotateLocalVariables() {
        return this.myAnnotateLocalVariablesCb.isSelected();
    }

    private static Runnable applyRunnable(Project project, Computable<UsageInfo[]> computable) {
        return () -> {
            LocalHistoryAction action = LocalHistory.getInstance().startAction(INFER_NULLITY_ANNOTATIONS);
            try {
                WriteCommandAction.writeCommandAction((Project)project).withName(INFER_NULLITY_ANNOTATIONS).run(() -> {
                    UsageInfo[] infos = (UsageInfo[])computable.compute();
                    if (infos.length > 0) {
                        LinkedHashSet elements = new LinkedHashSet();
                        for (UsageInfo info : infos) {
                            PsiElement element = info.getElement();
                            if (element == null) continue;
                            ContainerUtil.addIfNotNull(elements, (Object)element.getContainingFile());
                        }
                        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
                            return;
                        }
                        SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, INFER_NULLITY_ANNOTATIONS, false);
                        progressTask.setMinIterationTime(200L);
                        progressTask.setTask((SequentialTask)new AnnotateTask(project, progressTask, infos));
                        ProgressManager.getInstance().run((Task)progressTask);
                    } else {
                        NullityInferrer.nothingFoundMessage(project);
                    }
                });
            }
            finally {
                action.finish();
            }
        };
    }

    protected void restartAnalysis(Project project, AnalysisScope scope) {
        AppUIExecutor.onUiThread().inSmartMode(project).inTransaction((Disposable)project).execute(() -> this.analyze(project, scope));
    }

    private void showUsageView(@NotNull Project project, UsageInfo[] usageInfos, @NotNull AnalysisScope scope) {
        UsageTarget[] targets = UsageTarget.EMPTY_ARRAY;
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), "Preprocess Usages", true, project)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTabText("Infer Nullity Preview");
        presentation.setShowReadOnlyStatusAsRed(true);
        presentation.setShowCancelButton(true);
        presentation.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        UsageView usageView = UsageViewManager.getInstance((Project)project).showUsages(targets, usages, presentation, this.rerunFactory(project, scope));
        Runnable refactoringRunnable = InferNullityAnnotationsAction.applyRunnable(project, (Computable<UsageInfo[]>)((Computable)() -> {
            Set infos = UsageViewUtil.getNotExcludedUsageInfos((UsageView)usageView);
            return infos.toArray(UsageInfo.EMPTY_ARRAY);
        }));
        String canNotMakeString = "Cannot perform operation.\nThere were changes in code after usages have been found.\nPlease perform operation search again.";
        usageView.addPerformOperationAction(refactoringRunnable, INFER_NULLITY_ANNOTATIONS, canNotMakeString, INFER_NULLITY_ANNOTATIONS, false);
    }

    @NotNull
    private Factory<UsageSearcher> rerunFactory(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        return () -> new UsageInfoSearcherAdapter(){

            @NotNull
            protected UsageInfo[] findUsages() {
                return (UsageInfo[])ObjectUtils.notNull((Object)InferNullityAnnotationsAction.this.findUsages(project, scope, scope.getFileCount()), (Object)UsageInfo.EMPTY_ARRAY);
            }

            public void generate(@NotNull Processor<Usage> processor) {
                this.processUsages(processor, project);
            }
        };
    }

    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new TitledSeparator());
        this.myAnnotateLocalVariablesCb = new JCheckBox("Annotate local variables", PropertiesComponent.getInstance().getBoolean(ANNOTATE_LOCAL_VARIABLES));
        panel.add(this.myAnnotateLocalVariablesCb);
        return panel;
    }

    protected void canceled() {
        super.canceled();
        this.myAnnotateLocalVariablesCb = null;
    }
}

