/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.intermediaryVariable;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.HighlightUtils;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReturnSeparatedFromComputationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(ReturnSeparatedFromComputationInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitReturnStatement(PsiReturnStatement returnStatement) {
                super.visitReturnStatement(returnStatement);
                ReturnContext context = ReturnSeparatedFromComputationInspection.createReturnContext(returnStatement);
                if (context != null && ReturnSeparatedFromComputationInspection.isApplicable(context)) {
                    ReturnSeparatedFromComputationInspection.registerProblem(holder, returnStatement, context.returnedVariable, isOnTheFly);
                }
            }
        };
    }

    private static ReturnContext createReturnContext(PsiReturnStatement returnStatement) {
        PsiVariable returnedVariable;
        PsiCodeBlock variableScope;
        PsiElement resolved;
        PsiExpression returnValue;
        PsiStatement refactoredStatement;
        PsiType returnType;
        PsiCodeBlock returnScope;
        PsiStatement[] statements;
        PsiElement returnParent = returnStatement.getParent();
        if (returnParent instanceof PsiCodeBlock && (statements = (returnScope = (PsiCodeBlock)returnParent).getStatements()).length != 0 && statements[statements.length - 1] == returnStatement && (returnType = PsiTypesUtil.getMethodReturnType((PsiElement)returnStatement)) != null && (refactoredStatement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)returnStatement, null)) != null && (returnValue = PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue())) instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiVariable && (variableScope = ReturnSeparatedFromComputationInspection.getVariableScopeBlock(returnedVariable = (PsiVariable)resolved)) != null) {
            return new ReturnContext(returnStatement, returnScope, returnType, refactoredStatement, returnedVariable, variableScope);
        }
        return null;
    }

    @Nullable
    private static PsiCodeBlock getVariableScopeBlock(@Nullable PsiVariable variable) {
        if (variable instanceof PsiLocalVariable) {
            PsiElement variableScope = RefactoringUtil.getVariableScope((PsiLocalVariable)variable);
            if (variableScope instanceof PsiCodeBlock) {
                return (PsiCodeBlock)variableScope;
            }
        } else if (variable instanceof PsiParameter) {
            PsiElement lambdaBody;
            PsiParameter parameter2 = (PsiParameter)variable;
            PsiElement parameterScope = parameter2.getDeclarationScope();
            if (parameterScope instanceof PsiMethod) {
                return ((PsiMethod)parameterScope).getBody();
            }
            if (parameterScope instanceof PsiLambdaExpression && (lambdaBody = ((PsiLambdaExpression)parameterScope).getBody()) instanceof PsiCodeBlock) {
                return (PsiCodeBlock)lambdaBody;
            }
        }
        return null;
    }

    private static boolean hasChainedAssignmentsInScope(@NotNull ControlFlow flow, @NotNull PsiVariable variable, @NotNull PsiStatement lastStatementInScope) {
        PsiStatement statement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)lastStatementInScope, null);
        while (statement != null) {
            PsiAssignmentExpression assignmentExpression;
            PsiExpressionStatement expressionStatement;
            PsiExpression expression2;
            if (statement instanceof PsiExpressionStatement && (expression2 = (expressionStatement = (PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression && ReturnSeparatedFromComputationInspection.isVariableUsed(flow, (PsiElement)(assignmentExpression = (PsiAssignmentExpression)expression2).getLExpression(), variable) && ReturnSeparatedFromComputationInspection.isVariableUsed(flow, (PsiElement)assignmentExpression.getRExpression(), variable)) {
                return true;
            }
            statement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)statement, null);
        }
        return false;
    }

    private static boolean isVariableUsed(@NotNull ControlFlow flow, @Nullable PsiElement element, @NotNull PsiVariable variable) {
        if (element == null) {
            return false;
        }
        int startOffset = flow.getStartOffset(element);
        int endOffset = flow.getEndOffset(element);
        if (startOffset < 0 || endOffset < 0) {
            return true;
        }
        return ControlFlowUtil.isVariableUsed(flow, startOffset, endOffset, variable);
    }

    private static boolean isApplicable(@NotNull ReturnContext context) {
        ControlFlow flow = ReturnSeparatedFromComputationInspection.createControlFlow(context);
        return flow != null && ReturnSeparatedFromComputationInspection.isApplicable(flow, context);
    }

    @Nullable
    private static ControlFlow createControlFlow(@NotNull ReturnContext context) {
        try {
            LocalsControlFlowPolicy policy = new LocalsControlFlowPolicy((PsiElement)context.variableScope);
            return ControlFlowFactory.getInstance(context.variableScope.getProject()).getControlFlow((PsiElement)context.variableScope, policy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    private static boolean isApplicable(@NotNull ControlFlow flow, @NotNull ReturnContext context) {
        if (ReturnSeparatedFromComputationInspection.hasChainedAssignmentsInScope(flow, context.returnedVariable, (PsiStatement)context.returnStatement)) {
            return false;
        }
        if (context.returnScope != context.variableScope) {
            if (ControlFlowUtil.isVariableReadInFinally(flow, (PsiElement)context.returnScope, (PsiElement)context.variableScope, context.returnedVariable)) {
                return false;
            }
            int flowStart = flow.getStartOffset((PsiElement)context.returnScope);
            int flowEnd = flow.getEndOffset((PsiElement)context.returnScope);
            if (flowStart < 0 || flowEnd < 0) {
                return false;
            }
            if (ControlFlowUtil.hasObservableThrowExitPoints(flow, flowStart, flowEnd, new PsiElement[]{context.refactoredStatement}, (PsiElement)context.variableScope)) {
                return false;
            }
        }
        Mover mover = new Mover(flow, context.refactoredStatement, context.returnedVariable, context.returnType, true);
        mover.moveTo(context.refactoredStatement, true);
        return !mover.isEmpty();
    }

    private static void doApply(PsiReturnStatement returnStatement, boolean isOnTheFly) {
        ControlFlow flow;
        ReturnContext context = ReturnSeparatedFromComputationInspection.createReturnContext(returnStatement);
        if (context != null && (flow = ReturnSeparatedFromComputationInspection.createControlFlow(context)) != null) {
            Mover mover = new Mover(flow, context.refactoredStatement, context.returnedVariable, context.returnType, false);
            boolean removeReturn = mover.moveTo(context.refactoredStatement, true);
            if (!mover.isEmpty()) {
                Highlighter highlighter = new Highlighter();
                ReturnSeparatedFromComputationInspection.applyChanges(mover, context, removeReturn, highlighter);
                ReturnSeparatedFromComputationInspection.deleteRedundantVariable(context, highlighter);
                if (isOnTheFly) {
                    highlighter.highlight();
                }
            }
        }
    }

    private static void deleteRedundantVariable(@NotNull ReturnContext context, Highlighter highlighter) {
        boolean isSingleUsage;
        PsiExpression value2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)context.returnedVariable.getInitializer());
        boolean isConstant = value2 instanceof PsiLiteralExpression || value2 instanceof PsiThisExpression || PsiUtil.isConstantExpression((PsiExpression)value2);
        boolean isSimple = ReturnSeparatedFromComputationInspection.isSimpleExpression(value2, (PsiElement)context.returnScope);
        if (value2 != null && !isConstant && !isSimple) {
            return;
        }
        Query query = ReferencesSearch.search((PsiElement)context.returnedVariable, (SearchScope)new LocalSearchScope((PsiElement)context.variableScope));
        Collection usages = query.findAll();
        for (PsiReference usage : usages) {
            PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)usage.getElement(), (Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class});
            if (parent instanceof PsiReturnStatement) continue;
            return;
        }
        PsiExpression firstInlined = null;
        boolean bl = isSingleUsage = value2 != null && usages.size() == 1;
        if (isSimple || isSingleUsage) {
            for (PsiReference usage : usages) {
                PsiExpression inlined2 = InlineUtil.inlineVariable(context.returnedVariable, value2, (PsiJavaCodeReferenceElement)usage);
                if (firstInlined == null) {
                    firstInlined = inlined2;
                }
                highlighter.add((PsiElement)inlined2);
            }
        }
        if (isSimple || isSingleUsage || usages.isEmpty()) {
            CommentTracker tracker = new CommentTracker();
            if (firstInlined != null) {
                tracker.delete((PsiElement)context.returnedVariable);
                tracker.insertCommentsBefore((PsiElement)firstInlined);
            } else {
                tracker.deleteAndRestoreComments((PsiElement)context.returnedVariable);
            }
        }
    }

    @Contract(value="null,_ -> false")
    private static boolean isSimpleExpression(@Nullable PsiExpression expression2, @NotNull PsiElement scope) {
        if (expression2 instanceof PsiReferenceExpression) {
            PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)expression2).resolve(), PsiVariable.class);
            return variable != null && (variable.hasModifierProperty("final") || HighlightControlFlowUtil.isEffectivelyFinal(variable, scope, null));
        }
        if (expression2 instanceof PsiUnaryExpression) {
            return ((PsiUnaryExpression)expression2).getOperand() instanceof PsiLiteralExpression;
        }
        return expression2 instanceof PsiLiteralExpression || expression2 instanceof PsiThisExpression || expression2 instanceof PsiClassObjectAccessExpression;
    }

    private static void applyChanges(@NotNull Mover mover, @NotNull ReturnContext context, boolean removeReturn, Highlighter highlighter) {
        for (PsiElement anchor : mover.insertBefore) {
            PsiElement added = anchor.getParent().addBefore((PsiElement)context.returnStatement, anchor);
            highlighter.add(added);
        }
        mover.replaceInline.forEach(e -> {
            if (e instanceof PsiBreakStatement) {
                ReturnSeparatedFromComputationInspection.replaceStatementKeepComments((PsiStatement)((PsiBreakStatement)e), context.returnStatement, highlighter);
            } else if (e instanceof PsiAssignmentExpression) {
                ReturnSeparatedFromComputationInspection.inlineAssignment((PsiAssignmentExpression)e, context.returnStatement, highlighter);
            }
        });
        mover.removeCompletely.forEach(e -> ReturnSeparatedFromComputationInspection.removeElementKeepComments(e));
        if (removeReturn) {
            ReturnSeparatedFromComputationInspection.removeReturn(context);
        }
    }

    private static void removeReturn(@NotNull ReturnContext context) {
        THashSet skippedEmptyStatements = new THashSet();
        ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)context.returnStatement, (Set<? super PsiElement>)skippedEmptyStatements);
        skippedEmptyStatements.forEach(PsiElement::delete);
        ReturnSeparatedFromComputationInspection.removeElementKeepComments((PsiElement)context.returnStatement);
    }

    private static void inlineAssignment(PsiAssignmentExpression assignmentExpression, PsiReturnStatement returnStatement, Highlighter highlighter) {
        PsiElement assignmentParent = assignmentExpression.getParent();
        LOG.assertTrue(assignmentParent instanceof PsiExpressionStatement, (Object)"PsiExpressionStatement");
        PsiReturnStatement returnStatementCopy = (PsiReturnStatement)returnStatement.copy();
        PsiExpression rExpression = assignmentExpression.getRExpression();
        PsiExpression returnValue = returnStatementCopy.getReturnValue();
        if (rExpression != null && returnValue != null) {
            returnValue.replace((PsiElement)rExpression);
            ReturnSeparatedFromComputationInspection.replaceStatementKeepComments((PsiStatement)((PsiExpressionStatement)assignmentParent), returnStatementCopy, highlighter);
        }
    }

    private static void replaceStatementKeepComments(PsiStatement replacedStatement, PsiReturnStatement returnStatement, Highlighter highlighter) {
        highlighter.add(new CommentTracker().replaceAndRestoreComments((PsiElement)replacedStatement, (PsiElement)returnStatement));
    }

    private static void removeElementKeepComments(PsiElement removedElement) {
        new CommentTracker().deleteAndRestoreComments(removedElement);
    }

    @Nullable
    private static PsiStatement getPrevNonEmptyStatement(@Nullable PsiElement psiElement, @Nullable Set<? super PsiElement> skippedEmptyStatements) {
        if (psiElement == null || !(psiElement.getParent() instanceof PsiCodeBlock)) {
            return null;
        }
        PsiStatement prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)psiElement, PsiStatement.class);
        ArrayList<PsiStatement> skipped = new ArrayList<PsiStatement>();
        while (prevStatement instanceof PsiEmptyStatement) {
            skipped.add(prevStatement);
            prevStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevStatement, PsiStatement.class);
        }
        if (prevStatement != null && skippedEmptyStatements != null) {
            skippedEmptyStatements.addAll(skipped);
        }
        return prevStatement;
    }

    @Nullable
    private static PsiStatement getNearestEnclosingStatement(@Nullable PsiElement element) {
        return element instanceof PsiStatement ? (PsiStatement)element : (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
    }

    private static void registerProblem(@NotNull ProblemsHolder holder, @NotNull PsiReturnStatement returnStatement, @NotNull PsiVariable variable, boolean isOnTheFly) {
        String name = variable.getName();
        holder.registerProblem((PsiElement)returnStatement, InspectionsBundle.message((String)"inspection.return.separated.from.computation.descriptor", (Object[])new Object[]{name}), new LocalQuickFix[]{new VariableFix(name, isOnTheFly)});
    }

    private static class Highlighter {
        private final List<PsiElement> myElements = new ArrayList<PsiElement>();

        private Highlighter() {
        }

        public void add(@NotNull PsiElement element) {
            PsiExpression value2;
            if (element instanceof PsiReturnStatement && (value2 = ((PsiReturnStatement)element).getReturnValue()) != null) {
                this.myElements.add((PsiElement)value2);
                return;
            }
            this.myElements.add(element);
        }

        public void highlight() {
            List validElements = ContainerUtil.filter(this.myElements, PsiElement::isValid);
            HighlightUtils.highlightElements(validElements);
        }
    }

    private static class ReturnContext {
        final PsiReturnStatement returnStatement;
        final PsiCodeBlock returnScope;
        final PsiType returnType;
        final PsiStatement refactoredStatement;
        final PsiVariable returnedVariable;
        final PsiCodeBlock variableScope;

        private ReturnContext(@NotNull PsiReturnStatement returnStatement, @NotNull PsiCodeBlock returnScope, @NotNull PsiType returnType, @NotNull PsiStatement refactoredStatement, @NotNull PsiVariable returnedVariable, @NotNull PsiCodeBlock variableScope) {
            this.returnStatement = returnStatement;
            this.returnScope = returnScope;
            this.returnType = returnType;
            this.refactoredStatement = refactoredStatement;
            this.returnedVariable = returnedVariable;
            this.variableScope = variableScope;
        }
    }

    private static class VariableFix
    implements LocalQuickFix {
        private final String myName;
        private final boolean myIsOnTheFly;

        VariableFix(String name, boolean isOnTheFly) {
            this.myName = name;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.return.separated.from.computation.quickfix", (Object[])new Object[]{this.myName});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.return.separated.from.computation.family.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiReturnStatement) {
                ReturnSeparatedFromComputationInspection.doApply((PsiReturnStatement)element, this.myIsOnTheFly);
            }
        }
    }

    private static class Mover {
        final ControlFlow flow;
        final PsiStatement enclosingStatement;
        final PsiVariable resultVariable;
        final PsiType returnType;
        final boolean checkingApplicability;
        final Set<PsiElement> insertBefore = new THashSet();
        final Set<PsiElement> replaceInline = new THashSet();
        final Set<PsiElement> removeCompletely = new THashSet();
        private Map<PsiStatement, Set<PsiBreakStatement>> breakStatements;

        private Mover(@NotNull ControlFlow flow, @NotNull PsiStatement enclosingStatement, @NotNull PsiVariable resultVariable, PsiType returnType, boolean checkingApplicability) {
            this.flow = flow;
            this.enclosingStatement = enclosingStatement;
            this.resultVariable = resultVariable;
            this.returnType = returnType;
            this.checkingApplicability = checkingApplicability;
        }

        boolean isEmpty() {
            return this.insertBefore.isEmpty() && this.replaceInline.isEmpty();
        }

        boolean moveTo(PsiStatement targetStatement, boolean returnAtTheEnd) {
            if (this.checkingApplicability && !this.isEmpty()) {
                return false;
            }
            if (targetStatement instanceof PsiBlockStatement) {
                return this.moveToBlock((PsiBlockStatement)targetStatement, returnAtTheEnd);
            }
            if (targetStatement instanceof PsiIfStatement) {
                return this.moveToIf((PsiIfStatement)targetStatement);
            }
            if (targetStatement instanceof PsiForStatement) {
                return this.moveToFor((PsiForStatement)targetStatement);
            }
            if (targetStatement instanceof PsiWhileStatement) {
                return this.moveToWhile((PsiWhileStatement)targetStatement);
            }
            if (targetStatement instanceof PsiDoWhileStatement) {
                return this.moveToDoWhile((PsiDoWhileStatement)targetStatement);
            }
            if (targetStatement instanceof PsiForeachStatement) {
                return this.moveToForeach((PsiForeachStatement)targetStatement);
            }
            if (targetStatement instanceof PsiSwitchStatement) {
                return this.moveToSwitch((PsiSwitchStatement)targetStatement);
            }
            if (targetStatement instanceof PsiTryStatement) {
                return this.moveToTry((PsiTryStatement)targetStatement, returnAtTheEnd);
            }
            if (targetStatement instanceof PsiLabeledStatement) {
                return this.moveToLabeled((PsiLabeledStatement)targetStatement, returnAtTheEnd);
            }
            if (targetStatement instanceof PsiExpressionStatement) {
                return this.inlineExpression((PsiExpressionStatement)targetStatement);
            }
            return targetStatement instanceof PsiThrowStatement || targetStatement instanceof PsiReturnStatement || targetStatement instanceof PsiBreakStatement || targetStatement instanceof PsiContinueStatement;
        }

        private boolean moveToBlock(@NotNull PsiBlockStatement targetStatement, boolean returnAtTheEnd) {
            return this.moveToBlockBody(targetStatement.getCodeBlock(), returnAtTheEnd);
        }

        private boolean moveToBlockBody(@NotNull PsiCodeBlock codeBlock, boolean returnAtTheEnd) {
            PsiJavaToken rBrace = codeBlock.getRBrace();
            if (rBrace != null) {
                PsiStatement lastNonEmptyStatement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)rBrace, this.removeCompletely);
                if (lastNonEmptyStatement == null) {
                    return false;
                }
                if (this.moveTo(lastNonEmptyStatement, returnAtTheEnd)) {
                    return true;
                }
                if (returnAtTheEnd) {
                    this.insertBefore.add((PsiElement)rBrace);
                    return true;
                }
            }
            return false;
        }

        private boolean moveToIf(@NotNull PsiIfStatement targetStatement) {
            PsiStatement thenBranch = targetStatement.getThenBranch();
            PsiStatement elseBranch = targetStatement.getElseBranch();
            boolean thenPart = thenBranch != null && this.moveTo(thenBranch, false);
            boolean elsePart = elseBranch != null && this.moveTo(elseBranch, false);
            return thenPart && elsePart;
        }

        private boolean moveToFor(@NotNull PsiForStatement targetStatement) {
            this.moveToBreaks((PsiStatement)targetStatement, false);
            return Mover.isAlwaysTrue(targetStatement.getCondition(), true);
        }

        private boolean moveToDoWhile(@NotNull PsiDoWhileStatement targetStatement) {
            this.moveToBreaks((PsiStatement)targetStatement, false);
            return Mover.isAlwaysTrue(targetStatement.getCondition(), false);
        }

        private boolean moveToWhile(@NotNull PsiWhileStatement targetStatement) {
            this.moveToBreaks((PsiStatement)targetStatement, false);
            return Mover.isAlwaysTrue(targetStatement.getCondition(), false);
        }

        private boolean moveToForeach(@NotNull PsiForeachStatement targetStatement) {
            this.moveToBreaks((PsiStatement)targetStatement, false);
            return false;
        }

        private boolean moveToSwitch(@NotNull PsiSwitchStatement targetStatement) {
            this.moveToBreaks((PsiStatement)targetStatement, false);
            PsiCodeBlock body2 = targetStatement.getBody();
            return body2 != null && this.moveToBlockBody(body2, false) && Mover.hasDefaultSwitchLabel(body2);
        }

        private boolean moveToTry(@NotNull PsiTryStatement targetStatement, boolean returnAtTheEnd) {
            PsiCatchSection[] catchSections;
            PsiCodeBlock tryBlock = targetStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            PsiCodeBlock finallyBlock = targetStatement.getFinallyBlock();
            if (ReturnSeparatedFromComputationInspection.isVariableUsed(this.flow, (PsiElement)finallyBlock, this.resultVariable)) {
                return false;
            }
            boolean allCatchesReturn = true;
            for (PsiCatchSection catchSection : catchSections = targetStatement.getCatchSections()) {
                PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                if (catchBlock != null && this.moveToBlockBody(catchBlock, false)) continue;
                allCatchesReturn = false;
            }
            return this.moveToBlockBody(tryBlock, returnAtTheEnd && allCatchesReturn) && allCatchesReturn;
        }

        private boolean moveToLabeled(@NotNull PsiLabeledStatement targetStatement, boolean returnAtTheEnd) {
            PsiStatement statement = targetStatement.getStatement();
            if (statement == null) {
                return false;
            }
            this.moveToBreaks(statement, false);
            return this.moveTo(statement, returnAtTheEnd);
        }

        private boolean inlineExpression(@NotNull PsiExpressionStatement statement) {
            PsiExpression expression2 = statement.getExpression();
            if (expression2 instanceof PsiAssignmentExpression) {
                PsiType rExpressionType;
                PsiExpression rExpression;
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression2;
                PsiExpression lExpression = assignmentExpression.getLExpression();
                if (assignmentExpression.getOperationTokenType() == JavaTokenType.EQ && Mover.isReferenceTo(lExpression, this.resultVariable) && (rExpression = assignmentExpression.getRExpression()) != null && (rExpressionType = rExpression.getType()) != null && this.returnType.isAssignableFrom(rExpressionType)) {
                    this.replaceInline.add((PsiElement)assignmentExpression);
                    return true;
                }
            }
            return false;
        }

        private void moveToBreaks(@NotNull PsiStatement targetStatement, boolean returnAtTheEnd) {
            Set<PsiBreakStatement> breaks = this.getBreaks(targetStatement);
            for (PsiBreakStatement breakStatement : breaks) {
                PsiStatement prevNonEmptyStatement = ReturnSeparatedFromComputationInspection.getPrevNonEmptyStatement((PsiElement)breakStatement, this.removeCompletely);
                if (prevNonEmptyStatement == null || !this.moveTo(prevNonEmptyStatement, returnAtTheEnd)) {
                    this.replaceInline.add((PsiElement)breakStatement);
                    continue;
                }
                this.removeCompletely.add((PsiElement)breakStatement);
            }
        }

        private static boolean hasDefaultSwitchLabel(@NotNull PsiCodeBlock switchBody) {
            for (PsiStatement statement : switchBody.getStatements()) {
                if (!(statement instanceof PsiSwitchLabelStatement) || !((PsiSwitchLabelStatement)statement).isDefaultCase()) continue;
                return true;
            }
            return false;
        }

        private static boolean isAlwaysTrue(@Nullable PsiExpression condition2, boolean nullIsTrue) {
            if (condition2 == null) {
                return nullIsTrue;
            }
            return ExpressionUtils.computeConstantExpression(condition2) == Boolean.TRUE;
        }

        private Set<PsiBreakStatement> getBreaks(@NotNull PsiStatement targetStatement) {
            Set<PsiBreakStatement> breaks;
            if (this.breakStatements == null) {
                this.breakStatements = new THashMap();
                List<Instruction> instructions = this.flow.getInstructions();
                for (int i = 0; i < instructions.size(); ++i) {
                    PsiStatement exitedStatement;
                    PsiElement element = this.flow.getElement(i);
                    PsiStatement statement = ReturnSeparatedFromComputationInspection.getNearestEnclosingStatement(element);
                    if (!(statement instanceof PsiBreakStatement) || (exitedStatement = ((PsiBreakStatement)statement).findExitedStatement()) == null) continue;
                    this.breakStatements.computeIfAbsent(exitedStatement, unused -> new THashSet()).add((PsiBreakStatement)statement);
                }
            }
            return (breaks = this.breakStatements.get(targetStatement)) != null ? breaks : Collections.emptySet();
        }

        private static boolean isReferenceTo(PsiExpression expression2, PsiVariable variable) {
            PsiReferenceExpression referenceExpression;
            return expression2 instanceof PsiReferenceExpression && !(referenceExpression = (PsiReferenceExpression)expression2).isQualified() && referenceExpression.resolve() == variable;
        }
    }
}

