/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.CountingLoop;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.IndexedContainer;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class Java8ArraySetAllInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java8ArraySetAllInspection.class);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitForStatement(PsiForStatement statement) {
                super.visitForStatement(statement);
                CountingLoop loop = CountingLoop.from(statement);
                if (loop == null || loop.isIncluding() || loop.isDescending()) {
                    return;
                }
                if (!ExpressionUtils.isZero(loop.getInitializer())) {
                    return;
                }
                IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
                if (container == null || !(container.getQualifier().getType() instanceof PsiArrayType)) {
                    return;
                }
                if (!StreamApiUtil.isSupportedStreamElement(container.getElementType())) {
                    return;
                }
                PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
                if (assignment == null) {
                    return;
                }
                PsiExpression index = container.extractIndexFromGetExpression(assignment.getLExpression());
                if (!ExpressionUtils.isReferenceTo(index, (PsiVariable)loop.getCounter())) {
                    return;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)assignment.getRExpression(), Predicate.isEqual(loop.getCounter()))) {
                    return;
                }
                PsiStatement initialization = statement.getInitialization();
                LOG.assertTrue(initialization != null);
                TextRange range = TextRange.from((int)initialization.getStartOffsetInParent(), (int)initialization.getTextLength());
                boolean wholeStatement = isOnTheFly && InspectionProjectProfileManager.isInformationLevel((String)Java8ArraySetAllInspection.this.getShortName(), (PsiElement)statement);
                PsiJavaToken rParenth = statement.getRParenth();
                if (wholeStatement && rParenth != null) {
                    range = new TextRange(0, rParenth.getStartOffsetInParent() + 1);
                }
                holder.registerProblem((PsiElement)statement, range, InspectionsBundle.message((String)"inspection.replace.loop.with.arrays.setall.message", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithArraysSetAllFix()});
            }
        };
    }

    private static class ReplaceWithArraysSetAllFix
    implements LocalQuickFix {
        private ReplaceWithArraysSetAllFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.replace.loop.with.arrays.setall.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiForStatement statement = (PsiForStatement)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiForStatement.class);
            if (statement == null) {
                return;
            }
            CountingLoop loop = CountingLoop.from(statement);
            if (loop == null) {
                return;
            }
            IndexedContainer container = IndexedContainer.fromLengthExpression(loop.getBound());
            if (container == null) {
                return;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)ControlFlowUtils.stripBraces(statement.getBody()));
            if (assignment == null) {
                return;
            }
            PsiExpression rValue = assignment.getRExpression();
            if (rValue == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            String replacement = "java.util.Arrays.setAll(" + ct.text((PsiElement)container.getQualifier()) + ", " + loop.getCounter().getName() + "->" + ct.text((PsiElement)rValue) + ");";
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)statement, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            result = JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }
    }
}

