/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18api;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IteratorDeclaration;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java8CollectionRemoveIfInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!JavaFeature.ADVANCED_COLLECTIONS_API.isFeatureSupported(holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            void handleIteratorLoop(PsiLoopStatement statement, PsiJavaToken endToken, IteratorDeclaration declaration2) {
                if (endToken == null || declaration2 == null || !declaration2.isCollection()) {
                    return;
                }
                PsiStatement body2 = statement.getBody();
                if (!(body2 instanceof PsiBlockStatement)) {
                    return;
                }
                PsiStatement[] statements = ((PsiBlockStatement)body2).getCodeBlock().getStatements();
                if (statements.length == 2 && statements[1] instanceof PsiIfStatement) {
                    PsiVariable element = declaration2.getNextElementVariable(statements[0]);
                    if (element == null) {
                        return;
                    }
                    PsiIfStatement ifStatement = (PsiIfStatement)statements[1];
                    if (this.checkAndExtractCondition(declaration2, ifStatement) == null) {
                        return;
                    }
                    this.registerProblem(statement, endToken);
                } else if (statements.length == 1 && statements[0] instanceof PsiIfStatement) {
                    PsiIfStatement ifStatement = (PsiIfStatement)statements[0];
                    PsiExpression condition2 = this.checkAndExtractCondition(declaration2, ifStatement);
                    if (condition2 == null) {
                        return;
                    }
                    PsiElement ref = declaration2.findOnlyIteratorRef(condition2);
                    if (ref != null && declaration2.isIteratorMethodCall(ref.getParent().getParent(), "next") && this.isAlwaysExecuted(condition2, ref)) {
                        this.registerProblem(statement, endToken);
                    }
                }
            }

            private boolean isAlwaysExecuted(PsiExpression condition2, PsiElement ref) {
                while (ref != condition2) {
                    PsiPolyadicExpression polyadicExpression;
                    IElementType type2;
                    PsiElement parent = ref.getParent();
                    if (parent instanceof PsiPolyadicExpression && ((type2 = (polyadicExpression = (PsiPolyadicExpression)parent).getOperationTokenType()).equals(JavaTokenType.ANDAND) || type2.equals(JavaTokenType.OROR)) && polyadicExpression.getOperands()[0] != ref) {
                        return false;
                    }
                    if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() != ref) {
                        return false;
                    }
                    ref = parent;
                }
                return true;
            }

            private void registerProblem(PsiLoopStatement statement, PsiJavaToken endToken) {
                holder.registerProblem((PsiElement)statement, new TextRange(0, endToken.getTextOffset() - statement.getTextOffset() + 1), QuickFixBundle.message("java.8.collection.removeif.inspection.description", new Object[0]), new LocalQuickFix[]{new ReplaceWithRemoveIfQuickFix()});
            }

            @Nullable
            private PsiExpression checkAndExtractCondition(IteratorDeclaration declaration2, PsiIfStatement ifStatement) {
                PsiVariable iterableVariable;
                PsiExpression condition2 = ifStatement.getCondition();
                if (condition2 == null || ifStatement.getElseBranch() != null) {
                    return null;
                }
                PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
                if (!(thenStatement instanceof PsiExpressionStatement)) {
                    return null;
                }
                if (!declaration2.isIteratorMethodCall((PsiElement)((PsiExpressionStatement)thenStatement).getExpression(), "remove")) {
                    return null;
                }
                if (!LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)condition2)) {
                    return null;
                }
                PsiReferenceExpression iterable = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)declaration2.getIterable()), PsiReferenceExpression.class);
                PsiVariable psiVariable = iterableVariable = iterable != null ? (PsiVariable)ObjectUtils.tryCast((Object)iterable.resolve(), PsiVariable.class) : null;
                if (iterableVariable != null && VariableAccessUtils.variableIsUsed(iterableVariable, (PsiElement)condition2)) {
                    return null;
                }
                return condition2;
            }

            public void visitForStatement(PsiForStatement statement) {
                super.visitForStatement(statement);
                IteratorDeclaration declaration2 = IteratorDeclaration.fromLoop((PsiLoopStatement)statement);
                this.handleIteratorLoop((PsiLoopStatement)statement, statement.getRParenth(), declaration2);
            }

            public void visitWhileStatement(PsiWhileStatement statement) {
                super.visitWhileStatement(statement);
                IteratorDeclaration declaration2 = IteratorDeclaration.fromLoop((PsiLoopStatement)statement);
                this.handleIteratorLoop((PsiLoopStatement)statement, statement.getRParenth(), declaration2);
            }
        };
    }

    private static class ReplaceWithRemoveIfQuickFix
    implements LocalQuickFix {
        private ReplaceWithRemoveIfQuickFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return QuickFixBundle.message("java.8.collection.removeif.inspection.fix.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            if (!(element instanceof PsiLoopStatement)) {
                return;
            }
            PsiLoopStatement loop = (PsiLoopStatement)element;
            IteratorDeclaration declaration2 = IteratorDeclaration.fromLoop(loop);
            if (declaration2 == null) {
                return;
            }
            PsiStatement body2 = loop.getBody();
            if (!(body2 instanceof PsiBlockStatement)) {
                return;
            }
            PsiStatement[] statements = ((PsiBlockStatement)body2).getCodeBlock().getStatements();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            String replacement = null;
            CommentTracker ct = new CommentTracker();
            if (statements.length == 2 && statements[1] instanceof PsiIfStatement) {
                PsiVariable variable = declaration2.getNextElementVariable(statements[0]);
                if (variable == null) {
                    return;
                }
                PsiExpression condition2 = ((PsiIfStatement)statements[1]).getCondition();
                if (condition2 == null) {
                    return;
                }
                replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf(declaration2, ct, condition2, variable.getName());
            } else if (statements.length == 1 && statements[0] instanceof PsiIfStatement) {
                PsiExpression condition3 = ((PsiIfStatement)statements[0]).getCondition();
                if (condition3 == null) {
                    return;
                }
                PsiElement ref = declaration2.findOnlyIteratorRef(condition3);
                if (ref != null) {
                    PsiElement call = ref.getParent().getParent();
                    if (!declaration2.isIteratorMethodCall(call, "next")) {
                        return;
                    }
                    PsiType type2 = ((PsiExpression)call).getType();
                    JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                    SuggestedNameInfo info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, null, null, type2);
                    if (info.names.length == 0) {
                        info = javaCodeStyleManager.suggestVariableName(VariableKind.PARAMETER, "value", null, type2);
                    }
                    String paramName = javaCodeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)info, (PsiElement)condition3, (boolean)true).names[0];
                    ct.replace(call, (PsiElement)factory.createIdentifier(paramName));
                    replacement = ReplaceWithRemoveIfQuickFix.generateRemoveIf(declaration2, ct, condition3, paramName);
                }
            }
            if (replacement == null) {
                return;
            }
            ct.delete((PsiElement)declaration2.getIterator());
            PsiElement result = ct.replaceAndRestoreComments((PsiElement)loop, replacement);
            LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
            CodeStyleManager.getInstance((Project)project).reformat(result);
        }

        @NotNull
        private static String generateRemoveIf(IteratorDeclaration declaration2, CommentTracker ct, PsiExpression condition2, String paramName) {
            return (declaration2.getIterable() == null ? "" : ct.text((PsiElement)declaration2.getIterable()) + ".") + "removeIf(" + paramName + "->" + ct.text((PsiElement)condition2) + ");";
        }
    }
}

