/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.visibility.EntryPointWithVisibilityLevel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9ModuleEntryPoint
extends EntryPointWithVisibilityLevel {
    public static final String ID = "moduleInfo";
    public boolean ADD_EXPORTED_PACKAGES_AND_SERVICES_TO_ENTRIES = true;

    @NotNull
    public String getDisplayName() {
        return "<html>Classes exposed with <code>module-info</code></html>";
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        PsiMethod method;
        if (psiElement instanceof PsiClass) {
            return Java9ModuleEntryPoint.isServiceOrExported((PsiClass)psiElement);
        }
        if (psiElement instanceof PsiMethod && (Java9ModuleEntryPoint.isDefaultConstructor(method = (PsiMethod)psiElement) || Java9ModuleEntryPoint.isProviderMethod(method))) {
            return Java9ModuleEntryPoint.isServiceOrExported(method.getContainingClass());
        }
        return false;
    }

    @Override
    public int getMinVisibilityLevel(PsiMember member) {
        PsiJavaModule javaModule;
        if (member instanceof PsiClass && (javaModule = Java9ModuleEntryPoint.getJavaModule((PsiElement)member)) != null && !Java9ModuleEntryPoint.isServiceClass((PsiClass)member, javaModule) && Java9ModuleEntryPoint.isInExportedPackage((PsiClass)member, javaModule)) {
            return 2;
        }
        return -1;
    }

    @Override
    public String getTitle() {
        return "Suggest package-private visibility level for classes in exported packages (Java 9+)";
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean keepVisibilityLevel(boolean entryPointEnabled, @NotNull RefJavaElement refJavaElement) {
        RefJavaModule refJavaModule;
        RefClass refClass;
        RefModule refModule;
        if (refJavaElement instanceof RefClass && (refModule = (refClass = (RefClass)refJavaElement).getModule()) != null && (refJavaModule = (RefJavaModule)RefJavaModule.JAVA_MODULE.get((UserDataHolder)refModule)) != null) {
            return Java9ModuleEntryPoint.isServiceClass(refClass, refJavaModule) || !entryPointEnabled && Java9ModuleEntryPoint.isInExportedPackage(refClass, refJavaModule);
        }
        return false;
    }

    private static boolean isInExportedPackage(@Nullable RefClass refClass, @NotNull RefJavaModule refJavaModule) {
        Map exportedPackageNames;
        RefClass refOwner = refClass;
        while (refOwner instanceof RefClass) {
            String modifier = refOwner.getAccessModifier();
            refOwner = "public".equals(modifier) || "protected".equals(modifier) ? refOwner.getOwner() : null;
        }
        return refOwner instanceof RefPackage && (exportedPackageNames = refJavaModule.getExportedPackageNames()).containsKey(refOwner.getQualifiedName());
    }

    private static boolean isServiceClass(@Nullable RefClass refClass, @NotNull RefJavaModule refJavaModule) {
        return refJavaModule.getServiceInterfaces().contains(refClass) || refJavaModule.getServiceImplementations().contains(refClass) || refJavaModule.getUsedServices().contains(refClass);
    }

    private static boolean isDefaultConstructor(@NotNull PsiMethod method) {
        return method.isConstructor() && method.getParameterList().isEmpty() && method.hasModifierProperty("public");
    }

    private static boolean isProviderMethod(@NotNull PsiMethod method) {
        return "provider".equals(method.getName()) && method.getParameterList().isEmpty() && method.hasModifierProperty("public") && method.hasModifierProperty("static");
    }

    private static boolean isServiceOrExported(@Nullable PsiClass psiClass) {
        PsiJavaModule javaModule = Java9ModuleEntryPoint.getJavaModule((PsiElement)psiClass);
        return javaModule != null && (Java9ModuleEntryPoint.isServiceClass(psiClass, javaModule) || Java9ModuleEntryPoint.isInExportedPackage(psiClass, javaModule));
    }

    private static boolean isInExportedPackage(@NotNull PsiClass psiClass, @NotNull PsiJavaModule javaModule) {
        Set<String> exportedPackageNames;
        String packageName = Java9ModuleEntryPoint.getPublicApiPackageName(psiClass);
        return packageName != null && (exportedPackageNames = Java9ModuleEntryPoint.getExportedPackageNames(javaModule)).contains(packageName);
    }

    private static boolean isServiceClass(@NotNull PsiClass psiClass, @NotNull PsiJavaModule javaModule) {
        Set serviceClassNames = (Set)CachedValuesManager.getCachedValue((PsiElement)javaModule, () -> CachedValueProvider.Result.create(Java9ModuleEntryPoint.collectServiceClassNames(javaModule), (Object[])new Object[]{javaModule}));
        return serviceClassNames.contains(psiClass.getQualifiedName());
    }

    @Contract(value="null -> null")
    @Nullable
    private static PsiJavaModule getJavaModule(@Nullable PsiElement element) {
        LanguageLevel languageLevel;
        if (element != null && (languageLevel = PsiUtil.getLanguageLevel((PsiElement)element)).isAtLeast(LanguageLevel.JDK_1_9)) {
            return JavaModuleGraphUtil.findDescriptorByElement(element);
        }
        return null;
    }

    private static String getPublicApiPackageName(PsiClass psiClass) {
        if (psiClass != null && (psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("protected"))) {
            PsiElement parent = psiClass.getParent();
            if (parent instanceof PsiClass) {
                return Java9ModuleEntryPoint.getPublicApiPackageName((PsiClass)parent);
            }
            if (parent instanceof PsiJavaFile) {
                return ((PsiJavaFile)parent).getPackageName();
            }
        }
        return null;
    }

    private static Set<String> getExportedPackageNames(@NotNull PsiJavaModule javaModule) {
        return (Set)CachedValuesManager.getCachedValue((PsiElement)javaModule, () -> {
            Set packages = (Set)StreamEx.of(javaModule.getExports().iterator()).map(e -> e.getPackageName()).nonNull().toCollection(THashSet::new);
            return CachedValueProvider.Result.create((Object)packages, (Object[])new Object[]{javaModule});
        });
    }

    @NotNull
    private static Set<String> collectServiceClassNames(@NotNull PsiJavaModule javaModule) {
        Set classes2 = (Set)StreamEx.of(javaModule.getProvides().spliterator()).map(PsiProvidesStatement::getImplementationList).nonNull().map(PsiReferenceList::getReferenceElements).flatMap(Arrays::stream).map(PsiJavaCodeReferenceElement::getQualifiedName).nonNull().toCollection(THashSet::new);
        Set usages = (Set)StreamEx.of(javaModule.getUses().iterator()).map(PsiUsesStatement::getClassReference).nonNull().map(PsiJavaCodeReferenceElement::getQualifiedName).nonNull().toCollection(THashSet::new);
        classes2.addAll(usages);
        return classes2;
    }

    public boolean isSelected() {
        return this.ADD_EXPORTED_PACKAGES_AND_SERVICES_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_EXPORTED_PACKAGES_AND_SERVICES_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        XmlSerializer.deserializeInto((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        XmlSerializer.serializeInto((Object)((Object)this), (Element)element, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
    }
}

