/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class Java9ModuleExportsPackageToItselfInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return PsiUtil.isModuleFile((PsiFile)holder.getFile()) ? new ExportedToSelfVisitor(holder) : PsiElementVisitor.EMPTY_VISITOR;
    }

    private static class ExportedToSelfVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        ExportedToSelfVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitPackageAccessibilityStatement(PsiPackageAccessibilityStatement statement) {
            super.visitPackageAccessibilityStatement(statement);
            PsiJavaModule javaModule = (PsiJavaModule)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiJavaModule.class);
            if (javaModule != null) {
                String moduleName = javaModule.getName();
                ArrayList references = ContainerUtil.newArrayList((Iterable)statement.getModuleReferences());
                for (PsiJavaModuleReferenceElement referenceElement : references) {
                    String fixText;
                    if (!moduleName.equals(referenceElement.getReferenceText())) continue;
                    String message2 = InspectionsBundle.message((String)"inspection.module.exports.package.to.itself", (Object[])new Object[0]);
                    if (references.size() == 1) {
                        fixText = InspectionsBundle.message((String)"exports.to.itself.delete.statement.fix", (Object[])new Object[0]);
                        this.myHolder.registerProblem((PsiElement)referenceElement, message2, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)statement, fixText)});
                        continue;
                    }
                    fixText = InspectionsBundle.message((String)"exports.to.itself.delete.module.ref.fix", (Object[])new Object[]{moduleName});
                    this.myHolder.registerProblem((PsiElement)referenceElement, message2, new LocalQuickFix[]{QuickFixFactory.getInstance().createDeleteFix((PsiElement)referenceElement, fixText)});
                }
            }
        }
    }
}

