/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java19modules;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Java9RedundantRequiresStatementInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance(Java9RedundantRequiresStatementInspection.class);
    private static final Key<Set<String>> IMPORTED_JAVA_PACKAGES = Key.create((String)"imported_java_packages");

    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.redundant.requires.statement.name", (Object[])new Object[0]);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity instanceof RefJavaModule) {
            List requiredModules;
            Set moduleImportedPackages;
            RefJavaModule refJavaModule = (RefJavaModule)refEntity;
            RefModule refModule = refJavaModule.getModule();
            PsiJavaModule psiJavaModule = refJavaModule.getPsiElement();
            if (refModule != null && psiJavaModule != null && (moduleImportedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES)) != null && !(requiredModules = refJavaModule.getRequiredModules()).isEmpty()) {
                ArrayList<ProblemDescriptor> descriptors = new ArrayList<ProblemDescriptor>();
                for (RefJavaModule.RequiredModule requiredModule : requiredModules) {
                    PsiRequiresStatement requiresStatement;
                    String requiredModuleName = requiredModule.moduleName;
                    if (!"java.base".equals(requiredModuleName) && !Java9RedundantRequiresStatementInspection.isDependencyUnused(requiredModule.packagesExportedByModule, moduleImportedPackages, refJavaModule.getName()) || (requiresStatement = (PsiRequiresStatement)ContainerUtil.find((Iterable)psiJavaModule.getRequires(), statement -> requiredModuleName.equals(statement.getModuleName()))) == null || this.isSuppressedFor((PsiElement)requiresStatement)) continue;
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)requiresStatement, InspectionsBundle.message((String)"inspection.redundant.requires.statement.description", (Object[])new Object[]{requiredModuleName}), (LocalQuickFix)new DeleteRedundantRequiresStatementFix(requiredModuleName, moduleImportedPackages), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false);
                    descriptors.add(descriptor);
                }
                if (!ContainerUtil.isEmpty(descriptors)) {
                    return descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
                }
            }
        }
        return null;
    }

    private static boolean isDependencyUnused(@NotNull Map<String, List<String>> dependencyExportedPackages, @NotNull Set<String> importedPackageNames, @NotNull String contextModuleName) {
        for (Map.Entry<String, List<String>> entry : dependencyExportedPackages.entrySet()) {
            String exportedPackageName = entry.getKey();
            List<String> exportedToModules = entry.getValue();
            if (!exportedToModules.isEmpty() && !exportedToModules.contains(contextModuleName) || !importedPackageNames.contains(exportedPackageName)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new RedundantRequiresStatementAnnotator();
    }

    private static class RedundantRequiresStatementAnnotator
    extends RefGraphAnnotator {
        private static final Set<String> DONT_COLLECT_PACKAGES = Collections.emptySet();

        private RedundantRequiresStatementAnnotator() {
        }

        public void onReferencesBuild(RefElement refElement) {
            RefModule refModule;
            if (refElement instanceof RefFile) {
                RefFile refFile = (RefFile)refElement;
                PsiFile file = refFile.getPsiElement();
                if (file instanceof PsiJavaFile) {
                    RedundantRequiresStatementAnnotator.onJavaFileReferencesBuilt(refFile, (PsiJavaFile)file);
                }
            } else if (refElement instanceof RefJavaModule && (refModule = refElement.getModule()) != null) {
                RedundantRequiresStatementAnnotator.setImportedPackages(refModule, refElement.getPsiElement() != null);
            }
        }

        private static void onJavaFileReferencesBuilt(@NotNull RefFile refFile, @NotNull PsiJavaFile file) {
            Set<String> packageNames;
            RefModule refModule;
            PsiImportList importList;
            if (file.getLanguageLevel().isAtLeast(LanguageLevel.JDK_1_9) && (importList = file.getImportList()) != null && (refModule = refFile.getModule()) != null && (packageNames = RedundantRequiresStatementAnnotator.getImportedPackages(refModule, refFile)) != DONT_COLLECT_PACKAGES) {
                PsiImportStatementBase[] statements;
                for (PsiImportStatementBase statement : statements = importList.getAllImportStatements()) {
                    String packageName = RedundantRequiresStatementAnnotator.getPackageName(statement);
                    if (StringUtil.isEmpty((String)packageName)) continue;
                    packageNames.add(packageName);
                }
            }
        }

        @Nullable
        private static String getPackageName(@NotNull PsiImportStatementBase statement) {
            PsiJavaFile parentFile;
            PsiElement resolved = statement.resolve();
            if (resolved instanceof PsiPackage) {
                return ((PsiPackage)resolved).getQualifiedName();
            }
            if (resolved instanceof PsiMember && (parentFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)resolved, PsiJavaFile.class)) != null) {
                return parentFile.getPackageName();
            }
            return null;
        }

        @NotNull
        private static Set<String> getImportedPackages(@NotNull RefModule refModule, @NotNull RefFile refFile) {
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)refFile.getPsiElement());
                importedPackages = javaModule != null ? new THashSet() : DONT_COLLECT_PACKAGES;
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, (Object)importedPackages);
            }
            return importedPackages;
        }

        private static void setImportedPackages(RefModule refModule, boolean collectPackages) {
            Set importedPackages = (Set)refModule.getUserData(IMPORTED_JAVA_PACKAGES);
            if (importedPackages == null) {
                refModule.putUserData(IMPORTED_JAVA_PACKAGES, (Object)(collectPackages ? new THashSet() : DONT_COLLECT_PACKAGES));
            }
        }
    }

    private static class DeleteRedundantRequiresStatementFix
    implements LocalQuickFix {
        private final String myRequiredModuleName;
        private final Set<String> myImportedPackages;

        DeleteRedundantRequiresStatementFix(String requiredModuleName, Set<String> importedPackages) {
            this.myRequiredModuleName = requiredModuleName;
            this.myImportedPackages = importedPackages;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.redundant.requires.statement.fix.family", (Object[])new Object[0]);
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.redundant.requires.statement.fix.name", (Object[])new Object[]{this.myRequiredModuleName});
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            LOG.assertTrue(element instanceof PsiRequiresStatement, (Object)"Should be 'requires' statement");
            PsiRequiresStatement statementToDelete = (PsiRequiresStatement)element;
            this.addTransitiveDependencies(statementToDelete);
            statementToDelete.delete();
        }

        private Set<String> getReexportedDependencies(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule dependencyModule) {
            Set directDependencies = StreamEx.of(currentModule.getRequires().iterator()).map(PsiRequiresStatement::getModuleName).nonNull().toSet();
            List transitiveModules = ((StreamEx)((StreamEx)StreamEx.of(dependencyModule.getRequires().iterator()).filter(statement -> statement.hasModifierProperty("transitive"))).filter(requiresStatement -> !directDependencies.contains(requiresStatement.getModuleName()))).map(PsiRequiresStatement::resolve).nonNull().toList();
            return ((StreamEx)StreamEx.of((Collection)transitiveModules).filter(transitiveModule -> this.isReexported(currentModule, (PsiJavaModule)transitiveModule))).map(transitiveModule -> transitiveModule.getName()).toSet();
        }

        private boolean isReexported(@NotNull PsiJavaModule currentModule, @NotNull PsiJavaModule transitiveModule) {
            return ((StreamEx)StreamEx.of(transitiveModule.getExports().iterator()).map(PsiPackageAccessibilityStatement::getPackageName).nonNull().filter(this.myImportedPackages::contains)).anyMatch(packageName -> JavaModuleGraphUtil.exports(transitiveModule, packageName, currentModule));
        }

        private void addTransitiveDependencies(@NotNull PsiRequiresStatement statementToDelete) {
            PsiElement parent = statementToDelete.getParent();
            if (parent instanceof PsiJavaModule) {
                PsiJavaModule currentModule = (PsiJavaModule)parent;
                Optional.of(statementToDelete).map(PsiRequiresStatement::resolve).map(dependencyModule -> this.getReexportedDependencies(currentModule, (PsiJavaModule)dependencyModule)).ifPresent(reexportedDependencies -> DeleteRedundantRequiresStatementFix.addReexportedDependencies(reexportedDependencies, currentModule, (PsiElement)statementToDelete));
            }
        }

        private static void addReexportedDependencies(@NotNull Set<String> reexportedDependencies, @NotNull PsiJavaModule currentModule, @NotNull PsiElement addingPlace) {
            if (!reexportedDependencies.isEmpty()) {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)currentModule.getProject()).getParserFacade();
                for (String dependencyName : reexportedDependencies) {
                    PsiStatement requiresStatement = parserFacade.createModuleStatementFromText("requires " + dependencyName, null);
                    currentModule.addAfter((PsiElement)requiresStatement, addingPlace);
                }
            }
        }
    }
}

