/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.lambdaToExplicit;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.lambdaToExplicit.LambdaAndExplicitMethodPair;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExplicitArgumentCanBeLambdaInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                for (LambdaAndExplicitMethodPair info : LambdaAndExplicitMethodPair.INFOS) {
                    PsiExpression arg = info.getLambdaCandidateFromExplicitCall(call);
                    if (arg == null || arg instanceof PsiEmptyExpressionImpl || ExpressionUtils.isSafelyRecomputableExpression(arg)) continue;
                    holder.registerProblem((PsiElement)arg, "Explicit argument can be converted to lambda", new LocalQuickFix[]{new ConvertExplicitCallToLambdaFix(info, info.getLambdaMethodName(call))});
                    return;
                }
            }
        };
    }

    private static class ConvertExplicitCallToLambdaFix
    implements LocalQuickFix {
        private final LambdaAndExplicitMethodPair myInfo;
        private final String myName;

        ConvertExplicitCallToLambdaFix(LambdaAndExplicitMethodPair info, String name) {
            this.myInfo = info;
            this.myName = name;
        }

        @Nls
        @NotNull
        public String getName() {
            return InspectionsBundle.message((String)"inspection.explicit.argument.can.be.lambda.fix.name", (Object[])new Object[]{this.myName});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.explicit.argument.can.be.lambda.fix.family.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiExpression arg = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class);
            if (arg == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)arg, PsiMethodCallExpression.class);
            if (call == null) {
                return;
            }
            Object[] args = call.getArgumentList().getExpressions();
            int idx = ArrayUtil.indexOf((Object[])args, (Object)arg);
            if (idx < 0) {
                return;
            }
            ExpressionUtils.bindCallTo(call, this.myName);
            String lambdaText = this.myInfo.makeLambda(arg);
            PsiLambdaExpression lambda2 = (PsiLambdaExpression)arg.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(lambdaText, (PsiElement)arg));
            LambdaCanBeMethodReferenceInspection.replaceLambdaWithMethodReference(lambda2);
        }
    }
}

