/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.magicConstant;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.JdkUtils;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.source.tree.injected.InjectedFileViewProvider;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.slicer.DuplicateMap;
import com.intellij.slicer.LanguageSlicing;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMapper;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.Joining;
import one.util.streamex.StreamEx;
import org.intellij.lang.annotations.MagicConstant;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MagicConstantInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Key<Boolean> NO_ANNOTATIONS_FOUND = Key.create((String)"REPORTED_NO_ANNOTATIONS_FOUND");
    private static final CallMapper<AllowedValues> SPECIAL_CASES = new CallMapper<Function<PsiMethodCallExpression, AllowedValues>>().register((CallMatcher)CallMatcher.instanceCall("java.util.Calendar", "get").parameterTypes("int"), MagicConstantInspection::getCalendarGetValues).register((CallMatcher)CallMatcher.instanceCall("java.awt.Toolkit", "getMenuShortcutKeyMaskEx"), call -> {
        PsiClass aClass;
        PsiMethod method = call.resolveMethod();
        if (method != null && (aClass = method.getContainingClass()) != null) {
            for (PsiMethod psiMethod : aClass.findMethodsByName("getMenuShortcutKeyMask", false)) {
                if (!psiMethod.getParameterList().isEmpty()) continue;
                return MagicConstantInspection.getAllowedValues((PsiModifierListOwner)psiMethod, (PsiType)PsiType.INT, null);
            }
        }
        return null;
    });
    private static final Key<Map<String, PsiExpression>> LITERAL_EXPRESSION_CACHE = Key.create((String)"LITERAL_EXPRESSION_CACHE");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.BUGS_GROUP_NAME;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return "Magic Constant";
    }

    @NotNull
    public String getShortName() {
        return "MagicConstant";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new JavaElementVisitor(){

            public void visitJavaFile(PsiJavaFile file) {
                MagicConstantInspection.checkAnnotationsJarAttached((PsiFile)file, holder);
            }

            public void visitCallExpression(PsiCallExpression callExpression) {
                MagicConstantInspection.checkCall(callExpression, holder);
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                PsiExpression r = expression2.getRExpression();
                if (r == null) {
                    return;
                }
                PsiExpression l = expression2.getLExpression();
                if (!(l instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiElement resolved = ((PsiReferenceExpression)l).resolve();
                if (!(resolved instanceof PsiModifierListOwner)) {
                    return;
                }
                PsiModifierListOwner owner = (PsiModifierListOwner)resolved;
                PsiType type2 = expression2.getType();
                MagicConstantInspection.checkExpression(r, owner, type2, holder);
            }

            public void visitReturnStatement(PsiReturnStatement statement) {
                PsiMethod method;
                PsiExpression value2 = statement.getReturnValue();
                if (value2 == null) {
                    return;
                }
                PsiElement element = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
                PsiMethod psiMethod = method = element instanceof PsiMethod ? (PsiMethod)element : LambdaUtil.getFunctionalInterfaceMethod((PsiElement)element);
                if (method == null) {
                    return;
                }
                MagicConstantInspection.checkExpression(value2, (PsiModifierListOwner)method, value2.getType(), holder);
            }

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value2 = pair.getValue();
                if (!(value2 instanceof PsiExpression)) {
                    return;
                }
                PsiReference ref = pair.getReference();
                if (ref == null) {
                    return;
                }
                PsiMethod method = (PsiMethod)ref.resolve();
                if (method == null) {
                    return;
                }
                MagicConstantInspection.checkExpression((PsiExpression)value2, (PsiModifierListOwner)method, method.getReturnType(), holder);
            }

            public void visitBinaryExpression(PsiBinaryExpression expression2) {
                IElementType tokenType = expression2.getOperationTokenType();
                if (tokenType != JavaTokenType.EQEQ && tokenType != JavaTokenType.NE) {
                    return;
                }
                PsiExpression l = expression2.getLOperand();
                PsiExpression r = expression2.getROperand();
                if (r == null) {
                    return;
                }
                this.checkBinary(l, r);
                this.checkBinary(r, l);
            }

            private void checkBinary(@NotNull PsiExpression l, @NotNull PsiExpression r) {
                PsiMethodCallExpression call;
                PsiMethod method;
                if (l instanceof PsiReference) {
                    PsiElement resolved = ((PsiReference)l).resolve();
                    if (resolved instanceof PsiModifierListOwner) {
                        MagicConstantInspection.checkExpression(r, (PsiModifierListOwner)resolved, MagicConstantInspection.getType((PsiModifierListOwner)resolved), holder);
                    }
                } else if (l instanceof PsiMethodCallExpression && (method = (call = (PsiMethodCallExpression)l).resolveMethod()) != null) {
                    MagicConstantInspection.checkExpression(r, (PsiModifierListOwner)method, method.getReturnType(), holder);
                    MagicConstantInspection.checkExpression(r, holder, (AllowedValues)SPECIAL_CASES.mapFirst(call));
                }
            }
        };
    }

    public void cleanup(@NotNull Project project) {
        super.cleanup(project);
        project.putUserData(NO_ANNOTATIONS_FOUND, null);
    }

    private static void checkAnnotationsJarAttached(@NotNull PsiFile file, @NotNull ProblemsHolder holder) {
        Boolean found;
        if (file.getViewProvider() instanceof InjectedFileViewProvider) {
            return;
        }
        Project project = file.getProject();
        if (!holder.isOnTheFly() && (found = (Boolean)project.getUserData(NO_ANNOTATIONS_FOUND)) != null) {
            return;
        }
        PsiClass event = JavaPsiFacade.getInstance((Project)project).findClass("java.awt.event.InputEvent", GlobalSearchScope.allScope((Project)project));
        if (event == null) {
            return;
        }
        PsiMethod[] methods = event.findMethodsByName("getModifiers", false);
        if (methods.length != 1) {
            return;
        }
        PsiMethod getModifiers = methods[0];
        PsiAnnotation annotation = ExternalAnnotationsManager.getInstance((Project)project).findExternalAnnotation((PsiModifierListOwner)getModifiers, MagicConstant.class.getName());
        if (annotation != null) {
            return;
        }
        Sdk jdk = JdkUtils.getJdkForElement((PsiElement)getModifiers);
        if (jdk == null) {
            return;
        }
        if (!holder.isOnTheFly()) {
            project.putUserData(NO_ANNOTATIONS_FOUND, (Object)Boolean.TRUE);
        }
        final Sdk finalJdk = jdk;
        String path = finalJdk.getHomePath();
        String text2 = "No IDEA annotations attached to the JDK " + finalJdk.getName() + (path == null ? "" : " (" + FileUtil.toSystemDependentName((String)path) + ")") + ", some issues will not be found";
        holder.registerProblem((PsiElement)file, text2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                return "Attach annotations";
            }

            @Nullable
            public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
                return null;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                SdkModificator modificator = finalJdk.getSdkModificator();
                JavaSdkImpl.attachJdkAnnotations(modificator);
                modificator.commitChanges();
            }
        }});
    }

    private static void checkExpression(@NotNull PsiExpression expression2, @NotNull PsiModifierListOwner owner, @Nullable PsiType type2, @NotNull ProblemsHolder holder) {
        AllowedValues allowed = MagicConstantInspection.getAllowedValues(owner, type2, null);
        MagicConstantInspection.checkExpression(expression2, holder, allowed);
    }

    private static void checkExpression(@NotNull PsiExpression expression2, @NotNull ProblemsHolder holder, AllowedValues allowed) {
        if (allowed == null) {
            return;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)expression2, null);
        if (scope == null) {
            scope = expression2;
        }
        if (!MagicConstantInspection.isAllowed(expression2, scope, allowed, expression2.getManager(), null)) {
            MagicConstantInspection.registerProblem(expression2, allowed, holder);
        }
    }

    private static void checkCall(@NotNull PsiCallExpression methodCall, @NotNull ProblemsHolder holder) {
        PsiExpressionList argumentList = methodCall.getArgumentList();
        if (argumentList == null) {
            return;
        }
        PsiMethod method = methodCall.resolveMethod();
        if (method == null) {
            return;
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        PsiExpression[] arguments = argumentList.getExpressions();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter2 = parameters2[i];
            AllowedValues values = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)parameter2, parameter2.getType(), null);
            if (values == null) continue;
            if (i >= arguments.length) break;
            PsiExpression argument = arguments[i];
            if ((argument = PsiUtil.deparenthesizeExpression((PsiExpression)argument)) == null) continue;
            MagicConstantInspection.checkMagicParameterArgument(parameter2, argument, values, holder);
        }
    }

    private static AllowedValues getAllowedValuesFromMagic(@NotNull PsiType type2, @NotNull PsiAnnotation magic, @NotNull PsiManager manager) {
        Object[] flagsFromClass;
        PsiAnnotationMemberValue[] initializers;
        Object[] allowedValues = PsiAnnotationMemberValue.EMPTY_ARRAY;
        boolean values = false;
        boolean flags = false;
        if (TypeConversionUtil.getTypeRank((PsiType)type2) <= 5) {
            PsiAnnotationMemberValue[] initializers2;
            PsiAnnotationMemberValue orValue;
            PsiAnnotationMemberValue intValues = magic.findAttributeValue("intValues");
            if (intValues instanceof PsiArrayInitializerMemberValue && (initializers = ((PsiArrayInitializerMemberValue)intValues).getInitializers()).length != 0) {
                allowedValues = initializers;
                values = true;
            }
            if (!values && (orValue = magic.findAttributeValue("flags")) instanceof PsiArrayInitializerMemberValue && (initializers2 = ((PsiArrayInitializerMemberValue)orValue).getInitializers()).length != 0) {
                allowedValues = initializers2;
                flags = true;
            }
        } else if (type2.equals(PsiType.getJavaLangString((PsiManager)manager, (GlobalSearchScope)GlobalSearchScope.allScope((Project)manager.getProject())))) {
            PsiAnnotationMemberValue strValuesAttr = magic.findAttributeValue("stringValues");
            if (strValuesAttr instanceof PsiArrayInitializerMemberValue && (initializers = ((PsiArrayInitializerMemberValue)strValuesAttr).getInitializers()).length != 0) {
                allowedValues = initializers;
                values = true;
            }
        } else {
            return null;
        }
        Object[] valuesFromClass = MagicConstantInspection.readFromClass("valuesFromClass", magic, type2, manager);
        if (valuesFromClass != null) {
            allowedValues = (PsiAnnotationMemberValue[])ArrayUtil.mergeArrays((Object[])allowedValues, (Object[])valuesFromClass, (ArrayFactory)PsiAnnotationMemberValue.ARRAY_FACTORY);
            values = true;
        }
        if ((flagsFromClass = MagicConstantInspection.readFromClass("flagsFromClass", magic, type2, manager)) != null) {
            allowedValues = (PsiAnnotationMemberValue[])ArrayUtil.mergeArrays((Object[])allowedValues, (Object[])flagsFromClass, (ArrayFactory)PsiAnnotationMemberValue.ARRAY_FACTORY);
            flags = true;
        }
        if (allowedValues.length == 0) {
            return null;
        }
        if (values && flags) {
            throw new IncorrectOperationException("Misconfiguration of @MagicConstant annotation: 'flags' and 'values' shouldn't be used at the same time");
        }
        return new AllowedValues((PsiAnnotationMemberValue[])allowedValues, flags);
    }

    private static PsiAnnotationMemberValue[] readFromClass(@NonNls @NotNull String attributeName, @NotNull PsiAnnotation magic, @NotNull PsiType type2, @NotNull PsiManager manager) {
        PsiClass fromClass;
        PsiAnnotationMemberValue fromClassAttr = magic.findAttributeValue(attributeName);
        PsiType fromClassType = fromClassAttr instanceof PsiClassObjectAccessExpression ? ((PsiClassObjectAccessExpression)fromClassAttr).getOperand().getType() : null;
        PsiClass psiClass = fromClass = fromClassType instanceof PsiClassType ? ((PsiClassType)fromClassType).resolve() : null;
        if (fromClass == null) {
            return null;
        }
        String fqn = fromClass.getQualifiedName();
        if (fqn == null) {
            return null;
        }
        ArrayList<PsiReferenceExpression> constants = new ArrayList<PsiReferenceExpression>();
        for (PsiField field : fromClass.getFields()) {
            PsiType fieldType;
            if (!field.hasModifierProperty("public") || !field.hasModifierProperty("static") || !field.hasModifierProperty("final") || !Comparing.equal((Object)(fieldType = field.getType()), (Object)type2)) continue;
            PsiAssignmentExpression e = (PsiAssignmentExpression)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("x=" + fqn + "." + field.getName(), (PsiElement)field);
            PsiReferenceExpression refToField = (PsiReferenceExpression)e.getRExpression();
            constants.add(refToField);
        }
        if (constants.isEmpty()) {
            return null;
        }
        return constants.toArray(PsiAnnotationMemberValue.EMPTY_ARRAY);
    }

    @Nullable
    static AllowedValues getAllowedValues(@NotNull PsiModifierListOwner element, @Nullable PsiType type2, @Nullable Set<? super PsiClass> visited) {
        PsiManager manager = element.getManager();
        for (PsiAnnotation annotation : MagicConstantInspection.getAllAnnotations(element)) {
            AllowedValues values;
            PsiElement resolved;
            AllowedValues values2;
            if (type2 != null && MagicConstant.class.getName().equals(annotation.getQualifiedName()) && (values2 = MagicConstantInspection.getAllowedValuesFromMagic(type2, annotation, manager)) != null) {
                return values2;
            }
            PsiJavaCodeReferenceElement ref = annotation.getNameReferenceElement();
            PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
            if (!(resolved instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass aClass = (PsiClass)resolved;
            if (visited == null) {
                visited = new THashSet();
            }
            if (!visited.add((PsiClass)aClass) || (values = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)aClass, type2, (Set<? super PsiClass>)visited)) == null) continue;
            return values;
        }
        return MagicConstantInspection.parseBeanInfo(element, manager);
    }

    private static AllowedValues getCalendarGetValues(PsiMethodCallExpression call) {
        Integer argument = (Integer)ObjectUtils.tryCast((Object)ExpressionUtils.computeConstantExpression(call.getArgumentList().getExpressions()[0]), Integer.class);
        PsiMethod method = call.resolveMethod();
        if (method == null || argument == null) {
            return null;
        }
        return (AllowedValues)((Map)CachedValuesManager.getCachedValue((PsiElement)method, () -> {
            String[] days = new String[]{"SUNDAY", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY"};
            String[] months = new String[]{"JANUARY", "FEBRUARY", "MARCH", "APRIL", "MAY", "JUNE", "JULY", "AUGUST", "SEPTEMBER", "OCTOBER", "NOVEMBER", "DECEMBER"};
            String[] amPm = new String[]{"AM", "PM"};
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            Function<String[], AllowedValues> converter = strings -> {
                String expression2 = StreamEx.of((Object[])strings).map("java.util.Calendar."::concat).joining((CharSequence)",", (CharSequence)"{", (CharSequence)"}");
                PsiArrayInitializerExpression initializer = (PsiArrayInitializerExpression)factory.createExpressionFromText(expression2, (PsiElement)method);
                return new AllowedValues((PsiAnnotationMemberValue[])initializer.getInitializers(), false);
            };
            HashMap<Integer, AllowedValues> map2 = new HashMap<Integer, AllowedValues>();
            map2.put(7, converter.apply(days));
            map2.put(2, converter.apply(months));
            map2.put(9, converter.apply(amPm));
            return CachedValueProvider.Result.create(map2, (Object[])new Object[]{method});
        })).get(argument);
    }

    @NotNull
    private static PsiAnnotation[] getAllAnnotations(@NotNull PsiModifierListOwner element) {
        PsiModifierListOwner realElement = element instanceof PsiCompiledElement && element.getNavigationElement() instanceof PsiModifierListOwner ? (PsiModifierListOwner)element.getNavigationElement() : element;
        return (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)realElement, () -> CachedValueProvider.Result.create((Object)AnnotationUtil.getAllAnnotations((PsiModifierListOwner)realElement, (boolean)true, null, (boolean)false), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static AllowedValues parseBeanInfo(@NotNull PsiModifierListOwner owner, @NotNull PsiManager manager) {
        PsiUtilCore.ensureValid((PsiElement)owner);
        PsiFile containingFile = owner.getContainingFile();
        if (containingFile != null) {
            PsiUtilCore.ensureValid((PsiElement)containingFile);
            if (!MagicConstantInspection.containsBeanInfoText((PsiFile)containingFile.getNavigationElement())) {
                return null;
            }
        }
        PsiMethod method = null;
        if (owner instanceof PsiParameter) {
            PsiParameter parameter2 = (PsiParameter)owner;
            PsiElement scope = parameter2.getDeclarationScope();
            if (!(scope instanceof PsiMethod)) {
                return null;
            }
            PsiElement nav = scope.getNavigationElement();
            if (!(nav instanceof PsiMethod)) {
                return null;
            }
            method = (PsiMethod)nav;
            if (method.isConstructor()) {
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"java.beans.ConstructorProperties"});
                if (annotation == null) {
                    return null;
                }
                PsiAnnotationMemberValue value2 = annotation.findAttributeValue("value");
                if (!(value2 instanceof PsiArrayInitializerMemberValue)) {
                    return null;
                }
                PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers();
                PsiElement parent = parameter2.getParent();
                if (!(parent instanceof PsiParameterList)) {
                    return null;
                }
                int index = ((PsiParameterList)parent).getParameterIndex(parameter2);
                if (index >= initializers.length) {
                    return null;
                }
                String[] initializer = initializers[index];
                if (!(initializer instanceof PsiLiteralExpression)) {
                    return null;
                }
                Object val = ((PsiLiteralExpression)initializer).getValue();
                if (!(val instanceof String)) {
                    return null;
                }
                PsiMethod setter = PropertyUtilBase.findPropertySetter((PsiClass)method.getContainingClass(), (String)((String)val), (boolean)false, (boolean)false);
                if (setter == null) {
                    return null;
                }
                PsiElement navigationElement = setter.getNavigationElement();
                if (!(navigationElement instanceof PsiMethod)) {
                    return null;
                }
                method = (PsiMethod)navigationElement;
            }
        } else if (owner instanceof PsiMethod) {
            PsiElement nav = owner.getNavigationElement();
            if (!(nav instanceof PsiMethod)) {
                return null;
            }
            method = (PsiMethod)nav;
        }
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        if (PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
            List setters = PropertyUtilBase.getSetters((PsiClass)aClass, (String)PropertyUtilBase.getPropertyNameByGetter((PsiMethod)method));
            if (setters.size() != 1) {
                return null;
            }
            method = (PsiMethod)setters.get(0);
        }
        if (!PropertyUtilBase.isSimplePropertySetter((PsiMethod)method)) {
            return null;
        }
        PsiDocComment doc = method.getDocComment();
        if (doc == null) {
            return null;
        }
        PsiDocTag beaninfo = doc.findTagByName("beaninfo");
        if (beaninfo == null) {
            return null;
        }
        String data = StringUtil.join((Object[])beaninfo.getDataElements(), PsiElement::getText, (String)"\n");
        int enumIndex = StringUtil.indexOfSubstringEnd((String)data, (String)"enum:");
        if (enumIndex == -1) {
            return null;
        }
        int colon = (data = data.substring(enumIndex)).indexOf(58);
        int last = colon == -1 ? data.length() : data.substring(0, colon).lastIndexOf(10);
        data = data.substring(0, last);
        ArrayList<PsiReferenceExpression> values = new ArrayList<PsiReferenceExpression>();
        for (String line : StringUtil.splitByLines((String)data)) {
            List words = StringUtil.split((String)line, (String)" ", (boolean)true, (boolean)true);
            if (words.size() != 2) continue;
            String ref = (String)words.get(1);
            PsiExpression constRef = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(ref, (PsiElement)aClass);
            if (!(constRef instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression expr = (PsiReferenceExpression)constRef;
            values.add(expr);
        }
        if (values.isEmpty()) {
            return null;
        }
        PsiAnnotationMemberValue[] array = values.toArray(PsiAnnotationMemberValue.EMPTY_ARRAY);
        return new AllowedValues(array, false);
    }

    private static boolean containsBeanInfoText(@NotNull PsiFile file) {
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> CachedValueProvider.Result.create((Object)IdIndex.hasIdentifierInFile((PsiFile)file, (String)"beaninfo"), (Object[])new Object[]{file}));
    }

    private static PsiType getType(@NotNull PsiModifierListOwner element) {
        return element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiMethod ? ((PsiMethod)element).getReturnType() : null);
    }

    private static void checkMagicParameterArgument(@NotNull PsiParameter parameter2, @NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        PsiManager manager = PsiManager.getInstance((Project)holder.getProject());
        if (!argument.getTextRange().isEmpty() && !MagicConstantInspection.isAllowed(argument, parameter2.getDeclarationScope(), allowedValues, manager, null)) {
            MagicConstantInspection.registerProblem(argument, allowedValues, holder);
        }
    }

    private static void registerProblem(@NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull ProblemsHolder holder) {
        Function<PsiAnnotationMemberValue, String> formatter = value2 -> {
            PsiElement resolved;
            if (value2 instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)value2).resolve()) instanceof PsiVariable) {
                return PsiFormatUtil.formatVariable((PsiVariable)((PsiVariable)resolved), (int)4097, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            }
            return value2.getText();
        };
        String values = (String)StreamEx.of((Object[])allowedValues.values).map(formatter).collect((Collector)Joining.with((CharSequence)", ").cutAfterDelimiter().maxCodePoints(100));
        String message2 = "Should be one of: " + values + (allowedValues.canBeOred ? " or their combination" : "");
        holder.registerProblem((PsiElement)argument, message2, new LocalQuickFix[]{MagicConstantInspection.suggestMagicConstant(argument, allowedValues)});
    }

    @Nullable
    private static LocalQuickFix suggestMagicConstant(@NotNull PsiExpression argument, @NotNull AllowedValues allowedValues) {
        Object argumentValue = JavaConstantExpressionEvaluator.computeConstantExpression(argument, null, false);
        if (argumentValue == null) {
            return null;
        }
        if (!allowedValues.canBeOred) {
            for (PsiAnnotationMemberValue value2 : allowedValues.values) {
                Object constantValue;
                if (!(value2 instanceof PsiExpression) || !argumentValue.equals(constantValue = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)value2, null, false))) continue;
                return new ReplaceWithMagicConstantFix(argument, value2);
            }
        } else {
            Long longArgument = MagicConstantInspection.evaluateLongConstant(argument);
            if (longArgument == null) {
                return null;
            }
            long remainingFlags = longArgument;
            ArrayList<PsiAnnotationMemberValue> flags = new ArrayList<PsiAnnotationMemberValue>();
            for (PsiAnnotationMemberValue value3 : allowedValues.values) {
                Long constantValue;
                if (!(value3 instanceof PsiExpression) || (constantValue = MagicConstantInspection.evaluateLongConstant((PsiExpression)value3)) == null || (remainingFlags & constantValue) != constantValue) continue;
                flags.add(value3);
                remainingFlags &= constantValue ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (remainingFlags == 0L) {
                if (flags.size() > 1) {
                    for (int i = flags.size() - 1; i >= 0; --i) {
                        PsiAnnotationMemberValue flag = (PsiAnnotationMemberValue)flags.get(i);
                        Long flagValue = MagicConstantInspection.evaluateLongConstant((PsiExpression)flag);
                        if (flagValue == null || flagValue != 0L) continue;
                        flags.remove(i);
                    }
                }
                if (!flags.isEmpty()) {
                    return new ReplaceWithMagicConstantFix(argument, flags.toArray(PsiAnnotationMemberValue.EMPTY_ARRAY));
                }
            }
        }
        return null;
    }

    private static Long evaluateLongConstant(@NotNull PsiExpression expression2) {
        Object constantValue = JavaConstantExpressionEvaluator.computeConstantExpression(expression2, null, false);
        if (constantValue instanceof Long || constantValue instanceof Integer || constantValue instanceof Short || constantValue instanceof Byte) {
            return ((Number)constantValue).longValue();
        }
        return null;
    }

    private static boolean isAllowed(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull AllowedValues allowedValues, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        if (MagicConstantInspection.isGoodExpression(argument, allowedValues, scope, manager, visited)) {
            return true;
        }
        return MagicConstantInspection.processValuesFlownTo(argument, scope, manager, (Processor<? super PsiExpression>)((Processor)expression2 -> MagicConstantInspection.isGoodExpression(expression2, allowedValues, scope, manager, visited)));
    }

    private static boolean isGoodExpression(@NotNull PsiExpression argument, @NotNull AllowedValues allowedValues, @NotNull PsiElement scope, @NotNull PsiManager manager, @Nullable Set<PsiExpression> visited) {
        PsiExpression expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)argument);
        if (expression2 == null) {
            return true;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        if (!visited.add((PsiExpression)expression2)) {
            return true;
        }
        if (expression2 instanceof PsiConditionalExpression) {
            boolean thenAllowed;
            PsiExpression thenExpression2 = ((PsiConditionalExpression)expression2).getThenExpression();
            boolean bl = thenAllowed = thenExpression2 == null || MagicConstantInspection.isAllowed(thenExpression2, scope, allowedValues, manager, (Set<PsiExpression>)visited);
            if (!thenAllowed) {
                return false;
            }
            PsiExpression elseExpression2 = ((PsiConditionalExpression)expression2).getElseExpression();
            return elseExpression2 == null || MagicConstantInspection.isAllowed(elseExpression2, scope, allowedValues, manager, (Set<PsiExpression>)visited);
        }
        if (MagicConstantInspection.isOneOf(expression2, allowedValues, manager)) {
            return true;
        }
        if (allowedValues.canBeOred) {
            IElementType tokenType;
            PsiExpression zero = MagicConstantInspection.getLiteralExpression(expression2, manager, "0");
            if (MagicConstantInspection.same((PsiElement)expression2, (PsiElement)zero, manager) && !allowedValues.resolvesToZero) {
                return true;
            }
            PsiExpression minusOne = MagicConstantInspection.getLiteralExpression(expression2, manager, "-1");
            if (MagicConstantInspection.same((PsiElement)expression2, (PsiElement)minusOne, manager)) {
                return true;
            }
            if (expression2 instanceof PsiPolyadicExpression && (JavaTokenType.OR.equals(tokenType = ((PsiPolyadicExpression)expression2).getOperationTokenType()) || JavaTokenType.XOR.equals(tokenType) || JavaTokenType.AND.equals(tokenType) || JavaTokenType.PLUS.equals(tokenType))) {
                for (PsiExpression operand2 : ((PsiPolyadicExpression)expression2).getOperands()) {
                    if (MagicConstantInspection.isAllowed(operand2, scope, allowedValues, manager, (Set<PsiExpression>)visited)) continue;
                    return false;
                }
                return true;
            }
            if (expression2 instanceof PsiPrefixExpression && JavaTokenType.TILDE.equals(((PsiPrefixExpression)expression2).getOperationTokenType())) {
                PsiExpression operand3 = ((PsiPrefixExpression)expression2).getOperand();
                return operand3 == null || MagicConstantInspection.isAllowed(operand3, scope, allowedValues, manager, (Set<PsiExpression>)visited);
            }
        }
        PsiElement resolved = null;
        AllowedValues allowedForRef = null;
        if (expression2 instanceof PsiReference) {
            resolved = ((PsiReference)expression2).resolve();
        } else if (expression2 instanceof PsiMethodCallExpression) {
            allowedForRef = SPECIAL_CASES.mapFirst((PsiMethodCallExpression)expression2);
            resolved = ((PsiCallExpression)expression2).resolveMethod();
        }
        if (allowedForRef == null && resolved instanceof PsiModifierListOwner) {
            allowedForRef = MagicConstantInspection.getAllowedValues((PsiModifierListOwner)resolved, MagicConstantInspection.getType((PsiModifierListOwner)resolved), null);
        }
        if (allowedForRef != null && allowedForRef.isSubsetOf(allowedValues, manager)) {
            return true;
        }
        return PsiType.NULL.equals((Object)expression2.getType());
    }

    @NotNull
    private static PsiExpression getLiteralExpression(@NotNull PsiExpression context, @NotNull PsiManager manager, @NotNull String text2) {
        PsiExpression expression2;
        Map cache = (Map)LITERAL_EXPRESSION_CACHE.get((UserDataHolder)manager);
        if (cache == null) {
            cache = ContainerUtil.createConcurrentSoftValueMap();
            cache = (Map)manager.putUserDataIfAbsent(LITERAL_EXPRESSION_CACHE, (Object)cache);
        }
        if ((expression2 = (PsiExpression)cache.get(text2)) == null) {
            expression2 = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText(text2, (PsiElement)context);
            cache.put(text2, expression2);
        }
        return expression2;
    }

    private static boolean isOneOf(@NotNull PsiExpression expression2, @NotNull AllowedValues allowedValues, @NotNull PsiManager manager) {
        for (PsiAnnotationMemberValue allowedValue : allowedValues.values) {
            if (!MagicConstantInspection.same((PsiElement)allowedValue, (PsiElement)expression2, manager)) continue;
            return true;
        }
        return false;
    }

    private static boolean same(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull PsiManager manager) {
        if (e1 instanceof PsiLiteralExpression && e2 instanceof PsiLiteralExpression) {
            return Comparing.equal((Object)((PsiLiteralExpression)e1).getValue(), (Object)((PsiLiteralExpression)e2).getValue());
        }
        if (e1 instanceof PsiPrefixExpression && e2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)e1).getOperationTokenType() == ((PsiPrefixExpression)e2).getOperationTokenType()) {
            PsiExpression lOperand = ((PsiPrefixExpression)e1).getOperand();
            PsiExpression rOperand = ((PsiPrefixExpression)e2).getOperand();
            return lOperand != null && rOperand != null && MagicConstantInspection.same((PsiElement)lOperand, (PsiElement)rOperand, manager);
        }
        if (e1 instanceof PsiReference && e2 instanceof PsiReference) {
            e1 = ((PsiReference)e1).resolve();
            e2 = ((PsiReference)e2).resolve();
        }
        return manager.areElementsEquivalent(e2, e1);
    }

    static boolean processValuesFlownTo(@NotNull PsiExpression argument, @NotNull PsiElement scope, @NotNull PsiManager manager, @NotNull Processor<? super PsiExpression> processor) {
        SliceAnalysisParams params = new SliceAnalysisParams();
        params.dataFlowToThis = true;
        params.scope = new AnalysisScope((SearchScope)new LocalSearchScope(scope), manager.getProject());
        SliceRootNode rootNode = new SliceRootNode(manager.getProject(), new DuplicateMap(), LanguageSlicing.getProvider((PsiElement)argument).createRootUsage((PsiElement)argument, params));
        Collection children = (Collection)ProgressManager.getInstance().runProcess(() -> ((SliceNode)rootNode.getChildren().iterator().next()).getChildren(), (ProgressIndicator)new ProgressIndicatorBase());
        for (AbstractTreeNode child : children) {
            SliceUsage usage = (SliceUsage)child.getValue();
            PsiElement element = usage != null ? usage.getElement() : null;
            if (!(element instanceof PsiExpression) || processor.process((Object)((PsiExpression)element))) continue;
            return false;
        }
        return !children.isEmpty();
    }

    private static class ReplaceWithMagicConstantFix
    extends LocalQuickFixOnPsiElement {
        private final List<SmartPsiElementPointer<PsiAnnotationMemberValue>> myMemberValuePointers;

        ReplaceWithMagicConstantFix(@NotNull PsiExpression argument, PsiAnnotationMemberValue ... values) {
            super((PsiElement)argument);
            this.myMemberValuePointers = ContainerUtil.map((Object[])values, arg_0 -> ((SmartPointerManager)SmartPointerManager.getInstance((Project)argument.getProject())).createSmartPsiElementPointer(arg_0));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with magic constant";
        }

        @NotNull
        public String getText() {
            List names = this.myMemberValuePointers.stream().map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).map(PsiElement::getText).collect(Collectors.toList());
            String expression2 = StringUtil.join(names, (String)" | ");
            return "Replace with '" + expression2 + "'";
        }

        public void invoke(final @NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            List values = ContainerUtil.map(this.myMemberValuePointers, SmartPsiElementPointer::getElement);
            String text2 = StringUtil.join(Collections.nCopies(values.size(), "0"), (String)" | ");
            PsiExpression concatExp = PsiElementFactory.SERVICE.getInstance((Project)project).createExpressionFromText(text2, startElement);
            final ArrayList expressionsToReplace = new ArrayList(values.size());
            concatExp.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitLiteralExpression(PsiLiteralExpression expression2) {
                    super.visitLiteralExpression(expression2);
                    if (Integer.valueOf(0).equals(expression2.getValue())) {
                        expressionsToReplace.add(expression2);
                    }
                }
            });
            Iterator iterator = values.iterator();
            ArrayList<PsiElement> resolved = new ArrayList<PsiElement>();
            for (PsiLiteralExpression toReplace : expressionsToReplace) {
                PsiAnnotationMemberValue value2 = (PsiAnnotationMemberValue)iterator.next();
                resolved.add(((PsiReference)value2).resolve());
                PsiExpression replaced = (PsiExpression)toReplace.replace((PsiElement)value2);
                if (toReplace != concatExp) continue;
                concatExp = replaced;
            }
            PsiElement newStartElement = startElement.replace((PsiElement)concatExp);
            final Iterator resolvedValuesIterator = resolved.iterator();
            newStartElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    PsiElement bound = expression2.bindToElement((PsiElement)resolvedValuesIterator.next());
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(bound);
                }
            });
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            boolean allValid = this.myMemberValuePointers.stream().map(SmartPsiElementPointer::getElement).allMatch(p -> p != null && p.isValid());
            return allValid && super.isAvailable(project, file, startElement, endElement);
        }
    }

    static class AllowedValues {
        @NotNull
        final PsiAnnotationMemberValue[] values;
        final boolean canBeOred;
        final boolean resolvesToZero;

        private AllowedValues(@NotNull PsiAnnotationMemberValue[] values, boolean canBeOred) {
            this.values = values;
            this.canBeOred = canBeOred;
            this.resolvesToZero = this.resolvesToZero();
        }

        private boolean resolvesToZero() {
            for (PsiAnnotationMemberValue value2 : this.values) {
                Object evaluated;
                if (!(value2 instanceof PsiExpression) || !((evaluated = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)value2, null, false)) instanceof Integer) || (Integer)evaluated != 0) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AllowedValues a2 = (AllowedValues)o;
            if (this.canBeOred != a2.canBeOred) {
                return false;
            }
            THashSet v1 = new THashSet(Arrays.asList(this.values));
            THashSet v2 = new THashSet(Arrays.asList(a2.values));
            if (v1.size() != v2.size()) {
                return false;
            }
            block0: for (PsiAnnotationMemberValue value2 : v1) {
                for (PsiAnnotationMemberValue value22 : v2) {
                    if (!MagicConstantInspection.same((PsiElement)value2, (PsiElement)value22, value2.getManager())) continue;
                    v2.remove(value22);
                    continue block0;
                }
            }
            return v2.isEmpty();
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.values);
            result = 31 * result + (this.canBeOred ? 1 : 0);
            return result;
        }

        boolean isSubsetOf(@NotNull AllowedValues other, @NotNull PsiManager manager) {
            return Arrays.stream(this.values).allMatch(value2 -> Arrays.stream(other.values).anyMatch(otherValue -> MagicConstantInspection.same((PsiElement)value2, (PsiElement)otherValue, manager)));
        }
    }
}

