/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

class AnnotateOverriddenMethodParameterFix
implements LocalQuickFix {
    private final String myAnnotation;
    private final String[] myAnnosToRemove;

    AnnotateOverriddenMethodParameterFix(@NotNull String annotationFQN, String ... annosToRemove) {
        this.myAnnotation = annotationFQN;
        this.myAnnosToRemove = annosToRemove;
    }

    @NotNull
    public String getName() {
        return InspectionsBundle.message((String)"annotate.overridden.methods.parameters", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethod[] methods;
        PsiElement psiElement = descriptor.getPsiElement();
        PsiParameter parameter2 = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiParameter.class, (boolean)false);
        if (parameter2 == null) {
            return;
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter2, PsiMethod.class);
        if (method == null) {
            return;
        }
        Object[] parameters2 = method.getParameterList().getParameters();
        int index = ArrayUtilRt.find((Object[])parameters2, (Object)parameter2);
        ArrayList<PsiParameter> toAnnotate = new ArrayList<PsiParameter>();
        for (PsiMethod psiMethod : methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
            PsiParameter[] psiParameters;
            if (NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod) || index >= (psiParameters = psiMethod.getParameterList().getParameters()).length || !AddAnnotationPsiFix.isAvailable((PsiModifierListOwner)psiParameters[index], this.myAnnotation)) continue;
            toAnnotate.add(psiParameters[index]);
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        Throwable exception = null;
        for (PsiParameter psiParam : toAnnotate) {
            assert (psiParam != null) : toAnnotate;
            try {
                if (AnnotationUtil.isAnnotatingApplicable((PsiElement)psiParam, (String)this.myAnnotation)) {
                    AddAnnotationPsiFix fix2 = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)psiParam, PsiNameValuePair.EMPTY_ARRAY, this.myAnnosToRemove);
                    PsiFile containingFile = psiParam.getContainingFile();
                    if (psiParam.isValid() && fix2.isAvailable(project, containingFile, (PsiElement)psiParam, (PsiElement)psiParam)) {
                        fix2.invoke(project, containingFile, (PsiElement)psiParam, (PsiElement)psiParam);
                    }
                }
            }
            catch (PsiInvalidElementAccessException | IncorrectOperationException e) {
                exception = e;
            }
            if (exception == null) continue;
            throw exception;
        }
    }

    @NotNull
    public String getFamilyName() {
        return InspectionsBundle.message((String)"annotate.overridden.methods.parameters.family.name", (Object[])new Object[0]);
    }
}

