/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.redundantCast;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.codeInspection.miscGenerics.SuspiciousMethodCallUtil;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantCastInspection
extends GenericsInspectionToolBase {
    private final LocalQuickFix myQuickFixAction = new AcceptSuggested();
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.redundant.cast.display.name", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "RedundantCast";
    public boolean IGNORE_SUSPICIOUS_METHOD_CALLS;

    @Override
    @Nullable
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement where, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List redundantCasts = RedundantCastUtil.getRedundantCastsInside((PsiElement)where);
        if (redundantCasts.isEmpty()) {
            return null;
        }
        ArrayList<ProblemDescriptor> descriptions = new ArrayList<ProblemDescriptor>(redundantCasts.size());
        for (PsiTypeCastExpression redundantCast : redundantCasts) {
            ProblemDescriptor descriptor = this.createDescription(redundantCast, manager, isOnTheFly);
            if (descriptor == null) continue;
            descriptions.add(descriptor);
        }
        if (descriptions.isEmpty()) {
            return null;
        }
        return descriptions.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return this.getDescriptions((PsiElement)field, manager, isOnTheFly);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_SUSPICIOUS_METHOD_CALLS) {
            super.writeSettings(node);
        }
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox("Ignore casts in suspicious collections method calls", "IGNORE_SUSPICIOUS_METHOD_CALLS");
        return optionsPanel;
    }

    @Nullable
    private ProblemDescriptor createDescription(@NotNull PsiTypeCastExpression cast, @NotNull InspectionManager manager, boolean onTheFly) {
        String message2;
        PsiElement gParent;
        PsiExpression operand2 = cast.getOperand();
        PsiTypeElement castType = cast.getCastType();
        if (operand2 == null || castType == null) {
            return null;
        }
        PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)cast.getParent());
        if (parent instanceof PsiExpressionList && (gParent = parent.getParent()) instanceof PsiMethodCallExpression && this.IGNORE_SUSPICIOUS_METHOD_CALLS && (message2 = SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage((PsiMethodCallExpression)gParent, operand2, operand2.getType(), true, new ArrayList<SuspiciousMethodCallUtil.PatternMethod>(), 0)) != null) {
            return null;
        }
        String message3 = InspectionsBundle.message((String)"inspection.redundant.cast.problem.descriptor", (Object[])new Object[]{"<code>" + PsiExpressionTrimRenderer.render((PsiExpression)operand2) + "</code>", "<code>#ref</code> #loc"});
        return manager.createProblemDescriptor((PsiElement)castType, message3, this.myQuickFixAction, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly);
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.VERBOSE_GROUP_NAME;
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    private static class AcceptSuggested
    implements LocalQuickFix {
        private AcceptSuggested() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.redundant.cast.remove.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiTypeCastExpression cast;
            PsiElement castTypeElement = descriptor.getPsiElement();
            PsiTypeCastExpression psiTypeCastExpression = cast = castTypeElement == null ? null : (PsiTypeCastExpression)castTypeElement.getParent();
            if (cast != null) {
                RemoveRedundantCastUtil.removeCast(cast);
            }
        }
    }
}

