/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFileImpl;
import com.intellij.codeInspection.reference.RefImplicitConstructorImpl;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.jvm.JvmClass;
import com.intellij.lang.jvm.JvmMetaLanguage;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.util.JvmInheritanceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.UastVisibility;

public class RefClassImpl
extends RefJavaElementImpl
implements RefClass {
    private static final Set<RefElement> EMPTY_SET = Collections.emptySet();
    private static final Set<RefClass> EMPTY_CLASS_SET = Collections.emptySet();
    private static final List<RefMethod> EMPTY_METHOD_LIST = ContainerUtil.emptyList();
    private static final int IS_ANONYMOUS_MASK = 65536;
    private static final int IS_INTERFACE_MASK = 131072;
    private static final int IS_UTILITY_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_APPLET_MASK = 0x200000;
    private static final int IS_SERVLET_MASK = 0x400000;
    private static final int IS_TESTCASE_MASK = 0x800000;
    private static final int IS_LOCAL_MASK = 0x1000000;
    private static final int IS_ANDROID_MASK = 0x2000000;
    private Set<RefClass> myBases;
    private Set<RefClass> mySubClasses;
    private List<RefMethod> myConstructors;
    private RefMethodImpl myDefaultConstructor;
    private List<RefMethod> myOverridingMethods;
    private Set<RefElement> myInTypeReferences;
    private List<RefJavaElement> myClassExporters;
    private final RefModule myRefModule;

    RefClassImpl(UClass uClass, PsiElement psi, RefManager manager) {
        super((UDeclaration)uClass, psi, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        RefJavaManager refManager;
        PsiElement psi;
        RefClassImpl refClassImpl = this;
        synchronized (refClassImpl) {
            this.myDefaultConstructor = null;
        }
        PsiClass psiClass = this.getElement();
        UClass uClass = this.getUastElement();
        LOG.assertTrue(uClass != null);
        UDeclaration parent = UDeclarationKt.getContainingDeclaration((UElement)uClass);
        while (!(parent == null || parent instanceof UMethod || parent instanceof UClass || parent instanceof UField)) {
            parent = UDeclarationKt.getContainingDeclaration((UElement)parent);
        }
        if (parent != null) {
            RefElement refParent = this.getRefManager().getReference(parent.getSourcePsi());
            LOG.assertTrue(refParent != null);
            ((RefElementImpl)refParent).add((RefEntity)this);
        } else {
            PsiFile containingFile = this.getContainingFile();
            if (this.isSyntheticJSP()) {
                PsiFile psiFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)this.getPsiElement());
                RefFileImpl refFile = (RefFileImpl)this.getRefManager().getReference((PsiElement)psiFile);
                LOG.assertTrue(refFile != null);
                refFile.add((RefEntity)this);
            } else if (RefClassImpl.isKindOfJvmLanguage(containingFile.getLanguage())) {
                String packageName = ((UFile)UastContextKt.toUElement((PsiElement)containingFile, UFile.class)).getPackageName();
                if (!packageName.isEmpty()) {
                    ((RefPackageImpl)this.getRefJavaManager().getPackage(packageName)).add((RefEntity)this);
                } else {
                    ((RefPackageImpl)this.getRefJavaManager().getDefaultPackage()).add((RefEntity)this);
                }
            } else {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
                LOG.assertTrue(module != null);
                WritableRefEntity refModule = (WritableRefEntity)this.getRefManager().getRefModule(module);
                LOG.assertTrue(refModule != null);
                refModule.add((RefEntity)this);
            }
        }
        if (!this.myManager.isDeclarationsFound()) {
            return;
        }
        PsiClass javaPsi = uClass.getJavaPsi();
        this.setAbstract(javaPsi.hasModifier(JvmModifier.ABSTRACT));
        this.setAnonymous(uClass.getName() == null);
        this.setIsLocal(!this.isAnonymous() && parent != null && !(parent instanceof UClass));
        this.setInterface(uClass.isInterface());
        this.initializeSuperReferences(uClass);
        UMethod[] uMethods = uClass.getMethods();
        UField[] uFields = uClass.getFields();
        boolean utilityClass = uMethods.length > 0 || uFields.length > 0;
        for (UField uField : uFields) {
            this.getRefManager().getReference(uField.getSourcePsi());
        }
        if (!this.isApplet()) {
            this.setServlet(JvmInheritanceUtil.isInheritor((JvmClass)javaPsi, (String)this.getRefJavaManager().getServletQName()));
        }
        if (!this.isApplet() && !this.isServlet() && (psi = uClass.getSourcePsi()) instanceof PsiClass) {
            boolean isTestClass = TestFrameworks.getInstance().isTestClass((PsiClass)psi);
            this.setTestCase(isTestClass);
            if (isTestClass) {
                for (RefClass refBase : this.getBaseClasses()) {
                    ((RefClassImpl)refBase).setTestCase(true);
                }
            }
        }
        if (RefClassImpl.inheritsFrom(psiClass, (refManager = this.getRefJavaManager()).getAndroidActivity()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidService()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidView()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidFragment(false)) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidFragment(true)) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidReceiver()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidContentProvider()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidParcelable()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidBackupAgent()) || RefClassImpl.inheritsFrom(psiClass, refManager.getAndroidActionProvider())) {
            this.setAndroidPublic(true);
        }
        RefMethod varargConstructor = null;
        for (UMethod uMethod : uMethods) {
            RefMethod refMethod = (RefMethod)ObjectUtils.tryCast((Object)this.getRefManager().getReference(uMethod.getSourcePsi()), RefMethod.class);
            if (refMethod == null) continue;
            if (uMethod.isConstructor()) {
                PsiElement parameterPsi;
                List parameters2 = uMethod.getUastParameters();
                if (!parameters2.isEmpty() || uMethod.getVisibility() != UastVisibility.PRIVATE) {
                    utilityClass = false;
                }
                this.addConstructor(refMethod);
                if (parameters2.isEmpty()) {
                    this.setDefaultConstructor((RefMethodImpl)refMethod);
                    continue;
                }
                if (parameters2.size() != 1 || !((parameterPsi = ((UParameter)parameters2.get(0)).getJavaPsi()) instanceof PsiParameter) || !((PsiParameter)parameterPsi).isVarArgs()) continue;
                varargConstructor = refMethod;
                continue;
            }
            if (uMethod.isStatic()) continue;
            utilityClass = false;
        }
        if (!utilityClass) {
            utilityClass = ClassUtils.isSingleton(uClass.getJavaPsi());
        }
        if (varargConstructor != null && this.getDefaultConstructor() == null) {
            this.setDefaultConstructor((RefMethodImpl)varargConstructor);
        }
        if (this.getConstructors().isEmpty() && !this.isInterface() && !this.isAnonymous()) {
            RefImplicitConstructorImpl refImplicitConstructor = new RefImplicitConstructorImpl(this);
            this.setDefaultConstructor(refImplicitConstructor);
            this.addConstructor(refImplicitConstructor);
        }
        if (this.isInterface()) {
            for (int i = 0; i < uFields.length && this.isUtilityClass(); ++i) {
                UField psiField = uFields[i];
                if (psiField.hasModifier(JvmModifier.STATIC)) continue;
                utilityClass = false;
            }
        }
        this.setUtilityClass(utilityClass);
        PsiClass applet = this.getRefJavaManager().getApplet();
        this.setApplet(applet != null && JvmInheritanceUtil.isInheritor((JvmClass)uClass, (String)this.getRefJavaManager().getAppletQName()));
        PsiManager psiManager = this.getRefManager().getPsiManager();
        psiManager.dropResolveCaches();
        PsiFile file = this.getContainingFile();
        if (file != null) {
            InjectedLanguageManager.getInstance((Project)file.getProject()).dropFileCaches(file);
        }
    }

    private static boolean inheritsFrom(@NotNull PsiClass c1, @Nullable PsiClass c2) {
        return c2 != null && c1.isInheritor(c2, true);
    }

    private void initializeSuperReferences(UClass uClass) {
        if (!this.isSelfInheritor(uClass)) {
            uClass.getUastSuperTypes().stream().map(t -> PsiUtil.resolveClassInType((PsiType)t.getType())).filter(Objects::nonNull).filter(c -> this.getRefJavaManager().belongsToScope((PsiElement)c)).forEach(c -> {
                RefClassImpl refClass = (RefClassImpl)this.getRefManager().getReference((PsiElement)c);
                if (refClass != null) {
                    this.addBaseClass(refClass);
                    refClass.addSubClass(this);
                }
            });
        }
    }

    public boolean isSelfInheritor(@NotNull UClass uClass) {
        return RefClassImpl.isSelfInheritor(uClass, new ArrayList());
    }

    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    private static boolean isSelfInheritor(UClass uClass, List<? super UClass> visited) {
        if (visited.contains(uClass)) {
            return true;
        }
        visited.add((UClass)uClass);
        if (uClass.getUastSuperTypes().stream().map(t -> PsiUtil.resolveClassInType((PsiType)t.getType())).filter(Objects::nonNull).map(c -> (UClass)UastContextKt.toUElement((PsiElement)c, UClass.class)).filter(Objects::nonNull).anyMatch(c -> RefClassImpl.isSelfInheritor(c, visited))) {
            return true;
        }
        visited.remove(uClass);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefaultConstructor(RefMethodImpl defaultConstructor) {
        if (defaultConstructor != null) {
            for (RefClass superClass : this.getBaseClasses()) {
                WritableRefElement superDefaultConstructor = (WritableRefElement)superClass.getDefaultConstructor();
                if (superDefaultConstructor == null) continue;
                superDefaultConstructor.addInReference((RefElement)defaultConstructor);
                defaultConstructor.addOutReference((RefElement)superDefaultConstructor);
            }
        }
        RefClassImpl refClassImpl = this;
        synchronized (refClassImpl) {
            this.myDefaultConstructor = defaultConstructor;
        }
    }

    public UClass getUastElement() {
        return (UClass)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UClass.class);
    }

    @NotNull
    public String getQualifiedName() {
        UClass uClass = this.getUastElement();
        if (uClass == null) {
            return super.getQualifiedName();
        }
        String qName = uClass.getQualifiedName();
        if (qName == null) {
            return super.getQualifiedName();
        }
        return qName;
    }

    /*
     * WARNING - void declaration
     */
    public void buildReferences() {
        UClass uClass = this.getUastElement();
        if (uClass != null) {
            UMethod[] psiMethods;
            void var5_11;
            UField[] uFields;
            PsiTypeParameter[] objectAccess;
            if (uClass instanceof UAnonymousClass && (objectAccess = (PsiTypeParameter[])UastUtils.getParentOfType((UElement)uClass, UObjectLiteralExpression.class)) != null && objectAccess.getDeclaration().getSourcePsi() == uClass.getSourcePsi()) {
                RefJavaUtil.getInstance().addReferencesTo((UDeclaration)uClass, (RefJavaElement)this, objectAccess.getValueArguments().toArray(UElementKt.EMPTY_ARRAY));
            }
            for (UObjectLiteralExpression uObjectLiteralExpression : uClass.getInitializers()) {
                RefJavaUtil.getInstance().addReferencesTo((UDeclaration)uClass, (RefJavaElement)this, new UElement[]{uObjectLiteralExpression.getUastBody()});
            }
            RefJavaUtil.getInstance().addReferencesTo((UDeclaration)uClass, (RefJavaElement)this, uClass.getAnnotations().toArray(UElementKt.EMPTY_ARRAY));
            for (PsiTypeParameter psiTypeParameter : uClass.getJavaPsi().getTypeParameters()) {
                UElement uTypeParameter = UastContextKt.toUElement((PsiElement)psiTypeParameter);
                if (uTypeParameter == null) continue;
                RefJavaUtil.getInstance().addReferencesTo((UDeclaration)uClass, (RefJavaElement)this, new UElement[]{uTypeParameter});
            }
            UField[] uFieldArray = uFields = uClass.getFields();
            int n = uFieldArray.length;
            boolean bl = false;
            while (var5_11 < n) {
                UField uField = uFieldArray[var5_11];
                this.getRefManager().getReference((PsiElement)uField.getPsi());
                UExpression initializer = uField.getUastInitializer();
                if (initializer != null) {
                    RefJavaUtil.getInstance().addReferencesTo((UDeclaration)uClass, (RefJavaElement)this, new UElement[]{initializer});
                }
                ++var5_11;
            }
            for (UMethod uMethod : psiMethods = uClass.getMethods()) {
                this.getRefManager().getReference(uMethod.getSourcePsi());
            }
            RefJavaUtil.getInstance().addReferencesTo((UDeclaration)uClass, (RefJavaElement)this, uClass.getUastSuperTypes().toArray(UElementKt.EMPTY_ARRAY));
            this.getRefManager().fireBuildReferences((RefElement)this);
        }
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> ((RefJavaVisitor)visitor).visitClass((RefClass)this));
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public synchronized Set<RefClass> getBaseClasses() {
        if (this.myBases == null) {
            return EMPTY_CLASS_SET;
        }
        return this.myBases;
    }

    private synchronized void addBaseClass(RefClass refClass) {
        if (this.myBases == null) {
            this.myBases = Collections.singleton(refClass);
            return;
        }
        if (this.myBases.size() == 1) {
            this.myBases = new THashSet(this.myBases);
        }
        this.myBases.add(refClass);
    }

    @NotNull
    public synchronized Set<RefClass> getSubClasses() {
        if (this.mySubClasses == null) {
            return EMPTY_CLASS_SET;
        }
        return this.mySubClasses;
    }

    private synchronized void addSubClass(@NotNull RefClass refClass) {
        if (this.mySubClasses == null) {
            this.mySubClasses = Collections.singleton(refClass);
            return;
        }
        if (this.mySubClasses.size() == 1) {
            this.mySubClasses = new THashSet(this.mySubClasses);
        }
        this.mySubClasses.add(refClass);
    }

    private synchronized void removeSubClass(RefClass refClass) {
        if (this.mySubClasses == null) {
            return;
        }
        if (this.mySubClasses.size() == 1) {
            this.mySubClasses = null;
        } else {
            this.mySubClasses.remove(refClass);
        }
    }

    @NotNull
    public synchronized List<RefMethod> getConstructors() {
        if (this.myConstructors == null) {
            return EMPTY_METHOD_LIST;
        }
        return this.myConstructors;
    }

    @NotNull
    public synchronized Set<RefElement> getInTypeReferences() {
        if (this.myInTypeReferences == null) {
            return EMPTY_SET;
        }
        return this.myInTypeReferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTypeReference(RefJavaElement from) {
        if (from != null) {
            RefClassImpl refClassImpl = this;
            synchronized (refClassImpl) {
                if (this.myInTypeReferences == null) {
                    this.myInTypeReferences = new THashSet(1);
                }
                this.myInTypeReferences.add((RefElement)from);
            }
            ((RefJavaElementImpl)from).addOutTypeReference(this);
            this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)from, false, false, false);
        }
    }

    public synchronized RefMethod getDefaultConstructor() {
        return this.myDefaultConstructor;
    }

    private synchronized void addConstructor(RefMethod refConstructor) {
        if (this.myConstructors == null) {
            this.myConstructors = new ArrayList<RefMethod>(1);
        }
        this.myConstructors.add(refConstructor);
    }

    synchronized void addLibraryOverrideMethod(RefMethod refMethod) {
        if (this.myOverridingMethods == null) {
            this.myOverridingMethods = new ArrayList<RefMethod>(2);
        }
        this.myOverridingMethods.add(refMethod);
    }

    @NotNull
    public synchronized List<RefMethod> getLibraryMethods() {
        if (this.myOverridingMethods == null) {
            return EMPTY_METHOD_LIST;
        }
        return this.myOverridingMethods;
    }

    public boolean isAnonymous() {
        return this.checkFlag(65536L);
    }

    public boolean isInterface() {
        return this.checkFlag(131072L);
    }

    public boolean isSuspicious() {
        return (!this.isUtilityClass() || !this.getOutReferences().isEmpty()) && super.isSuspicious();
    }

    public boolean isUtilityClass() {
        return this.checkFlag(262144L);
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UClass psiClass = this.getUastElement();
            LOG.assertTrue(psiClass != null);
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)psiClass.getJavaPsi());
        });
    }

    @Nullable
    static RefClass classFromExternalName(RefManager manager, String externalName) {
        return (RefClass)manager.getReference((PsiElement)ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)manager.getProject()), (String)externalName));
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        for (RefClass subClass : this.getSubClasses()) {
            ((RefClassImpl)subClass).removeBase(this);
        }
        for (RefClass superClass : this.getBaseClasses()) {
            ((RefClassImpl)superClass).removeSubClass(this);
        }
    }

    private synchronized void removeBase(RefClass superClass) {
        Set<RefClass> baseClasses = this.getBaseClasses();
        if (baseClasses.contains(superClass)) {
            if (baseClasses.size() == 1) {
                this.myBases = null;
                return;
            }
            baseClasses.remove(superClass);
        }
    }

    void methodRemoved(RefMethod method) {
        this.getConstructors().remove(method);
        this.getLibraryMethods().remove(method);
        if (this.getDefaultConstructor() == method) {
            this.setDefaultConstructor(null);
        }
    }

    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    public boolean isApplet() {
        return this.checkFlag(0x200000L);
    }

    public boolean isServlet() {
        return this.checkFlag(0x400000L);
    }

    public boolean isAndroidPublic() {
        return this.checkFlag(0x2000000L);
    }

    public boolean isTestCase() {
        return this.checkFlag(0x800000L);
    }

    public boolean isLocalClass() {
        return this.checkFlag(0x1000000L);
    }

    public boolean isReferenced() {
        if (super.isReferenced()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    public boolean hasSuspiciousCallers() {
        if (super.hasSuspiciousCallers()) {
            return true;
        }
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    synchronized void addClassExporter(RefJavaElement exporter) {
        if (this.myClassExporters == null) {
            this.myClassExporters = new ArrayList<RefJavaElement>(1);
        }
        if (this.myClassExporters.contains(exporter)) {
            return;
        }
        this.myClassExporters.add(exporter);
    }

    public synchronized List<RefJavaElement> getClassExporters() {
        return this.myClassExporters;
    }

    private void setAnonymous(boolean anonymous) {
        this.setFlag(anonymous, 65536L);
    }

    private void setInterface(boolean anInterface) {
        this.setFlag(anInterface, 131072L);
    }

    private void setUtilityClass(boolean utilityClass) {
        this.setFlag(utilityClass, 262144L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    private void setApplet(boolean applet) {
        this.setFlag(applet, 0x200000L);
    }

    private void setServlet(boolean servlet) {
        this.setFlag(servlet, 0x400000L);
    }

    private void setAndroidPublic(boolean android) {
        this.setFlag(android, 0x2000000L);
    }

    private void setTestCase(boolean testCase) {
        this.setFlag(testCase, 0x800000L);
    }

    private void setIsLocal(boolean isLocal) {
        this.setFlag(isLocal, 0x1000000L);
    }

    @NotNull
    public RefElement getContainingEntry() {
        RefMethod defaultConstructor = this.getDefaultConstructor();
        if (defaultConstructor != null) {
            return defaultConstructor;
        }
        return super.getContainingEntry();
    }

    private static boolean isKindOfJvmLanguage(Language language) {
        return ((JvmMetaLanguage)Language.findInstance(JvmMetaLanguage.class)).getMatchingLanguages().stream().anyMatch(arg_0 -> ((Language)language).is(arg_0));
    }
}

