/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaModule;
import com.intellij.codeInspection.reference.RefJavaModuleImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.uast.UastVisitorAdapter;
import com.intellij.util.ObjectUtils;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Condition<PsiElement> PROBLEM_ELEMENT_CONDITION = Conditions.or((Condition)Conditions.instanceOf((Class[])new Class[]{PsiFile.class, PsiJavaModule.class}), (Condition)Conditions.and((Condition)Conditions.notInstanceOf(PsiTypeParameter.class), psi -> {
        UDeclaration decl = (UDeclaration)UastContextKt.toUElement((PsiElement)psi, UDeclaration.class);
        return decl != null && (decl instanceof UField || !(decl instanceof UVariable)) && !(decl instanceof UClassInitializer);
    }));
    private static final Logger LOG = Logger.getInstance(RefJavaManagerImpl.class);
    public static final String JAVAX_SERVLET_SERVLET = "javax.servlet.Servlet";
    private final PsiMethod myAppMainPattern;
    private final PsiMethod myAppPremainPattern;
    private final PsiMethod myAppAgentmainPattern;
    private final PsiClass myApplet;
    private final PsiClass myAndroidActivity;
    private final PsiClass myAndroidService;
    private final PsiClass myAndroidBackupAgent;
    private final PsiClass myAndroidFragment;
    private final PsiClass myAndroidV4Fragment;
    private final PsiClass myAndroidContentProvider;
    private final PsiClass myAndroidReceiver;
    private final PsiClass myAndroidView;
    private final PsiClass myAndroidActionProvider;
    private final PsiClass myAndroidParcelable;
    private volatile RefPackage myCachedDefaultPackage;
    private Map<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;

    public RefJavaManagerImpl(@NotNull RefManagerImpl manager) {
        this.myRefManager = manager;
        Project project = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        this.myAppMainPattern = factory.createMethodFromText("void main(String[] args);", null);
        this.myAppPremainPattern = factory.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
        this.myAppAgentmainPattern = factory.createMethodFromText("void agentmain(String[] args, java.lang.instrument.Instrumentation i);", null);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
        this.myApplet = psiFacade.findClass("java.applet.Applet", scope);
        this.myAndroidActivity = psiFacade.findClass("android.app.Activity", scope);
        this.myAndroidService = psiFacade.findClass("android.app.Service", scope);
        this.myAndroidFragment = psiFacade.findClass("android.app.Fragment", scope);
        this.myAndroidV4Fragment = psiFacade.findClass("android.support.v4.app.Fragment", scope);
        this.myAndroidContentProvider = psiFacade.findClass("android.content.ContentProvider", scope);
        this.myAndroidReceiver = psiFacade.findClass("android.content.BroadcastReceiver", scope);
        this.myAndroidView = psiFacade.findClass("android.view.View", scope);
        this.myAndroidActionProvider = psiFacade.findClass("android.view.ActionProvider", scope);
        this.myAndroidParcelable = psiFacade.findClass("android.os.Parcelable", scope);
        this.myAndroidBackupAgent = psiFacade.findClass("android.app.backup.BackupAgent", scope);
    }

    public RefImplicitConstructor getImplicitConstructor(String classFQName) {
        RefEntity entity = this.getReference("class", classFQName);
        if (entity == null) {
            return null;
        }
        RefClass refClass = (RefClass)entity;
        return (RefImplicitConstructor)refClass.getDefaultConstructor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            if (this.myPackages == null) {
                this.myPackages = new THashMap();
            }
            refPackage = this.myPackages.get(packageName);
        }
        if (refPackage == null) {
            boolean saved;
            refPackage = new RefPackageImpl(packageName, (RefManager)this.myRefManager);
            RefJavaManagerImpl refJavaManagerImpl2 = this;
            synchronized (refJavaManagerImpl2) {
                RefPackage oldPackage = this.myPackages.get(packageName);
                if (oldPackage == null) {
                    this.myPackages.put(packageName, refPackage);
                    saved = true;
                } else {
                    refPackage = oldPackage;
                    saved = false;
                }
            }
            if (saved) {
                int dotIndex = packageName.lastIndexOf(46);
                if (dotIndex >= 0) {
                    ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add((RefEntity)refPackage);
                } else {
                    ((RefProjectImpl)this.myRefManager.getRefProject()).add((RefEntity)refPackage);
                }
            }
        }
        return refPackage;
    }

    private boolean isEntryPoint(RefElement element) {
        UnusedDeclarationInspectionBase tool = this.getDeadCodeTool(element);
        return tool != null && tool.isEntryPoint(element) && RefJavaManagerImpl.isTestSource(tool, element);
    }

    private static boolean isTestSource(UnusedDeclarationInspectionBase tool, RefElement refElement) {
        if (tool.isTestEntryPoints()) {
            return true;
        }
        PsiElement element = refElement.getPsiElement();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element);
        return file != null && !ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInTestSourceContent(file);
    }

    @Nullable
    private UnusedDeclarationInspectionBase getDeadCodeTool(RefElement element) {
        PsiFile file = ((RefElementImpl)element).getContainingFile();
        if (file == null) {
            return null;
        }
        return this.getDeadCodeTool(file.getContainingFile());
    }

    private UnusedDeclarationInspectionBase getDeadCodeTool(PsiFile file) {
        GlobalInspectionContextBase contextBase = (GlobalInspectionContextBase)this.myRefManager.getContext();
        Tools tools = (Tools)contextBase.getTools().get("unused");
        if (tools == null) {
            String singleTool = contextBase.getCurrentProfile().getSingleTool();
            if (singleTool != null && !"unused".equals(singleTool)) {
                return UnusedDeclarationInspectionBase.findUnusedDeclarationInspection((PsiElement)file);
            }
            return null;
        }
        InspectionToolWrapper toolWrapper = tools.getEnabledTool((PsiElement)file);
        InspectionProfileEntry tool = toolWrapper == null ? null : toolWrapper.getTool();
        return tool instanceof UnusedDeclarationInspectionBase ? (UnusedDeclarationInspectionBase)tool : null;
    }

    public RefPackage getDefaultPackage() {
        RefPackage defaultPackage = this.myCachedDefaultPackage;
        if (defaultPackage == null) {
            this.myCachedDefaultPackage = defaultPackage = this.getPackage(InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]));
        }
        return defaultPackage;
    }

    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    public PsiMethod getAppAgentmainPattern() {
        return this.myAppAgentmainPattern;
    }

    public PsiClass getApplet() {
        return this.myApplet;
    }

    public String getAppletQName() {
        return this.myApplet.getQualifiedName();
    }

    public String getServletQName() {
        return JAVAX_SERVLET_SERVLET;
    }

    public PsiClass getAndroidActivity() {
        return this.myAndroidActivity;
    }

    public PsiClass getAndroidService() {
        return this.myAndroidService;
    }

    public PsiClass getAndroidBackupAgent() {
        return this.myAndroidBackupAgent;
    }

    public PsiClass getAndroidFragment(boolean support) {
        return support ? this.myAndroidV4Fragment : this.myAndroidFragment;
    }

    public PsiClass getAndroidContentProvider() {
        return this.myAndroidContentProvider;
    }

    public PsiClass getAndroidReceiver() {
        return this.myAndroidReceiver;
    }

    public PsiClass getAndroidView() {
        return this.myAndroidView;
    }

    public PsiClass getAndroidActionProvider() {
        return this.myAndroidActionProvider;
    }

    public PsiClass getAndroidParcelable() {
        return this.myAndroidParcelable;
    }

    public RefParameter getParameterReference(UParameter param, int index, RefMethod refMethod) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), (Object)"References may become invalid after process is finished");
        PsiElement psi = param.getSourcePsi();
        return (RefParameter)this.myRefManager.getFromRefTableOrCache(psi, () -> {
            RefParameterImpl ref = new RefParameterImpl(param, psi, index, (RefManager)this.myRefManager, refMethod);
            ref.initialize();
            return ref;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(@NotNull RefVisitor visitor) {
        Map<String, RefPackage> packages;
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            packages = this.myPackages;
        }
        if (packages != null) {
            for (RefPackage refPackage : packages.values()) {
                refPackage.accept(visitor);
            }
        }
        for (RefElement refElement : this.myRefManager.getSortedElements()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose((Disposable)this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        RefJavaManagerImpl refJavaManagerImpl = this;
        synchronized (refJavaManagerImpl) {
            this.myPackages = null;
            this.myCachedDefaultPackage = null;
        }
        this.myProjectIterator = null;
    }

    public void removeReference(@NotNull RefElement refElement) {
    }

    @Nullable
    public RefElement createRefElement(@NotNull PsiElement psi) {
        if (!this.getLanguages().contains(psi.getLanguage())) {
            return null;
        }
        if (psi instanceof PsiFile) {
            return new RefJavaFileImpl((PsiFile)psi, (RefManager)this.myRefManager);
        }
        if (psi instanceof PsiJavaModule) {
            return new RefJavaModuleImpl((PsiJavaModule)psi, this.myRefManager);
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)psi);
        if (uElement instanceof UClass) {
            return new RefClassImpl((UClass)uElement, psi, (RefManager)this.myRefManager);
        }
        if (uElement instanceof UMethod) {
            return new RefMethodImpl((UMethod)uElement, psi, (RefManager)this.myRefManager);
        }
        if (uElement instanceof UField) {
            return new RefFieldImpl((UField)uElement, psi, (RefManager)this.myRefManager);
        }
        return null;
    }

    @Nullable
    public PsiNamedElement getElementContainer(@NotNull PsiElement psiElement) {
        return (PsiNamedElement)PsiTreeUtil.findFirstParent((PsiElement)psiElement, PROBLEM_ELEMENT_CONDITION);
    }

    @Nullable
    public RefEntity getReference(String type2, String fqName) {
        if ("implicit.constructor".equals(type2)) {
            return this.getImplicitConstructor(fqName);
        }
        if ("method".equals(type2)) {
            return RefMethodImpl.methodFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("class".equals(type2)) {
            return RefClassImpl.classFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("field".equals(type2)) {
            return RefFieldImpl.fieldFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("parameter".equals(type2)) {
            return RefParameterImpl.parameterFromExternalName((RefManager)this.myRefManager, fqName);
        }
        if ("package".equals(type2)) {
            return RefPackageImpl.packageFromFQName((RefManager)this.myRefManager, fqName);
        }
        if ("java.module".equals(type2)) {
            return RefJavaModuleImpl.moduleFromExternalName(this.myRefManager, fqName);
        }
        return null;
    }

    @Nullable
    public String getType(@NotNull RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return "implicit.constructor";
        }
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        if (ref instanceof RefJavaModule) {
            return "java.module";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return ((RefImplicitConstructor)ref).getOwnerClass();
        }
        return ref;
    }

    public void visitElement(@NotNull PsiElement element) {
        Object projectIterator = this.myProjectIterator;
        if (projectIterator == null) {
            this.myProjectIterator = projectIterator = new UastVisitorAdapter(new MyJavaElementVisitor(), true){

                public void visitElement(PsiElement element) {
                    super.visitElement(element);
                    if (element instanceof PsiJavaModule) {
                        this.visitJavaModule((PsiJavaModule)element);
                    }
                }

                private void visitJavaModule(PsiJavaModule module) {
                    RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)module);
                    if (refElement != null) {
                        ((RefJavaModuleImpl)refElement).buildReferences();
                    }
                }
            };
        }
        element.accept(projectIterator);
    }

    @Nullable
    public String getGroupName(@NotNull RefEntity entity) {
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    public boolean belongsToScope(@NotNull PsiElement psiElement) {
        return !(psiElement instanceof PsiTypeParameter);
    }

    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        String packageName = RefJavaUtil.getInstance().getPackageName(refEntity);
        if (packageName != null) {
            Element packageElement = new Element("package");
            packageElement.addContent(packageName.isEmpty() ? InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : packageName);
            element.addContent(packageElement);
        }
    }

    public void onEntityInitialized(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (this.myRefManager.isOfflineView()) {
            return;
        }
        if (this.isEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
    }

    public boolean shouldProcessExternalFile(@NotNull PsiFile file) {
        return file instanceof PsiClassOwner;
    }

    @NotNull
    public Stream<? extends PsiElement> extractExternalFileImplicitReferences(@NotNull PsiFile psiFile) {
        return Arrays.stream(((PsiClassOwner)psiFile).getClasses()).flatMap(c -> Arrays.stream(c.getSuperTypes())).map(PsiClassType::resolve).filter(Objects::nonNull);
    }

    public void markExternalReferencesProcessed(@NotNull RefElement file) {
        this.getEntryPointsManager().addEntryPoint(file, false);
    }

    public EntryPointsManager getEntryPointsManager() {
        EntryPointsManager entryPointsManager = this.myEntryPointsManager;
        if (entryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = entryPointsManager = new EntryPointsManagerBase(project){

                public void configureAnnotations() {
                }
            };
            Disposer.register((Disposable)project, (Disposable)entryPointsManager);
            ((EntryPointsManagerBase)entryPointsManager).addAllPersistentEntries(EntryPointsManagerBase.getInstance(project));
        }
        return entryPointsManager;
    }

    private class MyJavaElementVisitor
    extends AbstractUastNonRecursiveVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();
        private final ExternalAnnotationsManager myExternalAnnotationsManager = ExternalAnnotationsManager.getInstance((Project)RefJavaManagerImpl.access$100(RefJavaManagerImpl.this).getProject());

        private MyJavaElementVisitor() {
        }

        public boolean visitFile(@NotNull UFile node) {
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference(node.getSourcePsi());
            if (refElement instanceof RefJavaFileImpl) {
                ((RefJavaFileImpl)refElement).buildReferences();
            }
            return true;
        }

        public boolean visitDeclaration(@NotNull UDeclaration node) {
            PsiAnnotation externalAnnotation;
            UAnnotation uAnnotation2;
            PsiModifierListOwner javaModifiersListOwner;
            this.processComments((UElement)node);
            RefElement decl = RefJavaManagerImpl.this.myRefManager.getReference(node.getSourcePsi());
            if (decl != null) {
                ((RefElementImpl)decl).buildReferences();
            }
            if ((javaModifiersListOwner = (PsiModifierListOwner)ObjectUtils.tryCast((Object)node.getJavaPsi(), PsiModifierListOwner.class)) != null && (uAnnotation2 = (UAnnotation)UastContextKt.toUElement((PsiElement)(externalAnnotation = this.myExternalAnnotationsManager.findExternalAnnotation(javaModifiersListOwner, "java.lang.SuppressWarnings")), UAnnotation.class)) != null) {
                this.retrieveSuppressions(uAnnotation2, (UAnnotated)node);
            }
            return true;
        }

        public boolean visitField(@NotNull UField node) {
            this.visitDeclaration((UDeclaration)node);
            return false;
        }

        public boolean visitVariable(@NotNull UVariable variable) {
            RefElement reference;
            this.myRefUtil.addTypeReference((UElement)variable, variable.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
            if (variable instanceof UParameter && (reference = RefJavaManagerImpl.this.myRefManager.getReference(variable.getSourcePsi())) instanceof RefParameterImpl) {
                ((RefParameterImpl)reference).buildReferences();
            }
            return false;
        }

        public boolean visitAnnotation(@NotNull UAnnotation annotation) {
            String qualifiedName = annotation.getQualifiedName();
            if (Comparing.strEqual((String)qualifiedName, (String)"java.lang.SuppressWarnings") || Comparing.strEqual((String)qualifiedName, (String)"kotlin.Suppress")) {
                PsiElement sourcePsi;
                UElement parent;
                UAnnotated annotated = (UAnnotated)UastUtils.getParentOfType((UElement)annotation, UAnnotated.class);
                if (annotated == null && (parent = annotation.getUastParent()) == null && (sourcePsi = annotation.getSourcePsi()) != null) {
                    annotated = (UAnnotated)UastContextKt.toUElement((PsiElement)sourcePsi.getContainingFile(), UFile.class);
                }
                this.retrieveSuppressions(annotation, annotated);
            }
            return false;
        }

        private void retrieveSuppressions(UAnnotation annotation, UAnnotated annotated) {
            if (annotated != null) {
                PsiElement annotatedSrc = annotated.getSourcePsi();
                WritableRefElement element = (WritableRefElement)RefJavaManagerImpl.this.myRefManager.getReference(annotatedSrc);
                if (element != null) {
                    StringBuilder buf = new StringBuilder();
                    List nameValuePairs = annotation.getAttributeValues();
                    for (UNamedExpression nameValuePair : nameValuePairs) {
                        UExpression value2 = nameValuePair.getExpression();
                        if (value2 instanceof ULiteralExpression) {
                            Object val = ((ULiteralExpression)value2).getValue();
                            if (!(val instanceof String)) continue;
                            buf.append(",").append(String.valueOf(val).replaceAll("[{}\"\"]", ""));
                            continue;
                        }
                        if (!(value2 instanceof UCallExpression) || ((UCallExpression)value2).getKind() != UastCallKind.NESTED_ARRAY_INITIALIZER) continue;
                        for (UExpression argument : ((UCallExpression)value2).getValueArguments()) {
                            Object val;
                            if (!(argument instanceof ULiteralExpression) || !((val = ((ULiteralExpression)argument).getValue()) instanceof String)) continue;
                            buf.append(",").append(val);
                        }
                    }
                    if (buf.length() > 0) {
                        String suppressId = buf.substring(1);
                        element.addSuppression(suppressId);
                        if (annotatedSrc instanceof PsiField) {
                            this.addSuppressionsForSiblings((PsiField)annotatedSrc, suppressId);
                        }
                    }
                }
            }
        }

        private void processComments(@NotNull UElement node) {
            for (UComment comment : node.getComments()) {
                PsiDocTag[] tags;
                PsiElement psi;
                if (!(comment instanceof UComment) || !((psi = comment.getSourcePsi()) instanceof PsiDocComment)) continue;
                for (PsiDocTag tag : tags = ((PsiDocComment)psi).getTags()) {
                    WritableRefElement element;
                    PsiModifierListOwner listOwner;
                    Object[] dataElements;
                    if (!Comparing.strEqual((String)tag.getName(), (String)"noinspection") || (dataElements = tag.getDataElements()).length <= 0 || (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)psi, PsiModifierListOwner.class)) == null || (element = (WritableRefElement)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) == null) continue;
                    String suppression = StringUtil.join((Object[])dataElements, PsiElement::getText, (String)",");
                    element.addSuppression(suppression);
                }
            }
        }

        private void addSuppressionsForSiblings(PsiField listOwner, String suppressId) {
            PsiElement psiElement;
            PsiField field = listOwner;
            while ((psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)field)) != null && JavaTokenType.COMMA.equals(psiElement.getNode().getElementType()) && (psiElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)psiElement)) instanceof PsiField) {
                field = (PsiField)psiElement;
                RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)field);
                if (refElement == null) continue;
                ((WritableRefElement)refElement).addSuppression(suppressId);
            }
        }
    }
}

