/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.reference.WritableRefElement;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;

public class RefMethodImpl
extends RefJavaElementImpl
implements RefMethod {
    private static final List<RefMethod> EMPTY_METHOD_LIST = Collections.emptyList();
    private static final RefParameter[] EMPTY_PARAMS_ARRAY = new RefParameter[0];
    private static final int IS_APPMAIN_MASK = 65536;
    private static final int IS_LIBRARY_OVERRIDE_MASK = 131072;
    private static final int IS_CONSTRUCTOR_MASK = 262144;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_BODY_EMPTY_MASK = 0x100000;
    private static final int IS_ONLY_CALLS_SUPER_MASK = 0x200000;
    private static final int IS_RETURN_VALUE_USED_MASK = 0x400000;
    private static final int IS_TEST_METHOD_MASK = 0x4000000;
    private static final int IS_CALLED_ON_SUBCLASS_MASK = 0x8000000;
    private static final String RETURN_VALUE_UNDEFINED = "#";
    private List<RefMethod> mySuperMethods;
    private List<RefMethod> myDerivedMethods;
    private List<String> myUnThrownExceptions;
    private RefParameter[] myParameters;
    private volatile String myReturnValueTemplate = "#";

    RefMethodImpl(UMethod method, PsiElement psi, RefManager manager) {
        super((UDeclaration)method, psi, manager);
    }

    protected RefMethodImpl(@NotNull String name, @NotNull RefClass ownerClass) {
        super(name, (RefJavaElement)ownerClass);
        ((RefClassImpl)ownerClass).add((RefEntity)this);
        this.addOutReference((RefElement)ownerClass);
        ((WritableRefElement)ownerClass).addInReference((RefElement)this);
        this.setConstructor(true);
    }

    public synchronized void add(@NotNull RefEntity child) {
        if (child instanceof RefParameter) {
            ((WritableRefEntity)child).setOwner((WritableRefEntity)this);
            return;
        }
        super.add(child);
    }

    @NotNull
    public synchronized List<RefEntity> getChildren() {
        List superChildren = super.getChildren();
        if (this.myParameters == null) {
            return superChildren;
        }
        if (superChildren.isEmpty()) {
            return Arrays.asList(this.myParameters);
        }
        ArrayList<RefEntity> allChildren = new ArrayList<RefEntity>(superChildren.size() + this.myParameters.length);
        allChildren.addAll(superChildren);
        Collections.addAll(allChildren, this.myParameters);
        return allChildren;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        List paramList;
        UMethod method = (UMethod)this.getUastElement();
        LOG.assertTrue(method != null);
        PsiElement sourcePsi = method.getSourcePsi();
        LOG.assertTrue(sourcePsi != null);
        RefElement parentRef = RefMethodImpl.findParentRef(sourcePsi, (UElement)method, this.myManager);
        if (parentRef == null) {
            return;
        }
        ((WritableRefEntity)parentRef).add((RefEntity)this);
        if (!this.myManager.isDeclarationsFound()) {
            return;
        }
        PsiMethod javaPsi = method.getJavaPsi();
        this.setConstructor(method.isConstructor());
        PsiType returnType = method.getReturnType();
        this.setFlag(returnType == null || PsiType.VOID.equals((Object)returnType) || returnType.equalsToText("java.lang.Void"), 0x400000L);
        RefClass ownerClass = this.getOwnerClass();
        if (this.isConstructor()) {
            LOG.assertTrue(ownerClass != null);
            this.addReference((RefElement)ownerClass, ownerClass.getPsiElement(), (UDeclaration)method, false, true, null);
        }
        if (ownerClass != null && ownerClass.isInterface()) {
            this.setAbstract(false);
        } else {
            this.setAbstract(javaPsi.hasModifierProperty("abstract"));
        }
        this.setAppMain(RefMethodImpl.isAppMain(javaPsi, this));
        boolean isNative = javaPsi.hasModifierProperty("native");
        this.setLibraryOverride(isNative);
        this.initializeSuperMethods(javaPsi);
        if (ownerClass != null && this.isExternalOverride()) {
            ((RefClassImpl)ownerClass).addLibraryOverrideMethod(this);
        }
        String name = method.getName();
        if (ownerClass != null && ownerClass.isTestCase() && name.startsWith("test")) {
            this.setTestMethod(true);
        }
        if (!(paramList = method.getUastParameters()).isEmpty()) {
            RefParameterImpl[] newParameters = new RefParameterImpl[paramList.size()];
            for (int i = 0; i < paramList.size(); ++i) {
                newParameters[i] = this.getRefJavaManager().getParameterReference((UParameter)paramList.get(i), i, (RefMethod)this);
            }
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                this.myParameters = newParameters;
            }
        }
        if (isNative) {
            this.updateReturnValueTemplate(null);
            this.updateThrowsList(null);
        }
        if (sourcePsi.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            this.collectUncaughtExceptions((PsiMethod)sourcePsi);
        }
    }

    public void setParametersAreUnknown() {
        for (RefParameter parameter2 : this.getParameters()) {
            ((RefParameterImpl)parameter2).clearTemplateValue();
        }
        for (RefMethod method : this.getSuperMethods()) {
            ((RefMethodImpl)method).setParametersAreUnknown();
        }
    }

    private static boolean isAppMain(PsiMethod psiMethod, RefMethod refMethod) {
        if (!refMethod.isStatic()) {
            return false;
        }
        if (!PsiType.VOID.equals((Object)psiMethod.getReturnType())) {
            return false;
        }
        PsiMethod appMainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppMainPattern();
        if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appMainPattern)) {
            return true;
        }
        PsiMethod appPremainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppPremainPattern();
        if (MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appPremainPattern)) {
            return true;
        }
        PsiMethod appAgentmainPattern = ((RefMethodImpl)refMethod).getRefJavaManager().getAppAgentmainPattern();
        return MethodSignatureUtil.areSignaturesEqual((PsiMethod)psiMethod, (PsiMethod)appAgentmainPattern);
    }

    private void checkForSuperCall(UMethod method) {
        if (this.isConstructor()) {
            RefClass ownerClass;
            UExpression first;
            UExpression body2 = method.getUastBody();
            if (body2 == null) {
                return;
            }
            List statements = body2 instanceof UBlockExpression ? ((UBlockExpression)body2).getExpressions() : Collections.singletonList(body2);
            boolean isBaseExplicitlyCalled = false;
            if (!statements.isEmpty() && (first = (UExpression)statements.get(0)) instanceof UCallExpression && ((UCallExpression)first).getKind() == UastCallKind.CONSTRUCTOR_CALL) {
                isBaseExplicitlyCalled = true;
            }
            if (!isBaseExplicitlyCalled && (ownerClass = this.getOwnerClass()) != null) {
                for (RefClass superClass : ownerClass.getBaseClasses()) {
                    WritableRefElement superDefaultConstructor = (WritableRefElement)superClass.getDefaultConstructor();
                    if (superDefaultConstructor == null) continue;
                    superDefaultConstructor.addInReference((RefElement)this);
                    this.addOutReference((RefElement)superDefaultConstructor);
                }
            }
        }
    }

    @NotNull
    public synchronized Collection<RefMethod> getSuperMethods() {
        return (Collection)ObjectUtils.notNull(this.mySuperMethods, EMPTY_METHOD_LIST);
    }

    @NotNull
    public synchronized Collection<RefMethod> getDerivedMethods() {
        return (Collection)ObjectUtils.notNull(this.myDerivedMethods, EMPTY_METHOD_LIST);
    }

    public boolean isBodyEmpty() {
        return this.checkFlag(0x100000L);
    }

    public boolean isOnlyCallsSuper() {
        return this.checkFlag(0x200000L);
    }

    public boolean hasBody() {
        return !this.isAbstract() && !this.getOwnerClass().isInterface() || !this.isBodyEmpty();
    }

    private void initializeSuperMethods(PsiMethod method) {
        if (this.getRefManager().isOfflineView()) {
            return;
        }
        for (PsiMethod psiSuperMethod : method.findSuperMethods()) {
            if (this.getRefManager().belongsToScope((PsiElement)psiSuperMethod)) {
                RefMethodImpl refSuperMethod = (RefMethodImpl)this.getRefManager().getReference((PsiElement)psiSuperMethod);
                if (refSuperMethod != null) {
                    this.addSuperMethod(refSuperMethod);
                    refSuperMethod.markExtended(this);
                    continue;
                }
                this.setLibraryOverride(true);
                continue;
            }
            this.setLibraryOverride(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuperMethod(RefMethodImpl refSuperMethod) {
        if (!refSuperMethod.getSuperMethods().contains((Object)this)) {
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                List<RefMethod> superMethods = this.mySuperMethods;
                if (superMethods == null) {
                    this.mySuperMethods = superMethods = new ArrayList<RefMethod>(1);
                }
                if (!superMethods.contains((Object)refSuperMethod)) {
                    superMethods.add(refSuperMethod);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markExtended(RefMethodImpl method) {
        if (!method.getDerivedMethods().contains((Object)this)) {
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                List<RefMethod> derivedMethods = this.myDerivedMethods;
                if (derivedMethods == null) {
                    this.myDerivedMethods = derivedMethods = new ArrayList<RefMethod>(1);
                }
                if (!derivedMethods.contains((Object)method)) {
                    this.myDerivedMethods.add(method);
                }
            }
        }
    }

    @NotNull
    public synchronized RefParameter[] getParameters() {
        return (RefParameter[])ObjectUtils.notNull((Object)this.myParameters, (Object)EMPTY_PARAMS_ARRAY);
    }

    public void buildReferences() {
        UMethod method = (UMethod)this.getUastElement();
        if (method == null) {
            return;
        }
        UExpression body2 = method.getUastBody();
        RefJavaUtil refUtil = RefJavaUtil.getInstance();
        refUtil.addReferencesTo((UDeclaration)method, (RefJavaElement)this, new UElement[]{method});
        this.checkForSuperCall(method);
        this.setOnlyCallsSuper(refUtil.isMethodOnlyCallsSuper(method));
        this.setBodyEmpty(this.isOnlyCallsSuper() || !this.isExternalOverride() && RefMethodImpl.isEmptyExpression(body2));
        refUtil.addTypeReference((UElement)method, method.getReturnType(), (RefManager)this.getRefManager(), (RefJavaElement)this);
        for (RefParameter parameter2 : this.getParameters()) {
            UParameter uParameter = parameter2.getUastElement();
            if (uParameter == null) continue;
            refUtil.setIsFinal((RefJavaElement)parameter2, uParameter.isFinal());
        }
        this.getRefManager().fireBuildReferences((RefElement)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectUncaughtExceptions(@NotNull PsiMethod method) {
        if (this.getRefManager().isOfflineView()) {
            return;
        }
        PsiClassType[] throwsList = method.getThrowsList().getReferencedTypes();
        if (throwsList.length > 0) {
            Object unThrownExceptions = throwsList.length == 1 ? new SmartList() : new ArrayList(throwsList.length);
            for (PsiClassType type2 : throwsList) {
                String fqn;
                PsiClass aClass = type2.resolve();
                String string = fqn = aClass == null ? null : aClass.getQualifiedName();
                if (fqn == null) continue;
                unThrownExceptions.add(fqn);
            }
            RefMethodImpl refMethodImpl = this;
            synchronized (refMethodImpl) {
                this.myUnThrownExceptions = unThrownExceptions;
            }
        }
    }

    public synchronized void removeUnThrownExceptions(PsiClass unThrownException) {
        if (this.myUnThrownExceptions != null) {
            this.myUnThrownExceptions.remove(unThrownException.getQualifiedName());
        }
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor instanceof RefJavaVisitor) {
            ApplicationManager.getApplication().runReadAction(() -> ((RefJavaVisitor)visitor).visitMethod((RefMethod)this));
        } else {
            super.accept(visitor);
        }
    }

    public boolean isExternalOverride() {
        return this.isLibraryOverride(new HashSet());
    }

    private boolean isLibraryOverride(@NotNull Collection<? super RefMethod> processed) {
        if (!processed.add(this)) {
            return false;
        }
        if (this.checkFlag(131072L)) {
            return true;
        }
        for (RefMethod superMethod : this.getSuperMethods()) {
            if (!((RefMethodImpl)superMethod).isLibraryOverride(processed)) continue;
            this.setFlag(true, 131072L);
            return true;
        }
        return false;
    }

    public boolean isAppMain() {
        return this.checkFlag(65536L);
    }

    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    public boolean hasSuperMethods() {
        return !this.getSuperMethods().isEmpty() || this.isExternalOverride();
    }

    public boolean isReferenced() {
        for (RefElement refCaller : this.getInReferences()) {
            if (this.getDerivedMethods().contains(refCaller)) continue;
            return true;
        }
        return this.isExternalOverride();
    }

    public boolean hasSuspiciousCallers() {
        for (RefElement refCaller : this.getInReferences()) {
            if (!((RefElementImpl)refCaller).isSuspicious() || this.getDerivedMethods().contains(refCaller)) continue;
            return true;
        }
        if (this.isExternalOverride()) {
            return true;
        }
        if (!this.isStatic() && !this.isConstructor()) {
            for (RefMethod refSuper : this.getSuperMethods()) {
                if (!((RefMethodImpl)refSuper).isSuspicious()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConstructor() {
        return this.checkFlag(262144L);
    }

    @Nullable
    public RefClass getOwnerClass() {
        return (RefClass)ObjectUtils.tryCast((Object)this.getOwner(), RefClass.class);
    }

    @NotNull
    public String getName() {
        if (this.isValid()) {
            return (String)ReadAction.compute(() -> {
                UMethod uMethod = (UMethod)this.getUastElement();
                if (uMethod instanceof SyntheticElement) {
                    return uMethod.getName();
                }
                return PsiFormatUtil.formatMethod((PsiMethod)uMethod.getJavaPsi(), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            });
        }
        return super.getName();
    }

    public String getExternalName() {
        return (String)ReadAction.compute(() -> {
            UMethod uMethod = (UMethod)this.getUastElement();
            LOG.assertTrue(uMethod != null);
            PsiMethod javaMethod = uMethod.getJavaPsi();
            return PsiFormatUtil.getExternalName((PsiModifierListOwner)javaMethod, (boolean)true, (int)Integer.MAX_VALUE);
        });
    }

    @Nullable
    static RefMethod methodFromExternalName(RefManager manager, String externalName) {
        return (RefMethod)manager.getReference((PsiElement)RefMethodImpl.findPsiMethod(PsiManager.getInstance((Project)manager.getProject()), externalName));
    }

    @Nullable
    public static PsiMethod findPsiMethod(PsiManager manager, String externalName) {
        int spaceIdx = externalName.indexOf(32);
        String className = externalName.substring(0, spaceIdx);
        PsiClass psiClass = ClassUtil.findPsiClass((PsiManager)manager, (String)className);
        if (psiClass == null) {
            return null;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiClass.getProject());
            String methodSignature = externalName.substring(spaceIdx + 1);
            MethodSignature patternSignature = factory.createMethodFromText(methodSignature, (PsiElement)psiClass).getSignature(PsiSubstitutor.EMPTY);
            return Arrays.stream(psiClass.findMethodsByName(patternSignature.getName(), false)).filter(m -> {
                MethodSignature s = m.getSignature(PsiSubstitutor.EMPTY);
                MethodSignature refinedPatternSignature = factory.createMethodFromText(methodSignature, (PsiElement)m).getSignature(s.getSubstitutor());
                return MethodSignatureUtil.areErasedParametersEqual((MethodSignature)s, (MethodSignature)refinedPatternSignature);
            }).findFirst().orElse(null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Override
    public void referenceRemoved() {
        if (this.getOwnerClass() != null) {
            ((RefClassImpl)this.getOwnerClass()).methodRemoved(this);
        }
        super.referenceRemoved();
        for (RefMethod superMethod : this.getSuperMethods()) {
            superMethod.getDerivedMethods().remove((Object)this);
        }
        for (RefMethod subMethod : this.getDerivedMethods()) {
            subMethod.getSuperMethods().remove((Object)this);
        }
    }

    public boolean isSuspicious() {
        if (this.isConstructor() && "private".equals(this.getAccessModifier()) && this.getParameters().length == 0 && Objects.requireNonNull(this.getOwnerClass()).getConstructors().size() == 1) {
            return false;
        }
        return super.isSuspicious();
    }

    void setReturnValueUsed(boolean value2) {
        if (this.checkFlag(0x400000L) == value2) {
            return;
        }
        this.setFlag(value2, 0x400000L);
        for (RefMethod refSuper : this.getSuperMethods()) {
            ((RefMethodImpl)refSuper).setReturnValueUsed(value2);
        }
    }

    public boolean isReturnValueUsed() {
        return this.checkFlag(0x400000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateReturnValueTemplate(UExpression expression2) {
        if (expression2 == null) {
            return;
        }
        RefMethodImpl refMethodImpl = this;
        synchronized (refMethodImpl) {
            if (this.myReturnValueTemplate == null) {
                return;
            }
        }
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refMethod : this.getSuperMethods()) {
                RefMethodImpl refSuper = (RefMethodImpl)refMethod;
                refSuper.updateReturnValueTemplate(expression2);
            }
        } else {
            String newTemplate = null;
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (expression2 instanceof ULiteralExpression) {
                ULiteralExpression psiLiteralExpression = (ULiteralExpression)expression2;
                newTemplate = String.valueOf(psiLiteralExpression.getValue());
            } else if (expression2 instanceof UResolvable) {
                UResolvable referenceExpression = (UResolvable)expression2;
                UElement resolved = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
                if (resolved instanceof UField) {
                    UField uField = (UField)resolved;
                    PsiField psi = (PsiField)uField.getJavaPsi();
                    if (uField.isStatic() && uField.isFinal() && refUtil.compareAccess(refUtil.getAccessModifier((PsiModifierListOwner)psi), this.getAccessModifier()) >= 0) {
                        newTemplate = PsiFormatUtil.formatVariable((PsiVariable)psi, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    }
                }
            } else if (refUtil.isCallToSuperMethod(expression2, (UMethod)this.getUastElement())) {
                return;
            }
            RefMethodImpl refMethodImpl2 = this;
            synchronized (refMethodImpl2) {
                if (this.myReturnValueTemplate == RETURN_VALUE_UNDEFINED) {
                    this.myReturnValueTemplate = newTemplate;
                } else if (!Comparing.equal((String)this.myReturnValueTemplate, (String)newTemplate)) {
                    this.myReturnValueTemplate = null;
                }
            }
        }
    }

    void updateParameterValues(List<UExpression> args, @Nullable PsiElement elementPlace) {
        if (this.isExternalOverride()) {
            return;
        }
        if (!this.getSuperMethods().isEmpty()) {
            for (RefMethod refSuper : this.getSuperMethods()) {
                ((RefMethodImpl)refSuper).updateParameterValues(args, null);
            }
        } else {
            RefParameter[] params = this.getParameters();
            for (int i = 0; i < Math.min(params.length, args.size()); ++i) {
                ((RefParameterImpl)params[i]).updateTemplateValue(args.get(i), elementPlace);
            }
            if (params.length != args.size() && params.length != 0) {
                ((RefParameterImpl)params[params.length - 1]).clearTemplateValue();
            }
        }
    }

    public synchronized String getReturnValueIfSame() {
        if (this.myReturnValueTemplate == RETURN_VALUE_UNDEFINED) {
            return null;
        }
        return this.myReturnValueTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateThrowsList(PsiClassType exceptionType) {
        for (RefMethod refSuper : this.getSuperMethods()) {
            ((RefMethodImpl)refSuper).updateThrowsList(exceptionType);
        }
        Object object = this;
        synchronized (object) {
            List<String> unThrownExceptions = this.myUnThrownExceptions;
            if (unThrownExceptions != null) {
                if (exceptionType == null) {
                    this.myUnThrownExceptions = null;
                } else {
                    PsiClass exceptionClass = exceptionType.resolve();
                    JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
                    for (int i = unThrownExceptions.size() - 1; i >= 0; --i) {
                        String exceptionFqn = unThrownExceptions.get(i);
                        PsiClass classType = facade.findClass(exceptionFqn, GlobalSearchScope.allScope((Project)this.getRefManager().getProject()));
                        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)exceptionClass, (PsiClass)classType, (boolean)true) && !InheritanceUtil.isInheritorOrSelf((PsiClass)classType, (PsiClass)exceptionClass, (boolean)true)) continue;
                        unThrownExceptions.remove(i);
                    }
                    if (unThrownExceptions.isEmpty()) {
                        this.myUnThrownExceptions = null;
                    }
                }
            }
        }
    }

    @Nullable
    public synchronized PsiClass[] getUnThrownExceptions() {
        List<String> unThrownExceptions;
        if (this.getRefManager().isOfflineView()) {
            LOG.debug("Should not traverse graph offline");
        }
        if ((unThrownExceptions = this.myUnThrownExceptions) == null) {
            return null;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
        ArrayList<PsiClass> result = new ArrayList<PsiClass>(unThrownExceptions.size());
        for (String exception : unThrownExceptions) {
            PsiClass element = facade.findClass(exception, GlobalSearchScope.allScope((Project)this.myManager.getProject()));
            if (element == null) continue;
            result.add(element);
        }
        return result.toArray(PsiClass.EMPTY_ARRAY);
    }

    public void setLibraryOverride(boolean libraryOverride) {
        this.setFlag(libraryOverride, 131072L);
    }

    private void setAppMain(boolean appMain) {
        this.setFlag(appMain, 65536L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    public void setBodyEmpty(boolean bodyEmpty) {
        this.setFlag(bodyEmpty, 0x100000L);
    }

    private void setOnlyCallsSuper(boolean onlyCallsSuper) {
        this.setFlag(onlyCallsSuper, 0x200000L);
    }

    private void setConstructor(boolean constructor) {
        this.setFlag(constructor, 262144L);
    }

    public boolean isTestMethod() {
        return this.checkFlag(0x4000000L);
    }

    private void setTestMethod(boolean testMethod) {
        this.setFlag(testMethod, 0x4000000L);
    }

    public UDeclaration getUastElement() {
        return (UDeclaration)UastContextKt.toUElement((PsiElement)this.getPsiElement(), UMethod.class);
    }

    public boolean isCalledOnSubClass() {
        return this.checkFlag(0x8000000L);
    }

    void setCalledOnSubClass(boolean isCalledOnSubClass) {
        this.setFlag(isCalledOnSubClass, 0x8000000L);
    }

    public static boolean isEmptyExpression(@Nullable UExpression expression2) {
        if (expression2 == null) {
            return true;
        }
        if (expression2 instanceof UBlockExpression) {
            return ((UBlockExpression)expression2).getExpressions().isEmpty();
        }
        return false;
    }

    static RefElement findParentRef(@NotNull PsiElement psiElement, @NotNull UElement uElement, @NotNull RefManagerImpl refManager) {
        PsiElement containingDeclaration;
        UDeclaration containingUDecl = UDeclarationKt.getContainingDeclaration((UElement)uElement);
        PsiElement psiElement2 = containingDeclaration = containingUDecl == null ? null : containingUDecl.getSourcePsi();
        if (containingDeclaration instanceof LightElement) {
            containingDeclaration = containingDeclaration.getNavigationElement();
        }
        RefElement parentRef = containingDeclaration == null || containingDeclaration instanceof LightElement ? refManager.getReference((PsiElement)psiElement.getContainingFile(), true) : refManager.getReference(containingDeclaration, true);
        return parentRef;
    }
}

