/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reflectiveAccess;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiresDirectiveFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Java9ReflectionClassVisibilityInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiJavaModule javaModule;
        PsiFile file = holder.getFile();
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)file) && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)file)) != null) {
            return new JavaElementVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression2) {
                    super.visitMethodCallExpression(expression2);
                    if (JavaReflectionReferenceUtil.isCallToMethod(expression2, "java.lang.Class", "forName") || JavaReflectionReferenceUtil.isCallToMethod(expression2, "java.lang.ClassLoader", "loadClass")) {
                        Java9ReflectionClassVisibilityInspection.checkClassVisibility(expression2, holder, javaModule);
                    }
                }
            };
        }
        return PsiElementVisitor.EMPTY_VISITOR;
    }

    private static void checkClassVisibility(@NotNull PsiMethodCallExpression callExpression, @NotNull ProblemsHolder holder, @NotNull PsiJavaModule javaModule) {
        PsiJavaModule otherModule;
        Project project;
        JavaPsiFacade facade;
        PsiClass psiClass;
        PsiExpression classNameArgument;
        String className;
        PsiExpression[] arguments = callExpression.getArgumentList().getExpressions();
        if (arguments.length != 0 && (className = JavaReflectionReferenceUtil.computeConstantExpression(classNameArgument = arguments[0], String.class)) != null && (psiClass = (facade = JavaPsiFacade.getInstance((Project)(project = holder.getProject()))).findClass(className, callExpression.getResolveScope())) != null && (otherModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)psiClass)) != null && otherModule != javaModule) {
            if (!JavaModuleGraphUtil.reads(javaModule, otherModule)) {
                String message2 = InspectionsBundle.message((String)"module.not.in.requirements", (Object[])new Object[]{javaModule.getName(), otherModule.getName()});
                holder.registerProblem((PsiElement)classNameArgument, message2, new LocalQuickFix[]{new AddRequiresDirectiveFix(javaModule, otherModule.getName())});
                return;
            }
            if (otherModule.hasModifierProperty("open")) {
                return;
            }
            PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)psiClass, PsiJavaFile.class);
            if (file != null) {
                String packageName = file.getPackageName();
                if (Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getOpens(), packageName, javaModule)) {
                    return;
                }
                boolean publicApi = Java9ReflectionClassVisibilityInspection.isPublicApi(psiClass);
                if (publicApi && Java9ReflectionClassVisibilityInspection.isPackageAccessible(otherModule.getExports(), packageName, javaModule)) {
                    return;
                }
                String message3 = InspectionsBundle.message((String)(publicApi ? "module.package.not.exported" : "module.package.not.open"), (Object[])new Object[]{otherModule.getName(), packageName, javaModule.getName()});
                holder.registerProblem((PsiElement)classNameArgument, message3, new LocalQuickFix[0]);
            }
        }
    }

    private static boolean isPackageAccessible(@NotNull Iterable<PsiPackageAccessibilityStatement> statements, @NotNull String packageName, @NotNull PsiJavaModule javaModule) {
        for (PsiPackageAccessibilityStatement statement : statements) {
            List moduleNames;
            if (!packageName.equals(statement.getPackageName()) || !(moduleNames = statement.getModuleNames()).isEmpty() && !moduleNames.contains(javaModule.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPublicApi(@NotNull PsiClass psiClass) {
        if (psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("protected")) {
            PsiElement parent = psiClass.getParent();
            return parent instanceof PsiJavaFile || parent instanceof PsiClass && Java9ReflectionClassVisibilityInspection.isPublicApi((PsiClass)parent);
        }
        return false;
    }
}

