/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sameReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;

public class SameReturnValueInspection
extends GlobalJavaBatchInspectionTool {
    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isConstructor()) {
                return null;
            }
            if (refMethod.hasSuperMethods()) {
                return null;
            }
            String returnValue = refMethod.getReturnValueIfSame();
            if (returnValue != null) {
                PsiElement psiAnchor;
                UElement anchor;
                String message2 = refMethod.getDerivedMethods().isEmpty() ? InspectionsBundle.message((String)"inspection.same.return.value.problem.descriptor", (Object[])new Object[]{"<code>" + returnValue + "</code>"}) : (refMethod.hasBody() ? InspectionsBundle.message((String)"inspection.same.return.value.problem.descriptor1", (Object[])new Object[]{"<code>" + returnValue + "</code>"}) : InspectionsBundle.message((String)"inspection.same.return.value.problem.descriptor2", (Object[])new Object[]{"<code>" + returnValue + "</code>"}));
                UDeclaration decl = refMethod.getUastElement();
                if (decl != null && (anchor = decl.getUastAnchor()) != null && (psiAnchor = anchor.getSourcePsi()) != null) {
                    return new ProblemDescriptor[]{manager.createProblemDescriptor(psiAnchor, message2, false, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
                }
            }
        }
        return null;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(@NotNull RefMethod refMethod) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                                processor.ignoreElement((RefEntity)refMethod);
                                return false;
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.same.return.value.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return "SameReturnValue";
    }
}

