/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.OperationReductionMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NotNull;

class CountMigration
extends BaseStreamApiMigration {
    CountMigration(boolean shouldWarn) {
        super(shouldWarn, "count()");
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiExpression operand2;
        PsiExpression expression2 = tb.getSingleExpression(PsiExpression.class);
        if (expression2 == null) {
            expression2 = tb.getCountExpression();
        }
        if (!((operand2 = StreamApiMigrationInspection.extractIncrementedLValue(expression2)) instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement element = ((PsiReferenceExpression)operand2).resolve();
        if (!(element instanceof PsiLocalVariable)) {
            return null;
        }
        PsiLocalVariable var = (PsiLocalVariable)element;
        CommentTracker ct = new CommentTracker();
        return CountMigration.replaceWithOperation(tb.getStreamSourceStatement(), (PsiVariable)var, tb.generate(ct) + ".count()", (PsiType)PsiType.LONG, OperationReductionMigration.SUM_OPERATION, ct);
    }
}

