/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindExtremumMigration
extends BaseStreamApiMigration {
    private static final String MAX_OP = "max";
    private static final String MIN_OP = "min";
    private static final EquivalenceChecker ourEquivalence = EquivalenceChecker.getCanonicalPsiEquivalence();

    protected FindExtremumMigration(boolean shouldWarn, String replacement) {
        super(shouldWarn, replacement);
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        ExtremumTerminal terminal = FindExtremumMigration.extract(tb, null);
        if (terminal == null) {
            return null;
        }
        return terminal.replace();
    }

    @Contract(pure=true)
    @NotNull
    static String getOperation(boolean isMax) {
        return isMax ? MAX_OP : MIN_OP;
    }

    @Nullable
    private static String getComparingMethod(@NotNull PsiType type2) {
        if (type2.equals(PsiType.INT)) {
            return "comparingInt";
        }
        if (type2.equals(PsiType.DOUBLE)) {
            return "comparingDouble";
        }
        if (type2.equals(PsiType.LONG)) {
            return "comparingLong";
        }
        if (InheritanceUtil.isInheritor((PsiType)type2, (String)"java.lang.Comparable")) {
            return "comparing";
        }
        return null;
    }

    @Nullable
    private static Object getNonFilterableInitialValue(@NotNull PsiType type2, boolean isMax) {
        if (type2.equals(PsiType.INT)) {
            return isMax ? Integer.MIN_VALUE : Integer.MAX_VALUE;
        }
        if (type2.equals(PsiType.LONG)) {
            return isMax ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        if (type2.equals(PsiType.DOUBLE)) {
            return isMax ? Double.MIN_VALUE : Double.MAX_VALUE;
        }
        return null;
    }

    @Nullable
    static ExtremumTerminal extract(@NotNull TerminalBlock terminalBlock, @Nullable List<PsiVariable> nonFinalVariables) {
        TerminalBlock block;
        PsiStatement[] statements = terminalBlock.getStatements();
        StreamApiMigrationInspection.FilterOp filterOp = terminalBlock.getLastOperation(StreamApiMigrationInspection.FilterOp.class);
        if (filterOp != null && (block = terminalBlock.withoutLastOperation()) != null) {
            boolean negated = filterOp.isNegated();
            PsiExpression condition2 = filterOp.getExpression();
            ExtremumTerminal simpleRefCase = FindExtremumMigration.extractRefCase(condition2, statements, block, (nullCheckExpr, comparisonExpr, statements1, terminalBlock1, nonFinalVars, isNegated) -> SimpleRefExtremumTerminal.extract(nullCheckExpr, comparisonExpr, statements1, terminalBlock1, nonFinalVars), nonFinalVariables, negated);
            if (simpleRefCase != null) {
                return simpleRefCase;
            }
            PrimitiveExtremumTerminal primitiveCase = PrimitiveExtremumTerminal.extract(condition2, statements, block, nonFinalVariables, negated);
            if (primitiveCase != null) {
                return primitiveCase;
            }
            ExtremumTerminal complexRefCase = FindExtremumMigration.extractRefCase(condition2, statements, block, (x$0, x$1, x$2, x$3, x$4, x$5) -> ComplexExtremumTerminal.extract(x$0, x$1, x$2, x$3, x$4, x$5), nonFinalVariables, negated);
            if (complexRefCase != null) {
                return complexRefCase;
            }
        }
        return FindExtremumMigration.extractIfElseCase(statements, terminalBlock, nonFinalVariables);
    }

    @Nullable
    private static ExtremumTerminal extractIfElseCase(@NotNull PsiStatement[] statements, @NotNull TerminalBlock terminalBlock, @Nullable List<? extends PsiVariable> nonFinalVariables) {
        if (statements.length != 1) {
            return null;
        }
        PsiStatement statement = statements[0];
        PsiIfStatement ifStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)statement, PsiIfStatement.class);
        if (ifStatement == null) {
            return null;
        }
        PsiExpression thenCondition = ifStatement.getCondition();
        if (thenCondition == null) {
            return null;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        PsiStatement elseBranch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (thenBranch == null || elseBranch == null) {
            return null;
        }
        return FindExtremumMigration.extractIfElseCase(thenBranch, thenCondition, elseBranch, terminalBlock, nonFinalVariables);
    }

    @Nullable
    private static ExtremumTerminal extractIfElseCase(@NotNull PsiStatement thenBranch, @NotNull PsiExpression thenCondition, @NotNull PsiStatement elseBranch, @NotNull TerminalBlock terminalBlock, @Nullable List<? extends PsiVariable> nonFinalVariables) {
        PsiIfStatement elseIfStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)elseBranch, PsiIfStatement.class);
        if (elseIfStatement == null || elseIfStatement.getElseBranch() != null) {
            return null;
        }
        PsiExpression elseIfCondition = elseIfStatement.getCondition();
        PsiStatement elseIf = ControlFlowUtils.stripBraces(elseIfStatement.getThenBranch());
        if (elseIf == null || elseIfCondition == null) {
            return null;
        }
        ExtremumTerminal firstWay = FindExtremumMigration.extractIfElseCase(thenBranch, thenCondition, elseIf, elseIfCondition, terminalBlock, nonFinalVariables);
        if (firstWay != null) {
            return firstWay;
        }
        return FindExtremumMigration.extractIfElseCase(elseIf, elseIfCondition, thenBranch, thenCondition, terminalBlock, nonFinalVariables);
    }

    @Nullable
    private static ExtremumTerminal extractIfElseCase(@NotNull PsiStatement nullCheckBranch, @NotNull PsiExpression nullCheckExpr, @NotNull PsiStatement comparisonBranch, @NotNull PsiExpression comparisonExpr, @NotNull TerminalBlock terminalBlock, @Nullable List<? extends PsiVariable> nonFinalVariables) {
        if (!ourEquivalence.statementsAreEquivalent(nullCheckBranch, comparisonBranch)) {
            return null;
        }
        return SimpleRefExtremumTerminal.extract(nullCheckExpr, comparisonExpr, new PsiStatement[]{comparisonBranch}, terminalBlock, nonFinalVariables);
    }

    @Nullable
    private static ExtremumTerminal extractRefCase(@NotNull PsiExpression condition2, @NotNull PsiStatement[] statements, @NotNull TerminalBlock terminalBlock, @NotNull Extractor extractor, @Nullable List<PsiVariable> nonFinalVariables, boolean isNegated) {
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)condition2, PsiBinaryExpression.class);
        if (binaryExpression == null) {
            return null;
        }
        IElementType sign = binaryExpression.getOperationTokenType();
        PsiExpression lOperand = binaryExpression.getLOperand();
        PsiExpression rOperand = binaryExpression.getROperand();
        if (!sign.equals(JavaTokenType.OROR) || rOperand == null) {
            return null;
        }
        return extractor.extractOriented(lOperand, rOperand, statements, terminalBlock, nonFinalVariables, isNegated);
    }

    private static boolean containsAnyVariable(@NotNull PsiExpression expression2, @NotNull List<? extends PsiVariable> variables) {
        for (PsiVariable psiVariable : variables) {
            if (!VariableAccessUtils.variableIsUsed(psiVariable, (PsiElement)expression2)) continue;
            return true;
        }
        return false;
    }

    private static boolean mayChangeBeforeLoop(@NotNull PsiVariable variable, @NotNull TerminalBlock terminalBlock) {
        ControlFlowUtils.InitializerUsageStatus status = ControlFlowUtils.getInitializerUsageStatus(variable, terminalBlock.getStreamSourceStatement());
        return status.equals((Object)ControlFlowUtils.InitializerUsageStatus.UNKNOWN);
    }

    @Nullable
    static PsiVariable resolveVariableReference(@Nullable PsiExpression expression2) {
        PsiExpression nakedExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2);
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)ObjectUtils.tryCast((Object)nakedExpression, PsiReferenceExpression.class);
        if (referenceExpression == null) {
            return null;
        }
        PsiElement resolvedExpr = referenceExpression.resolve();
        PsiLocalVariable localVariable = (PsiLocalVariable)ObjectUtils.tryCast((Object)resolvedExpr, PsiLocalVariable.class);
        if (localVariable != null) {
            return localVariable;
        }
        return (PsiVariable)ObjectUtils.tryCast((Object)resolvedExpr, PsiParameter.class);
    }

    private static boolean equalShape(@NotNull PsiExpression first, @NotNull PsiExpression second, @NotNull String firstExprVarName, @NotNull PsiVariable secondExprVariable) {
        PsiExpression secondCopy = (PsiExpression)second.copy();
        for (PsiReference ref : ReferencesSearch.search((PsiElement)secondExprVariable, (SearchScope)new LocalSearchScope((PsiElement)secondCopy))) {
            if (!(ref instanceof PsiReferenceExpression)) continue;
            ExpressionUtils.bindReferenceTo((PsiReferenceExpression)ref, firstExprVarName);
        }
        return ourEquivalence.expressionsAreEquivalent(first, secondCopy);
    }

    private static boolean hasKnownComparableType(@NotNull Comparison comparison, @Nullable PsiType type2) {
        return comparison.isExternalComparison() || type2 != null && FindExtremumMigration.getComparingMethod(type2) != null;
    }

    private static class Comparison {
        @NotNull
        private final PsiExpression myExtremumExpr;
        @NotNull
        private final PsiExpression myLoopVarExpr;
        private final boolean myIsMax;
        @Nullable
        private final PsiVariable myComparator;
        private final boolean myExternalComparison;

        private Comparison(@NotNull PsiExpression extremumExpr, @NotNull PsiExpression loopVarExpr, boolean max, @Nullable PsiVariable comparator, boolean externalComparison) {
            this.myExtremumExpr = extremumExpr;
            this.myLoopVarExpr = loopVarExpr;
            this.myIsMax = max;
            this.myComparator = comparator;
            this.myExternalComparison = externalComparison;
        }

        @NotNull
        public PsiExpression getLoopVarExpr() {
            return this.myLoopVarExpr;
        }

        @NotNull
        public PsiExpression getExtremumExpr() {
            return this.myExtremumExpr;
        }

        public boolean isMax() {
            return this.myIsMax;
        }

        @Nullable
        public PsiVariable getComparator() {
            return this.myComparator;
        }

        public boolean isExternalComparison() {
            return this.myExternalComparison;
        }

        @Nullable
        static Comparison extract(@NotNull PsiExpression expression2, @NotNull PsiVariable loopVariable, boolean isNegated) {
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2), PsiBinaryExpression.class);
            if (binaryExpression == null) {
                return null;
            }
            IElementType sign = binaryExpression.getOperationSign().getTokenType();
            PsiExpression rOperand = binaryExpression.getROperand();
            if (rOperand == null) {
                return null;
            }
            PsiExpression lOperand = binaryExpression.getLOperand();
            if (sign.equals(JavaTokenType.LT) || sign.equals(JavaTokenType.LE)) {
                Comparison extract = Comparison.extractComparatorLikeComparison(lOperand, rOperand, loopVariable, isNegated);
                if (extract != null) {
                    return extract;
                }
                return Comparison.extract(lOperand, rOperand, loopVariable, isNegated, null, false);
            }
            if (sign.equals(JavaTokenType.GT) || sign.equals(JavaTokenType.GE)) {
                Comparison extract = Comparison.extractComparatorLikeComparison(lOperand, rOperand, loopVariable, !isNegated);
                if (extract != null) {
                    return extract;
                }
                return Comparison.extract(lOperand, rOperand, loopVariable, !isNegated, null, false);
            }
            return null;
        }

        @Nullable
        private static Comparison extractComparatorLikeComparison(@NotNull PsiExpression expression2, @NotNull PsiVariable loopVariable, boolean isGreater) {
            PsiMethodCallExpression methodExpression = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)expression2, PsiMethodCallExpression.class);
            if (methodExpression == null) {
                return null;
            }
            PsiExpression qualifierExpression2 = methodExpression.getMethodExpression().getQualifierExpression();
            if (qualifierExpression2 == null) {
                return null;
            }
            PsiMethod method = methodExpression.resolveMethod();
            if (method == null) {
                return null;
            }
            String methodName = method.getName();
            PsiType qualifierType = qualifierExpression2.getType();
            PsiExpressionList argumentList = methodExpression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length == 1) {
                PsiExpression argument = arguments[0];
                if (!methodName.equals("compareTo") || !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.lang.Comparable")) {
                    return null;
                }
                return Comparison.extract(argument, qualifierExpression2, loopVariable, isGreater, null, false);
            }
            if (arguments.length == 2) {
                PsiExpression firstArgument = arguments[0];
                PsiExpression secondArgument = arguments[1];
                if (!methodName.equals("compare") || !InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Comparator")) {
                    return null;
                }
                PsiVariable comparator = FindExtremumMigration.resolveVariableReference(qualifierExpression2);
                return Comparison.extract(secondArgument, firstArgument, loopVariable, isGreater, comparator, true);
            }
            return null;
        }

        @Nullable
        private static Comparison extractComparatorLikeComparison(@NotNull PsiExpression lOperand, @NotNull PsiExpression rOperand, @NotNull PsiVariable loopVariable, boolean isGreater) {
            if (ExpressionUtils.isZero(lOperand)) {
                return Comparison.extractComparatorLikeComparison(rOperand, loopVariable, isGreater);
            }
            if (ExpressionUtils.isZero(rOperand)) {
                return Comparison.extractComparatorLikeComparison(lOperand, loopVariable, !isGreater);
            }
            return null;
        }

        @Nullable
        private static Comparison extract(@NotNull PsiExpression lOperand, @NotNull PsiExpression rOperand, @NotNull PsiVariable loopVariable, boolean isGreater, @Nullable PsiVariable comparator, boolean externalComparison) {
            PsiExpression extremumExpr;
            PsiExpression loopVarExpr;
            boolean max;
            if (ReferencesSearch.search((PsiElement)loopVariable, (SearchScope)new LocalSearchScope((PsiElement)lOperand)).findFirst() != null) {
                max = isGreater;
                loopVarExpr = lOperand;
                extremumExpr = rOperand;
            } else if (ReferencesSearch.search((PsiElement)loopVariable, (SearchScope)new LocalSearchScope((PsiElement)rOperand)).findFirst() != null) {
                max = !isGreater;
                loopVarExpr = rOperand;
                extremumExpr = lOperand;
            } else {
                return null;
            }
            return new Comparison(extremumExpr, loopVarExpr, max, comparator, externalComparison);
        }
    }

    private static class SimpleRefExtremumTerminal
    implements ExtremumTerminal {
        private final boolean myMax;
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @NotNull
        private final PsiExpression myLoopVarExpression;
        @NotNull
        private final PsiVariable myExtremum;
        @Nullable
        private final PsiVariable myComparator;

        private SimpleRefExtremumTerminal(boolean max, @NotNull TerminalBlock block, @NotNull PsiExpression loopVarExpression, @NotNull PsiVariable extremum, @Nullable PsiVariable comparator) {
            this.myMax = max;
            this.myTerminalBlock = block;
            this.myLoopVarExpression = loopVarExpression;
            this.myExtremum = extremum;
            this.myComparator = comparator;
        }

        @Override
        @Nullable
        public PsiElement replace() {
            String comparator;
            PsiType loopVarExpressionType = this.myLoopVarExpression.getType();
            if (loopVarExpressionType == null) {
                return null;
            }
            CommentTracker ct = new CommentTracker();
            if (this.myComparator == null) {
                if (ExpressionUtils.isReferenceTo(this.myLoopVarExpression, this.myTerminalBlock.getVariable())) {
                    comparator = "java.util.Comparator.naturalOrder()";
                } else {
                    String method = FindExtremumMigration.getComparingMethod(loopVarExpressionType);
                    if (method == null) {
                        return null;
                    }
                    String lambdaText = ct.lambdaText(this.myTerminalBlock.getVariable(), this.myLoopVarExpression);
                    comparator = "java.util.Comparator." + method + "(" + lambdaText + ")";
                }
            } else {
                String comparatorName = this.myComparator.getName();
                if (comparatorName == null) {
                    return null;
                }
                comparator = comparatorName;
            }
            String stream = this.myTerminalBlock.generate(ct) + "." + FindExtremumMigration.getOperation(this.myMax) + "(" + comparator + ").orElse(null)";
            return BaseStreamApiMigration.replaceWithFindExtremum(ct, this.myTerminalBlock.getStreamSourceStatement(), this.myExtremum, stream, null);
        }

        @Override
        public boolean isMax() {
            return this.myMax;
        }

        @Nullable
        private static SimpleRefExtremumTerminal extract(@NotNull PsiExpression nullCheckExpr, @NotNull PsiExpression comparisonExpr, @NotNull PsiStatement[] statements, @NotNull TerminalBlock terminalBlock, @Nullable List<? extends PsiVariable> nonFinalVars) {
            PsiType loopVarExprType;
            PsiBinaryExpression nullCheckBinary = (PsiBinaryExpression)ObjectUtils.tryCast((Object)nullCheckExpr, PsiBinaryExpression.class);
            if (nullCheckBinary == null) {
                return null;
            }
            PsiVariable nullCheckingVar = ExpressionUtils.getVariableFromNullComparison((PsiExpression)nullCheckBinary, true);
            if (nullCheckingVar == null) {
                return null;
            }
            Comparison comparison = Comparison.extract(comparisonExpr, terminalBlock.getVariable(), false);
            if (comparison == null) {
                return null;
            }
            if (statements.length != 1) {
                return null;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
            if (assignment == null) {
                return null;
            }
            PsiVariable extremum = FindExtremumMigration.resolveVariableReference(assignment.getLExpression());
            PsiVariable loopVariable = FindExtremumMigration.resolveVariableReference(assignment.getRExpression());
            if (extremum == null || loopVariable == null) {
                return null;
            }
            if (nullCheckingVar != extremum) {
                return null;
            }
            if (!loopVariable.equals(terminalBlock.getVariable())) {
                return null;
            }
            PsiExpression extremumExpr = comparison.getExtremumExpr();
            PsiExpression loopVarExpr = comparison.getLoopVarExpr();
            String name = extremum.getName();
            if (name == null) {
                return null;
            }
            if (!FindExtremumMigration.equalShape(extremumExpr, loopVarExpr, name, terminalBlock.getVariable())) {
                return null;
            }
            if (FindExtremumMigration.mayChangeBeforeLoop(extremum, terminalBlock)) {
                return null;
            }
            if (nonFinalVars != null) {
                if (nonFinalVars.size() != 1) {
                    return null;
                }
                if (!nonFinalVars.get(0).equals(extremum)) {
                    return null;
                }
                if (FindExtremumMigration.containsAnyVariable(loopVarExpr, nonFinalVars)) {
                    return null;
                }
            }
            if (!FindExtremumMigration.hasKnownComparableType(comparison, loopVarExprType = loopVarExpr.getType())) {
                return null;
            }
            boolean max = comparison.isMax();
            PsiExpression initializer = extremum.getInitializer();
            if (!ExpressionUtils.isNullLiteral(initializer)) {
                return null;
            }
            return new SimpleRefExtremumTerminal(max, terminalBlock, loopVarExpr, extremum, comparison.getComparator());
        }
    }

    private static class PrimitiveExtremumTerminal
    implements ExtremumTerminal {
        private final boolean myMax;
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @NotNull
        private final PsiExpression myLoopVarExpression;
        @NotNull
        private final PsiVariable myExtremum;
        @NotNull
        private final PsiExpression myExtremumInitializer;

        private PrimitiveExtremumTerminal(boolean max, @NotNull TerminalBlock block, @NotNull PsiExpression loopVarExpression, @NotNull PsiVariable extremum, @NotNull PsiExpression extremumInitializer) {
            this.myMax = max;
            this.myTerminalBlock = block;
            this.myLoopVarExpression = loopVarExpression;
            this.myExtremum = extremum;
            this.myExtremumInitializer = extremumInitializer;
        }

        @Override
        @Nullable
        public PsiElement replace() {
            TerminalBlock filteredTerminalBlock;
            TerminalBlock terminalBlock;
            PsiVariable variable = this.myTerminalBlock.getVariable();
            String name = variable.getName();
            if (name == null) {
                return null;
            }
            PsiType type2 = this.myExtremumInitializer.getType();
            if (type2 == null) {
                return null;
            }
            Object initializerValue = ExpressionUtils.computeConstantExpression(this.myExtremumInitializer);
            if (initializerValue == null) {
                return null;
            }
            TerminalBlock blockWithMap = this.myTerminalBlock.add(new StreamApiMigrationInspection.MapOp(this.myLoopVarExpression, variable, this.myLoopVarExpression.getType()));
            PsiType variableType = this.myLoopVarExpression.getType();
            if (!Objects.equals(variableType, this.myExtremum.getType())) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)variable.getProject());
                PsiExpression variableExpr = factory.createExpressionFromText(name, (PsiElement)variable);
                terminalBlock = blockWithMap.add(new StreamApiMigrationInspection.MapOp(variableExpr, variable, type2));
            } else {
                terminalBlock = blockWithMap;
            }
            CommentTracker ct = new CommentTracker();
            String inFilterOperation = this.myMax ? ">=" : "<=";
            PsiStatement loop = terminalBlock.getStreamSourceStatement();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)loop.getProject());
            String extremumInitializer = ct.text((PsiElement)this.myExtremumInitializer);
            Object nonFilterableInitialValue = FindExtremumMigration.getNonFilterableInitialValue(type2, this.myMax);
            if (nonFilterableInitialValue != null && !nonFilterableInitialValue.equals(initializerValue)) {
                PsiExpression condition2 = elementFactory.createExpressionFromText(name + inFilterOperation + extremumInitializer, (PsiElement)loop);
                filteredTerminalBlock = terminalBlock.add(new StreamApiMigrationInspection.FilterOp(condition2, this.myTerminalBlock.getVariable(), false));
            } else {
                filteredTerminalBlock = terminalBlock;
            }
            String stream = filteredTerminalBlock.generate(ct) + "." + FindExtremumMigration.getOperation(this.myMax) + "().orElse(" + extremumInitializer + ")";
            return BaseStreamApiMigration.replaceWithFindExtremum(ct, loop, this.myExtremum, stream, null);
        }

        @Override
        public boolean isMax() {
            return this.myMax;
        }

        @Nullable
        private static PrimitiveExtremumTerminal extract(@NotNull PsiExpression condition2, @NotNull PsiStatement[] statements, @NotNull TerminalBlock terminalBlock, @Nullable List<? extends PsiVariable> nonFinalVariables, boolean isNegated) {
            Comparison comparison = Comparison.extract(condition2, terminalBlock.getVariable(), isNegated);
            if (comparison == null || comparison.isExternalComparison()) {
                return null;
            }
            if (statements.length != 1) {
                return null;
            }
            PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)statements[0]);
            if (assignment == null) {
                return null;
            }
            PsiVariable extremum = FindExtremumMigration.resolveVariableReference(assignment.getLExpression());
            if (extremum == null) {
                return null;
            }
            PsiExpression assignmentLoopVarExpr = assignment.getRExpression();
            PsiExpression comparisonLoopVarExpr = comparison.getLoopVarExpr();
            if (!ourEquivalence.expressionsAreEquivalent(assignmentLoopVarExpr, comparisonLoopVarExpr)) {
                return null;
            }
            PsiVariable comparisonExtremum = FindExtremumMigration.resolveVariableReference(comparison.getExtremumExpr());
            if (comparisonExtremum == null) {
                return null;
            }
            if (!extremum.equals(comparisonExtremum)) {
                return null;
            }
            if (FindExtremumMigration.mayChangeBeforeLoop(extremum, terminalBlock)) {
                return null;
            }
            if (nonFinalVariables != null && FindExtremumMigration.containsAnyVariable(comparisonLoopVarExpr, nonFinalVariables)) {
                return null;
            }
            PsiType loopVarExprType = comparisonLoopVarExpr.getType();
            if (!FindExtremumMigration.hasKnownComparableType(comparison, loopVarExprType)) {
                return null;
            }
            PsiExpression extremumInitializer = extremum.getInitializer();
            if (!ExpressionUtils.isEvaluatedAtCompileTime(extremumInitializer)) {
                return null;
            }
            return new PrimitiveExtremumTerminal(comparison.isMax(), terminalBlock, comparisonLoopVarExpr, extremum, extremumInitializer);
        }
    }

    private static class ComplexExtremumTerminal
    implements ExtremumTerminal {
        private final boolean myMax;
        @NotNull
        private final PsiVariable myExtremum;
        @NotNull
        private final PsiVariable myExtremumKey;
        @NotNull
        private final PsiExpression myExtremumKeyInitializer;
        @NotNull
        private final PsiExpression myExtremumKeyExpr;
        @NotNull
        private final TerminalBlock myTerminalBlock;
        @Nullable
        private final PsiVariable myComparator;

        private ComplexExtremumTerminal(boolean max, @NotNull PsiVariable extremum, @NotNull PsiVariable extremumKey, @NotNull PsiExpression extremumKeyInitializer, @NotNull PsiExpression extremumKeyExpr, @NotNull TerminalBlock block, @Nullable PsiVariable comparator) {
            this.myMax = max;
            this.myExtremum = extremum;
            this.myExtremumKey = extremumKey;
            this.myExtremumKeyInitializer = extremumKeyInitializer;
            this.myExtremumKeyExpr = extremumKeyExpr;
            this.myTerminalBlock = block;
            this.myComparator = comparator;
        }

        @Override
        @Nullable
        public PsiElement replace() {
            String comparator;
            PsiType loopVarExpressionType = this.myExtremumKeyExpr.getType();
            if (loopVarExpressionType == null) {
                return null;
            }
            String method = FindExtremumMigration.getComparingMethod(loopVarExpressionType);
            if (method == null) {
                return null;
            }
            String inFilterOperation = this.myMax ? ">=" : "<=";
            PsiStatement loop = this.myTerminalBlock.getStreamSourceStatement();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)loop.getProject());
            CommentTracker ct = new CommentTracker();
            String extremumInitializer = ct.text((PsiElement)this.myExtremumKeyInitializer);
            PsiExpression condition2 = elementFactory.createExpressionFromText(ct.text((PsiElement)this.myExtremumKeyExpr) + inFilterOperation + extremumInitializer, (PsiElement)loop);
            TerminalBlock blockWithFilter = this.myTerminalBlock.add(new StreamApiMigrationInspection.FilterOp(condition2, this.myTerminalBlock.getVariable(), false));
            String lambdaText = ct.lambdaText(this.myTerminalBlock.getVariable(), this.myExtremumKeyExpr);
            if (this.myComparator == null) {
                comparator = "java.util.Comparator." + method + "(" + lambdaText + ")";
            } else {
                String comparatorName = this.myComparator.getName();
                if (comparatorName == null) {
                    return null;
                }
                comparator = comparatorName;
            }
            String stream = blockWithFilter.generate(ct) + "." + FindExtremumMigration.getOperation(this.myMax) + "(" + comparator + ").orElse(null)";
            return BaseStreamApiMigration.replaceWithFindExtremum(ct, this.myTerminalBlock.getStreamSourceStatement(), this.myExtremum, stream, this.myExtremumKey);
        }

        @Override
        public boolean isMax() {
            return this.myMax;
        }

        @Nullable
        private static ComplexExtremumTerminal extract(@NotNull PsiExpression nullCheckExpr, @NotNull PsiExpression comparisonExpr, @NotNull PsiStatement[] statements, @NotNull TerminalBlock terminalBlock, @Nullable List<? extends PsiVariable> nonFinalVariables, boolean isNegated) {
            Comparison comparison = Comparison.extract(comparisonExpr, terminalBlock.getVariable(), isNegated);
            if (comparison == null) {
                return null;
            }
            PsiBinaryExpression nullCheckBinary = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)nullCheckExpr), PsiBinaryExpression.class);
            if (nullCheckBinary == null) {
                return null;
            }
            PsiVariable extremumNullChecked = ExpressionUtils.getVariableFromNullComparison((PsiExpression)nullCheckBinary, true);
            if (extremumNullChecked == null) {
                return null;
            }
            ComplexAssignment assignment = ComplexAssignment.extract(statements, extremumNullChecked);
            if (assignment == null) {
                return null;
            }
            if (!assignment.getLoopVar().equals(terminalBlock.getVariable())) {
                return null;
            }
            PsiVariable extremumKey = FindExtremumMigration.resolveVariableReference(comparison.getExtremumExpr());
            if (extremumKey == null) {
                return null;
            }
            if (!extremumKey.equals(assignment.getExtremumKey())) {
                return null;
            }
            PsiVariable extremum = assignment.getExtremum();
            if (FindExtremumMigration.mayChangeBeforeLoop(extremumKey, terminalBlock) || FindExtremumMigration.mayChangeBeforeLoop(extremum, terminalBlock)) {
                return null;
            }
            PsiExpression loopVarExpr = comparison.getLoopVarExpr();
            if (!ourEquivalence.expressionsAreEquivalent(assignment.getLoopVarExpression(), loopVarExpr)) {
                return null;
            }
            if (nonFinalVariables != null && FindExtremumMigration.containsAnyVariable(assignment.getLoopVarExpression(), nonFinalVariables)) {
                return null;
            }
            PsiType loopVarExprType = loopVarExpr.getType();
            if (!FindExtremumMigration.hasKnownComparableType(comparison, loopVarExprType)) {
                return null;
            }
            PsiExpression extremumInitializer = extremum.getInitializer();
            PsiExpression extremumKeyInitializer = extremumKey.getInitializer();
            if (extremumInitializer == null || extremumKeyInitializer == null) {
                return null;
            }
            if (!ExpressionUtils.isNullLiteral(extremumInitializer)) {
                return null;
            }
            if (!ExpressionUtils.isEvaluatedAtCompileTime(extremumKeyInitializer)) {
                return null;
            }
            return new ComplexExtremumTerminal(comparison.isMax(), extremum, extremumKey, extremumKeyInitializer, loopVarExpr, terminalBlock, comparison.getComparator());
        }

        private static class ComplexAssignment {
            @NotNull
            private final PsiVariable myExtremum;
            @NotNull
            private final PsiVariable myExtremumKey;
            @NotNull
            private final PsiVariable myLoopVar;
            @NotNull
            private final PsiExpression myLoopVarExpression;

            private ComplexAssignment(@NotNull PsiVariable extremum, @NotNull PsiVariable extremumKey, @NotNull PsiVariable loopVar, @NotNull PsiExpression loopVarExpression) {
                this.myExtremum = extremum;
                this.myExtremumKey = extremumKey;
                this.myLoopVar = loopVar;
                this.myLoopVarExpression = loopVarExpression;
            }

            @NotNull
            public PsiVariable getExtremum() {
                return this.myExtremum;
            }

            @NotNull
            public PsiVariable getExtremumKey() {
                return this.myExtremumKey;
            }

            @NotNull
            public PsiVariable getLoopVar() {
                return this.myLoopVar;
            }

            @NotNull
            public PsiExpression getLoopVarExpression() {
                return this.myLoopVarExpression;
            }

            @Nullable
            private static ComplexAssignment extract(@NotNull PsiStatement[] statements, @NotNull PsiVariable nullCheckedExtremum) {
                if (statements.length != 2) {
                    return null;
                }
                PsiStatement first = statements[0];
                PsiStatement second = statements[1];
                ComplexAssignment assignment = ComplexAssignment.extract(first, second, nullCheckedExtremum);
                if (assignment != null) {
                    return assignment;
                }
                return ComplexAssignment.extract(second, first, nullCheckedExtremum);
            }

            @Nullable
            private static ComplexAssignment extract(@NotNull PsiStatement first, @NotNull PsiStatement second, @NotNull PsiVariable nullCheckedExtremum) {
                PsiAssignmentExpression secondAssignment = ExpressionUtils.getAssignment((PsiElement)second);
                if (secondAssignment == null) {
                    return null;
                }
                PsiVariable loopVar = FindExtremumMigration.resolveVariableReference(ExpressionUtils.getAssignmentTo((PsiElement)first, nullCheckedExtremum));
                PsiVariable extremumKey = FindExtremumMigration.resolveVariableReference(secondAssignment.getLExpression());
                PsiExpression loopVarExpr = secondAssignment.getRExpression();
                if (extremumKey == null || loopVar == null || loopVarExpr == null) {
                    return null;
                }
                return new ComplexAssignment(nullCheckedExtremum, extremumKey, loopVar, loopVarExpr);
            }
        }
    }

    @FunctionalInterface
    static interface Extractor {
        @Nullable
        public ExtremumTerminal extractOriented(@NotNull PsiExpression var1, @NotNull PsiExpression var2, @NotNull PsiStatement[] var3, @NotNull TerminalBlock var4, @Nullable List<PsiVariable> var5, boolean var6);
    }

    static interface ExtremumTerminal {
        @Nullable
        public PsiElement replace();

        public boolean isMax();
    }
}

