/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.CollectMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ForEachMigration
extends BaseStreamApiMigration {
    private static final Logger LOG = Logger.getInstance(ForEachMigration.class);

    protected ForEachMigration(boolean shouldWarn, String forEachMethodName) {
        super(shouldWarn, forEachMethodName);
    }

    @Nullable
    static PsiExpression tryExtractMapExpression(TerminalBlock tb) {
        PsiMethodCallExpression call = tb.getSingleMethodCall();
        if (call == null) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        if (ExpressionUtils.isReferenceTo(arg, tb.getVariable())) {
            return null;
        }
        if (PsiType.VOID.equals((Object)arg.getType())) {
            return null;
        }
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (tb.dependsOn(qualifier) || VariableAccessUtils.variableIsUsed(tb.getVariable(), (PsiElement)qualifier) || StreamApiMigrationInspection.isExpressionDependsOnUpdatedCollections(arg, qualifier) || !LambdaCanBeMethodReferenceInspection.checkQualifier((PsiElement)qualifier)) {
            return null;
        }
        return arg;
    }

    @Override
    PsiElement migrate(@NotNull Project project, @NotNull PsiElement body2, @NotNull TerminalBlock tb) {
        PsiTypeElement typeElement;
        PsiStatement loopStatement = tb.getStreamSourceStatement();
        CommentTracker ct = new CommentTracker();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiExpression mapExpression = ForEachMigration.tryExtractMapExpression(tb);
        if (mapExpression != null) {
            PsiMethodCallExpression call = tb.getSingleMethodCall();
            LOG.assertTrue(call != null);
            PsiType addedType = CollectMigration.getAddedElementType(call);
            if (addedType == null) {
                addedType = call.getType();
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, addedType, true);
            if (suggestedNameInfo.names.length == 0) {
                suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, "item", null, null, true);
            }
            String varName = codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)call, (boolean)false).names[0];
            String streamText = tb.add(new StreamApiMigrationInspection.MapOp(mapExpression, tb.getVariable(), addedType)).generate(ct);
            String forEachBody = varName + "->" + ct.text((PsiElement)call.getMethodExpression()) + "(" + varName + ")";
            String callText = streamText + "." + this.getReplacement() + "(" + forEachBody + ");";
            return ct.replaceAndRestoreComments((PsiElement)loopStatement, callText);
        }
        tb.replaceContinueWithReturn(factory);
        String stream = tb.generate(ct, true) + "." + this.getReplacement() + "(";
        PsiElement block = tb.convertToElement(ct, factory);
        String functionalExpressionText = tb.getVariable().getName() + " -> " + ForEachMigration.wrapInBlock(ct, block);
        PsiExpressionStatement callStatement = (PsiExpressionStatement)ct.replaceAndRestoreComments((PsiElement)loopStatement, stream + functionalExpressionText + ");");
        PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
        LOG.assertTrue(argumentList != null, (Object)callStatement.getText());
        PsiExpression[] expressions2 = argumentList.getExpressions();
        LOG.assertTrue(expressions2.length == 1);
        if (expressions2[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions2[0]).getFunctionalInterfaceType() == null && (typeElement = tb.getVariable().getTypeElement()) != null) {
            String typedVariable = typeElement.getText() + " " + tb.getVariable().getName();
            ct = new CommentTracker();
            callStatement = (PsiExpressionStatement)ct.replaceAndRestoreComments((PsiElement)callStatement, stream + "(" + typedVariable + ") -> " + ForEachMigration.wrapInBlock(ct, block) + ");");
        }
        return callStatement;
    }

    @NotNull
    private static String wrapInBlock(@NotNull CommentTracker ct, @NotNull PsiElement block) {
        if (block instanceof PsiExpressionStatement) {
            return ct.text((PsiElement)((PsiExpressionStatement)block).getExpression());
        }
        if (block instanceof PsiCodeBlock) {
            return ct.text(block);
        }
        return "{" + ct.text(block) + "}";
    }
}

