/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamMigration;

import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.codeInspection.SimplifyStreamApiCallChainsInspection;
import com.intellij.codeInspection.streamMigration.BaseStreamApiMigration;
import com.intellij.codeInspection.streamMigration.StreamApiMigrationInspection;
import com.intellij.codeInspection.streamMigration.TerminalBlock;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class MigrateToStreamFix
implements LocalQuickFix {
    private final BaseStreamApiMigration myMigration;

    protected MigrateToStreamFix(BaseStreamApiMigration migration) {
        this.myMigration = migration;
    }

    @Nls
    @NotNull
    public String getName() {
        return "Replace with " + this.myMigration.getReplacement();
    }

    @NotNull
    public String getFamilyName() {
        return "Replace with Stream API equivalent";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiLoopStatement loopStatement = (PsiLoopStatement)ObjectUtils.tryCast((Object)descriptor.getPsiElement(), PsiLoopStatement.class);
        if (loopStatement == null) {
            return;
        }
        StreamApiMigrationInspection.StreamSource source = StreamApiMigrationInspection.StreamSource.tryCreate(loopStatement);
        PsiStatement body2 = loopStatement.getBody();
        if (body2 == null || source == null) {
            return;
        }
        TerminalBlock tb = TerminalBlock.from(source, body2);
        PsiElement result = this.myMigration.migrate(project, (PsiElement)body2, tb);
        if (result == null) {
            return;
        }
        tb.operations().forEach(StreamApiMigrationInspection.Operation::cleanUp);
        MigrateToStreamFix.simplify(project, result);
    }

    static void simplify(@NotNull Project project, PsiElement result) {
        if (result == null) {
            return;
        }
        LambdaCanBeMethodReferenceInspection.replaceAllLambdasWithMethodReferences(result);
        RemoveRedundantTypeArgumentsUtil.removeRedundantTypeArguments(result);
        result = SimplifyStreamApiCallChainsInspection.simplifyStreamExpressions(result, true);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(result);
    }
}

