/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.streamToLoop;

import com.intellij.codeInspection.streamToLoop.StreamToLoopInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

class StreamVariable {
    private static final Logger LOG = Logger.getInstance(StreamVariable.class);
    static StreamVariable STUB = new StreamVariable((PsiType)PsiType.VOID){

        @Override
        public void addBestNameCandidate(String candidate) {
        }

        @Override
        void register(StreamToLoopInspection.StreamToLoopReplacementContext context) {
        }

        @Override
        public String toString() {
            return "###STUB###";
        }
    };
    String myName;
    @NotNull
    PsiType myType;
    boolean myFinal;
    private Collection<String> myBestCandidates = new LinkedHashSet<String>();
    private Collection<String> myOtherCandidates = new LinkedHashSet<String>();

    StreamVariable(@NotNull PsiType type2) {
        this.myType = type2;
    }

    StreamVariable(@NotNull PsiType type2, @NotNull String name) {
        this.myType = type2;
        this.myName = name;
    }

    public void markFinal() {
        this.myFinal = true;
    }

    void addBestNameCandidate(String candidate) {
        this.myBestCandidates.add(candidate);
    }

    void addOtherNameCandidate(String candidate) {
        this.myOtherCandidates.add(candidate);
    }

    void register(StreamToLoopInspection.StreamToLoopReplacementContext context) {
        LOG.assertTrue(this.myName == null);
        Object[] fromType = JavaCodeStyleManager.getInstance((Project)context.getProject()).suggestVariableName((VariableKind)VariableKind.LOCAL_VARIABLE, null, null, (PsiType)this.myType, (boolean)true).names;
        List variants = ((StreamEx)StreamEx.of(this.myBestCandidates).append(this.myOtherCandidates).append(fromType).distinct()).toList();
        if (variants.isEmpty()) {
            variants.add("val");
        }
        this.myName = context.registerVarName(variants);
        this.myOtherCandidates = null;
        this.myBestCandidates = null;
    }

    String getName() {
        LOG.assertTrue(this.myName != null);
        return this.myName;
    }

    @NotNull
    PsiType getType() {
        return this.myType;
    }

    String getDeclaration() {
        return this.getType().getCanonicalText() + " " + this.getName();
    }

    String getDeclaration(String initializer) {
        return this.getType().getCanonicalText() + " " + this.getName() + "=" + initializer + ";\n";
    }

    public boolean isFinal() {
        return this.myFinal;
    }

    public String toString() {
        if (this.myName == null) {
            return "###(unregistered: " + this.myBestCandidates + "|" + this.myOtherCandidates + ")###";
        }
        return this.myName;
    }
}

