/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryModuleDependencyInspection
extends GlobalInspectionTool {
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new UnnecessaryModuleDependencyAnnotator(refManager);
    }

    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            boolean onlyGeneratedSources = true;
            block0: for (ContentEntry entry : moduleRootManager.getContentEntries()) {
                for (SourceFolder sourceFolder : entry.getSourceFolders()) {
                    if (JavaProjectRootsUtil.isForGeneratedSources(sourceFolder)) continue;
                    onlyGeneratedSources = false;
                    continue block0;
                }
            }
            if (onlyGeneratedSources) {
                return null;
            }
            OrderEntry[] declaredDependencies = moduleRootManager.getOrderEntries();
            ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
            Set modules = (Set)refModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES);
            ArrayList<Module> candidates = new ArrayList<Module>();
            for (SourceFolder sourceFolder : declaredDependencies) {
                Module dependency;
                if (!(sourceFolder instanceof ModuleOrderEntry) || ((ModuleOrderEntry)sourceFolder).getScope() == DependencyScope.RUNTIME || ((ModuleOrderEntry)sourceFolder).isExported() || (dependency = ((ModuleOrderEntry)sourceFolder).getModule()) == null || modules != null && modules.remove(dependency)) continue;
                candidates.add(dependency);
            }
            for (Module dependency : candidates) {
                if (modules != null) {
                    HashSet outs = new HashSet();
                    OrderEnumerator.orderEntries((Module)dependency).withoutSdk().exportedOnly().recursively().forEachModule(outs::add);
                    if (ContainerUtil.intersects((Collection)modules, outs)) continue;
                }
                descriptors.add(UnnecessaryModuleDependencyInspection.createDescriptor(scope, manager, module, dependency));
            }
            return descriptors.isEmpty() ? null : descriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new RemoveModuleDependencyFix(hint);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"unnecessary.module.dependency.display.name", (Object[])new Object[0]);
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "UnnecessaryModuleDependencyInspection";
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix2) {
        return fix2 instanceof RemoveModuleDependencyFix ? ((RemoveModuleDependencyFix)fix2).myDependency : null;
    }

    private static CommonProblemDescriptor createDescriptor(AnalysisScope scope, InspectionManager manager, Module module, Module dependency) {
        String dependencyName = dependency.getName();
        String moduleName = module.getName();
        if (scope.containsModule(dependency)) {
            String allContainsMessage = InspectionsBundle.message((String)"unnecessary.module.dependency.problem.descriptor", (Object[])new Object[]{moduleName, dependencyName});
            return manager.createProblemDescriptor(allContainsMessage, module, new QuickFix[]{new RemoveModuleDependencyFix(dependencyName)});
        }
        String message2 = InspectionsBundle.message((String)"suspected.module.dependency.problem.descriptor", (Object[])new Object[]{moduleName, dependencyName, scope.getDisplayName()});
        return manager.createProblemDescriptor(message2, module, new QuickFix[0]);
    }

    public static class RemoveModuleDependencyFix
    implements QuickFix<ModuleProblemDescriptor> {
        private final String myDependency;

        public RemoveModuleDependencyFix(String dependency) {
            this.myDependency = dependency;
        }

        @NotNull
        public String getFamilyName() {
            return "Remove dependency";
        }

        public void applyFix(@NotNull Project project, @NotNull ModuleProblemDescriptor descriptor) {
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)descriptor.getModule()).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                String mDependency;
                if (!(entry instanceof ModuleOrderEntry) || !Comparing.equal((String)(mDependency = ((ModuleOrderEntry)entry).getModuleName()), (String)this.myDependency)) continue;
                model.removeOrderEntry(entry);
                break;
            }
            model.commit();
        }
    }
}

