/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsDeclarationLocalInspection;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsGraphAnnotator;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrowsDeclarationInspection
extends GlobalJavaBatchInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.unneededThrows.RedundantThrows");
    public boolean IGNORE_ENTRY_POINTS = false;
    private final RedundantThrowsDeclarationLocalInspection myLocalInspection = new RedundantThrowsDeclarationLocalInspection(this);

    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.redundant.throws.display.name", (Object[])new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Ignore exceptions thrown by entry points methods", (InspectionProfileEntry)this, "IGNORE_ENTRY_POINTS");
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (refMethod.isSyntheticJSP()) {
                return null;
            }
            if (this.IGNORE_ENTRY_POINTS && refMethod.isEntry()) {
                return null;
            }
            PsiClass[] unThrown = refMethod.getUnThrownExceptions();
            if (unThrown == null) {
                return null;
            }
            PsiElement psiMethod = refMethod.getPsiElement();
            if (!(psiMethod instanceof PsiMethod)) {
                return null;
            }
            if (((PsiMethod)psiMethod).hasModifier(JvmModifier.NATIVE)) {
                return null;
            }
            PsiReferenceList list = ((PsiMethod)psiMethod).getThrowsList();
            PsiClassType[] throwsList = list.getReferencedTypes();
            PsiJavaCodeReferenceElement[] throwsRefs = list.getReferenceElements();
            ArrayList<ProblemDescriptor> problems = null;
            PsiManager psiManager = psiMethod.getManager();
            for (int i = 0; i < throwsList.length; ++i) {
                PsiClassType throwsType = throwsList[i];
                String throwsClassName = throwsType.getClassName();
                PsiJavaCodeReferenceElement throwsRef = throwsRefs[i];
                if (ExceptionUtil.isUncheckedException(throwsType) || RedundantThrowsDeclarationInspection.declaredInRemotableMethod((PsiMethod)psiMethod, throwsType)) continue;
                for (PsiClass s : unThrown) {
                    PsiClass throwsResolvedType = throwsType.resolve();
                    if (!psiManager.areElementsEquivalent((PsiElement)s, (PsiElement)throwsResolvedType)) continue;
                    if (problems == null) {
                        problems = new ArrayList<ProblemDescriptor>(1);
                    }
                    RefClass ownerClass = refMethod.getOwnerClass();
                    if (refMethod.isAbstract() || ownerClass != null && ownerClass.isInterface()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message((String)"inspection.redundant.throws.problem.descriptor", (Object[])new Object[]{"<code>#ref</code>"}), (LocalQuickFix)new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    if (!refMethod.getDerivedMethods().isEmpty()) {
                        problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message((String)"inspection.redundant.throws.problem.descriptor1", (Object[])new Object[]{"<code>#ref</code>"}), (LocalQuickFix)new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                        continue;
                    }
                    problems.add(manager.createProblemDescriptor((PsiElement)throwsRef, InspectionsBundle.message((String)"inspection.redundant.throws.problem.descriptor2", (Object[])new Object[]{"<code>#ref</code>"}), (LocalQuickFix)new MyQuickFix(processor, throwsClassName), ProblemHighlightType.LIKE_UNUSED_SYMBOL, false));
                }
            }
            if (problems != null) {
                return problems.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
            }
        }
        return null;
    }

    private static boolean declaredInRemotableMethod(PsiMethod psiMethod, PsiClassType throwsType) {
        if (!throwsType.equalsToText("java.rmi.RemoteException")) {
            return false;
        }
        PsiClass aClass = psiMethod.getContainingClass();
        if (aClass == null) {
            return false;
        }
        PsiClass remote = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("java.rmi.Remote", GlobalSearchScope.allScope((Project)aClass.getProject()));
        return remote != null && aClass.isInheritor(remote, true);
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (processor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(@NotNull RefMethod refMethod) {
                            globalContext.enqueueDerivedMethodsProcessor(refMethod, derivedMethod -> {
                                processor.ignoreElement((RefEntity)refMethod);
                                return true;
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new MyQuickFix(null, hint);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix2) {
        return fix2 instanceof MyQuickFix ? ((MyQuickFix)fix2).myHint : null;
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new RedundantThrowsGraphAnnotator(refManager);
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return this.myLocalInspection;
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private final ProblemDescriptionsProcessor myProcessor;
        private final String myHint;

        MyQuickFix(ProblemDescriptionsProcessor processor, String hint) {
            this.myProcessor = processor;
            this.myHint = hint;
        }

        @NotNull
        public String getFamilyName() {
            return InspectionsBundle.message((String)"inspection.redundant.throws.remove.quickfix", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (this.myProcessor != null) {
                RefMethod refMethod;
                CommonProblemDescriptor[] problems;
                RefElement refElement = (RefElement)this.myProcessor.getElement((CommonProblemDescriptor)descriptor);
                if (refElement instanceof RefMethod && refElement.isValid() && (problems = this.myProcessor.getDescriptions((RefEntity)(refMethod = (RefMethod)refElement))) != null) {
                    this.removeExcessiveThrows(refMethod, null, problems);
                }
            } else {
                PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class);
                if (psiMethod != null) {
                    this.removeExcessiveThrows(null, (PsiModifierListOwner)psiMethod, new CommonProblemDescriptor[]{descriptor});
                }
            }
        }

        private void removeExcessiveThrows(@Nullable RefMethod refMethod, @Nullable PsiModifierListOwner element, CommonProblemDescriptor[] problems) {
            try {
                PsiMethod psiMethod;
                if (element == null) {
                    LOG.assertTrue(refMethod != null);
                    psiMethod = (PsiMethod)ObjectUtils.tryCast((Object)refMethod.getPsiElement(), PsiMethod.class);
                } else {
                    psiMethod = (PsiMethod)element;
                }
                if (psiMethod == null) {
                    return;
                }
                Project project = psiMethod.getProject();
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                ArrayList refsToDelete = new ArrayList();
                block2: for (CommonProblemDescriptor problem : problems) {
                    PsiClassType[] classTypes;
                    PsiElement psiElement = ((ProblemDescriptor)problem).getPsiElement();
                    if (psiElement instanceof PsiJavaCodeReferenceElement) {
                        PsiJavaCodeReferenceElement classRef = (PsiJavaCodeReferenceElement)psiElement;
                        PsiClassType psiType = JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createType(classRef);
                        this.removeException(refMethod, (PsiType)psiType, refsToDelete, psiMethod);
                        continue;
                    }
                    PsiReferenceList throwsList = psiMethod.getThrowsList();
                    for (PsiClassType classType : classTypes = throwsList.getReferencedTypes()) {
                        String text2 = classType.getClassName();
                        if (!Comparing.strEqual((String)this.myHint, (String)text2)) continue;
                        this.removeException(refMethod, (PsiType)classType, refsToDelete, psiMethod);
                        continue block2;
                    }
                }
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(refsToDelete)) {
                    return;
                }
                WriteAction.run(() -> {
                    for (PsiElement aRefsToDelete : refsToDelete) {
                        if (!aRefsToDelete.isValid()) continue;
                        aRefsToDelete.delete();
                    }
                });
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private void removeException(RefMethod refMethod, PsiType exceptionType, List<? super PsiElement> refsToDelete, PsiMethod psiMethod) {
            ContainerUtil.addAll(refsToDelete, (Object[])MethodThrowsFix.Remove.extractRefsToRemove(psiMethod, exceptionType));
            if (refMethod != null) {
                assert (this.myProcessor != null);
                for (RefMethod refDerived : refMethod.getDerivedMethods()) {
                    PsiElement method = refDerived.getPsiElement();
                    if (!(method instanceof PsiMethod)) continue;
                    this.removeException(refDerived, exceptionType, refsToDelete, (PsiMethod)method);
                }
                ProblemDescriptionsProcessor.resolveAllProblemsInElement((ProblemDescriptionsProcessor)this.myProcessor, (RefEntity)refMethod);
            } else {
                Query query = OverridingMethodsSearch.search((PsiMethod)psiMethod);
                query.forEach(m -> {
                    this.removeException(null, exceptionType, refsToDelete, (PsiMethod)m);
                    return true;
                });
            }
        }

        public boolean startInWriteAction() {
            return false;
        }
    }
}

