/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedLibraries;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractDependencyVisitor;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModuleProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedLibrariesInspection
extends GlobalInspectionTool {
    private static final Logger LOG = Logger.getInstance(UnusedLibrariesInspection.class);
    public boolean IGNORE_LIBRARY_PARTS = true;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Don't report unused jars inside used library", (InspectionProfileEntry)this, "IGNORE_LIBRARY_PARTS");
    }

    @Nullable
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        return new UnusedLibraryGraphAnnotator(refManager);
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            VirtualFile[] givenRoots = OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutModuleSourceEntries().withoutDepModules().classes().getRoots();
            if (givenRoots.length == 0) {
                return null;
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Set usedRoots = (Set)refModule.getUserData(UnusedLibraryGraphAnnotator.USED_LIBRARY_ROOTS);
            if (usedRoots != null) {
                UnusedLibrariesInspection.appendUsedRootDependencies(usedRoots, givenRoots);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                boolean allRootsUnused;
                if (!(entry instanceof LibraryOrderEntry) || ((LibraryOrderEntry)entry).isExported() || ((LibraryOrderEntry)entry).getScope() == DependencyScope.RUNTIME) continue;
                HashSet<VirtualFile> files = new HashSet<VirtualFile>(Arrays.asList(((LibraryOrderEntry)entry).getRootFiles(OrderRootType.CLASSES)));
                boolean bl = allRootsUnused = usedRoots == null || !files.removeAll(usedRoots);
                if (allRootsUnused) {
                    String message2 = InspectionsBundle.message((String)"unused.library.problem.descriptor", (Object[])new Object[]{entry.getPresentableName()});
                    result.add(manager.createProblemDescriptor(message2, module, new QuickFix[]{new RemoveUnusedLibrary(entry.getPresentableName(), null)}));
                    continue;
                }
                if (files.isEmpty() || this.IGNORE_LIBRARY_PARTS) continue;
                String unusedLibraryRoots = StringUtil.join(files, file -> file.getPresentableName(), (String)",");
                String message3 = InspectionsBundle.message((String)"unused.library.roots.problem.descriptor", (Object[])new Object[]{unusedLibraryRoots, entry.getPresentableName()});
                CommonProblemDescriptor descriptor = ((LibraryOrderEntry)entry).isModuleLevel() ? manager.createProblemDescriptor(message3, module, new QuickFix[]{new RemoveUnusedLibrary(entry.getPresentableName(), files)}) : manager.createProblemDescriptor(message3, new QuickFix[0]);
                result.add(descriptor);
            }
            return result.isEmpty() ? null : result.toArray(CommonProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    private static void appendUsedRootDependencies(@NotNull Set<VirtualFile> usedRoots, final @NotNull VirtualFile[] givenRoots) {
        THashMap fromClasses = new THashMap();
        THashMap toClasses = new THashMap();
        UnusedLibrariesInspection.collectClassesPerRoots(givenRoots, (Map<VirtualFile, Set<String>>)fromClasses, (Map<VirtualFile, Set<String>>)toClasses);
        Graph graph = GraphGenerator.generate((InboundSemiGraph)new InboundSemiGraph<VirtualFile>((Map)fromClasses, (Map)toClasses){
            final /* synthetic */ Map val$fromClasses;
            final /* synthetic */ Map val$toClasses;
            {
                this.val$fromClasses = map2;
                this.val$toClasses = map3;
            }

            @NotNull
            public Collection<VirtualFile> getNodes() {
                return Arrays.asList(givenRoots);
            }

            @NotNull
            public Iterator<VirtualFile> getIn(VirtualFile n) {
                Set classesInCurrentRoot = (Set)this.val$fromClasses.get(n);
                return this.val$toClasses.entrySet().stream().filter(entry -> ContainerUtil.intersects((Collection)((Collection)entry.getValue()), (Collection)classesInCurrentRoot)).map(entry -> (VirtualFile)entry.getKey()).collect(Collectors.toSet()).iterator();
            }
        });
        GraphAlgorithms algorithms = GraphAlgorithms.getInstance();
        HashSet dependencies = new HashSet();
        for (VirtualFile root : usedRoots) {
            algorithms.collectOutsRecursively(graph, (Object)root, dependencies);
        }
        usedRoots.addAll(dependencies);
    }

    private static void collectClassesPerRoots(VirtualFile[] givenRoots, Map<VirtualFile, Set<String>> fromClasses, Map<VirtualFile, Set<String>> toClasses) {
        for (VirtualFile root : givenRoots) {
            THashSet fromClassNames = new THashSet();
            THashSet toClassNames = new THashSet();
            VfsUtilCore.iterateChildrenRecursively((VirtualFile)root, null, arg_0 -> UnusedLibrariesInspection.lambda$collectClassesPerRoots$1((Set)toClassNames, (Set)fromClassNames, arg_0));
            toClassNames.removeAll((Collection<?>)fromClassNames);
            fromClasses.put(root, (Set<String>)fromClassNames);
            toClasses.put(root, (Set<String>)toClassNames);
        }
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"unused.library.display.name", (Object[])new Object[0]);
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "UnusedLibrary";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new RemoveUnusedLibrary(hint, null);
    }

    @Nullable
    public String getHint(@NotNull QuickFix fix2) {
        if (fix2 instanceof RemoveUnusedLibrary && ((RemoveUnusedLibrary)fix2).myFiles == null) {
            return ((RemoveUnusedLibrary)fix2).myLibraryName;
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$collectClassesPerRoots$1(final Set toClassNames, Set fromClassNames, VirtualFile fileOrDir) {
        if (!fileOrDir.isDirectory() && fileOrDir.getName().endsWith(".class")) {
            AbstractDependencyVisitor visitor = new AbstractDependencyVisitor(){

                @Override
                protected void addClassName(String name) {
                    if (!name.startsWith("java.") && !name.startsWith("javax.")) {
                        toClassNames.add(name);
                    }
                }
            };
            try {
                visitor.processStream(fileOrDir.getInputStream());
                fromClassNames.add(visitor.getCurrentClassName());
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        return true;
    }

    private static class UnusedLibraryGraphAnnotator
    extends RefGraphAnnotator {
        public static final Key<Set<VirtualFile>> USED_LIBRARY_ROOTS = Key.create((String)"inspection.dependencies");
        private final ProjectFileIndex myFileIndex;
        private final RefManager myManager;

        UnusedLibraryGraphAnnotator(RefManager manager) {
            this.myManager = manager;
            this.myFileIndex = ProjectRootManager.getInstance((Project)manager.getProject()).getFileIndex();
        }

        public void onMarkReferenced(PsiElement what, PsiElement from, boolean referencedFromClassInitializer) {
            if (what != null && from != null) {
                RefModule refModule;
                Module fromModule;
                VirtualFile libraryClassRoot;
                VirtualFile containingDir;
                VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)what);
                VirtualFile virtualFile2 = containingDir = virtualFile != null ? virtualFile.getParent() : null;
                if (containingDir != null && (libraryClassRoot = this.myFileIndex.getClassRootForFile(containingDir)) != null && (fromModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)from)) != null && (refModule = this.myManager.getRefModule(fromModule)) != null) {
                    HashSet<VirtualFile> usedRoots = (HashSet<VirtualFile>)refModule.getUserData(USED_LIBRARY_ROOTS);
                    if (usedRoots == null) {
                        usedRoots = new HashSet<VirtualFile>();
                        refModule.putUserData(USED_LIBRARY_ROOTS, usedRoots);
                    }
                    usedRoots.add(libraryClassRoot);
                }
            }
        }
    }

    private static class RemoveUnusedLibrary
    implements QuickFix<ModuleProblemDescriptor> {
        private final Set<? extends VirtualFile> myFiles;
        private final String myLibraryName;

        RemoveUnusedLibrary(String libraryName, Set<? extends VirtualFile> files) {
            this.myLibraryName = libraryName;
            this.myFiles = files;
        }

        @NotNull
        public String getFamilyName() {
            return this.myFiles == null ? InspectionsBundle.message((String)"detach.library.quickfix.name", (Object[])new Object[0]) : InspectionsBundle.message((String)"detach.library.roots.quickfix.name", (Object[])new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ModuleProblemDescriptor descriptor) {
            Module module = descriptor.getModule();
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                if (!(entry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)entry.getPresentableName(), (String)this.myLibraryName)) continue;
                if (this.myFiles == null) {
                    model.removeOrderEntry(entry);
                    continue;
                }
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library == null) continue;
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                for (VirtualFile virtualFile : this.myFiles) {
                    modifiableModel.removeRoot(virtualFile.getUrl(), OrderRootType.CLASSES);
                }
                modifiableModel.commit();
            }
            model.commit();
        }
    }
}

