/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unusedReturnValue;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.MakeVoidQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefUtil;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.codeInspection.unusedReturnValue.UnusedReturnValueLocalInspection;
import com.intellij.codeInspection.unusedSymbol.VisibilityModifierChooser;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.VisibilityUtil;
import java.util.Collections;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnusedReturnValue
extends GlobalJavaBatchInspectionTool {
    public boolean IGNORE_BUILDER_PATTERN;
    @PsiModifier.ModifierConstant
    public static final String DEFAULT_HIGHEST_MODIFIER = "public";
    @PsiModifier.ModifierConstant
    public String highestModifier = "public";

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor) {
        if (refEntity instanceof RefMethod) {
            RefMethod refMethod = (RefMethod)refEntity;
            if (VisibilityUtil.compare((String)refMethod.getAccessModifier(), (String)this.highestModifier) < 0) {
                return null;
            }
            if (refMethod.isConstructor()) {
                return null;
            }
            if (!refMethod.getSuperMethods().isEmpty()) {
                return null;
            }
            if (refMethod.getInReferences().size() == 0) {
                return null;
            }
            if (refMethod.isEntry()) {
                return null;
            }
            if (!refMethod.isReturnValueUsed()) {
                PsiMethod psiMethod = (PsiMethod)refMethod.getUastElement().getJavaPsi();
                if (psiMethod == null) {
                    return null;
                }
                if (this.IGNORE_BUILDER_PATTERN && PropertyUtilBase.isSimplePropertySetter((PsiMethod)psiMethod)) {
                    return null;
                }
                boolean isNative = psiMethod.hasModifierProperty("native");
                if (refMethod.isExternalOverride() && !isNative) {
                    return null;
                }
                if (RefUtil.isImplicitRead((PsiElement)psiMethod)) {
                    return null;
                }
                if (UnusedReturnValue.canIgnoreReturnValue(psiMethod)) {
                    return null;
                }
                return new ProblemDescriptor[]{UnusedReturnValue.createProblemDescriptor(psiMethod, manager, processor, isNative, false)};
            }
        }
        return null;
    }

    static boolean canIgnoreReturnValue(PsiMethod psiMethod) {
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton("com.google.errorprone.annotations.CanIgnoreReturnValue"), (int)1);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (this.IGNORE_BUILDER_PATTERN || this.highestModifier != DEFAULT_HIGHEST_MODIFIER) {
            super.writeSettings(node);
        }
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel.addCheckbox("Ignore simple setters", "IGNORE_BUILDER_PATTERN");
        LabeledComponent component = LabeledComponent.create((JComponent)new VisibilityModifierChooser(() -> true, this.highestModifier, (Consumer<? super String>)((Consumer)newModifier -> {
            this.highestModifier = newModifier;
        })), (String)"Maximal reported method visibility:", (String)"West");
        panel.addComponent((JComponent)component);
        return panel;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext globalContext, final @NotNull ProblemDescriptionsProcessor processor) {
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity instanceof RefElement && processor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            globalContext.enqueueMethodUsagesProcessor(refMethod, new GlobalJavaInspectionContext.UsagesProcessor(){

                                public boolean process(PsiReference psiReference) {
                                    processor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.unused.return.value.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.DECLARATION_REDUNDANCY;
    }

    @NotNull
    public String getShortName() {
        return "UnusedReturnValue";
    }

    @Nullable
    public QuickFix getQuickFix(String hint) {
        return new MakeVoidQuickFix(null);
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new UnusedReturnValueLocalInspection(this);
    }

    static ProblemDescriptor createProblemDescriptor(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, @Nullable ProblemDescriptionsProcessor processor, boolean isNative, boolean isOnTheFly) {
        return manager.createProblemDescriptor((PsiElement)psiMethod.getNameIdentifier(), InspectionsBundle.message((String)"inspection.unused.return.value.problem.descriptor", (Object[])new Object[0]), (LocalQuickFix)(isNative ? null : new MakeVoidQuickFix(processor)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
    }
}

