/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.codeInspection.util.LambdaGenerationUtil;
import com.intellij.codeInspection.util.OptionalUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaParameterType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.JavaPsiMathUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalRefactoringUtil {
    public static String generateOptionalUnwrap(String qualifier, PsiVariable var, @NotNull PsiExpression trueExpression, PsiExpression falseExpression, @Nullable PsiType targetType, boolean useOrElseGet) {
        Number falseValue;
        boolean trivialMap;
        PsiExpression stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)trueExpression);
        PsiType trueType = trueExpression.getType();
        boolean bl = trivialMap = ExpressionUtils.isReferenceTo(trueExpression, var) && targetType != null && (trueType instanceof PsiLambdaParameterType || Objects.requireNonNull(trueType).isAssignableFrom(targetType));
        if (!trivialMap) {
            PsiType elementType;
            PsiTypeCastExpression castExpression;
            PsiTypeElement castType;
            if (stripped instanceof PsiTypeCastExpression && ExpressionUtils.isNullLiteral(falseExpression) && (castType = (castExpression = (PsiTypeCastExpression)stripped).getCastType()) != null && ExpressionUtils.isReferenceTo(castExpression.getOperand(), var)) {
                return "(" + castType.getText() + ")" + qualifier + ".orElse(null)";
            }
            if (ExpressionUtils.isLiteral((PsiElement)falseExpression, Boolean.FALSE) && PsiType.BOOLEAN.equals((Object)trueType)) {
                if (ExpressionUtils.isLiteral((PsiElement)trueExpression, Boolean.TRUE)) {
                    return qualifier + ".isPresent()";
                }
                return qualifier + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ").isPresent()";
            }
            if (ExpressionUtils.isLiteral((PsiElement)falseExpression, Boolean.TRUE) && ExpressionUtils.isLiteral((PsiElement)trueExpression, Boolean.FALSE)) {
                return "!" + qualifier + ".isPresent()";
            }
            if (stripped instanceof PsiConditionalExpression) {
                PsiConditionalExpression condition2 = (PsiConditionalExpression)stripped;
                PsiExpression thenExpression2 = condition2.getThenExpression();
                PsiExpression elseExpression2 = condition2.getElseExpression();
                if (thenExpression2 != null && elseExpression2 != null) {
                    if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseExpression, (PsiElement)elseExpression2)) {
                        return OptionalRefactoringUtil.generateOptionalUnwrap(qualifier + ".filter(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)condition2.getCondition()) + ")", var, thenExpression2, falseExpression, targetType, useOrElseGet);
                    }
                    if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)falseExpression, (PsiElement)thenExpression2)) {
                        return OptionalRefactoringUtil.generateOptionalUnwrap(qualifier + ".filter(" + var.getName() + " -> " + BoolUtils.getNegatedExpressionText(condition2.getCondition()) + ")", var, elseExpression2, falseExpression, targetType, useOrElseGet);
                    }
                }
            }
            String suffix = null;
            boolean java9 = PsiUtil.isLanguageLevel9OrHigher((PsiElement)trueExpression);
            if (OptionalUtil.isOptionalEmptyCall(falseExpression)) {
                suffix = "";
            } else if (java9 && InheritanceUtil.isInheritor((PsiType)falseExpression.getType(), (String)"java.util.Optional") && LambdaGenerationUtil.canBeUncheckedLambda((PsiElement)falseExpression)) {
                suffix = ".or(() -> " + falseExpression.getText() + ")";
            }
            if (suffix != null) {
                PsiMethodCallExpression mappedOptional = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)stripped, PsiMethodCallExpression.class);
                if (OptionalUtil.JDK_OPTIONAL_WRAP_METHOD.test(mappedOptional)) {
                    PsiExpression arg = mappedOptional.getArgumentList().getExpressions()[0];
                    if (ExpressionUtils.isReferenceTo(arg, var)) {
                        return qualifier + suffix;
                    }
                    return qualifier + ".map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)arg) + ")" + suffix;
                }
                if (suffix.isEmpty()) {
                    return qualifier + ".flatMap(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
                }
            }
            if (java9 && StreamApiUtil.isNullOrEmptyStream(falseExpression) && !ExpressionUtils.isNullLiteral(falseExpression) && (elementType = StreamApiUtil.getStreamElementType(targetType)) != null) {
                String flatMapOperationName;
                PsiMethod method;
                PsiExpression[] args;
                PsiMethodCallExpression mappedStream = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)stripped, PsiMethodCallExpression.class);
                if (mappedStream != null && "of".equals(mappedStream.getMethodExpression().getReferenceName()) && (args = mappedStream.getArgumentList().getExpressions()).length == 1 && (method = mappedStream.resolveMethod()) != null && method.getContainingClass() != null) {
                    String className = method.getContainingClass().getQualifiedName();
                    PsiParameter[] parameters2 = method.getParameterList().getParameters();
                    if (className != null && className.startsWith("java.util.stream.") && parameters2.length == 1 && !(parameters2[0].getType() instanceof PsiArrayType)) {
                        PsiExpression arg = args[0];
                        if (ExpressionUtils.isReferenceTo(arg, var)) {
                            return qualifier + ".stream()";
                        }
                        if (arg.getType() != null && elementType.isAssignableFrom(arg.getType())) {
                            return qualifier + ".stream()" + StreamRefactoringUtil.generateMapOperation(var, elementType, (PsiElement)arg);
                        }
                    }
                }
                if ((flatMapOperationName = StreamRefactoringUtil.getFlatMapOperationName(var.getType(), elementType)) != null && !SideEffectChecker.mayHaveSideEffects(trueExpression)) {
                    return qualifier + ".stream()." + flatMapOperationName + "(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
                }
            }
            trueExpression = targetType == null ? trueExpression : RefactoringUtil.convertInitializerToNormalExpression(trueExpression, targetType);
            String typeArg = OptionalRefactoringUtil.getMapTypeArgument(trueExpression, targetType, falseExpression);
            qualifier = qualifier + "." + typeArg + "map(" + LambdaUtil.createLambda((PsiVariable)var, (PsiExpression)trueExpression) + ")";
        }
        if (useOrElseGet && !ExpressionUtils.isSafelyRecomputableExpression(falseExpression)) {
            return qualifier + ".orElseGet(() -> " + falseExpression.getText() + ")";
        }
        PsiType falseType = falseExpression.getType();
        String falseText = falseExpression.getText();
        if (falseType instanceof PsiPrimitiveType && targetType instanceof PsiPrimitiveType && !targetType.equals(falseType) && (falseValue = JavaPsiMathUtil.getNumberFromLiteral(falseExpression)) != null) {
            falseText = falseValue.toString();
            if (targetType.equals(PsiType.FLOAT)) {
                falseText = falseText + "F";
            } else if (targetType.equals(PsiType.DOUBLE) && !falseText.contains(".")) {
                falseText = falseText + ".0";
            } else if (targetType.equals(PsiType.LONG)) {
                falseText = falseText + "L";
            }
        }
        return qualifier + ".orElse(" + falseText + ")";
    }

    @NotNull
    public static String getMapTypeArgument(PsiExpression expression2, PsiType type2) {
        return OptionalRefactoringUtil.getMapTypeArgument(expression2, type2, null);
    }

    @NotNull
    private static String getMapTypeArgument(PsiExpression expression2, PsiType type2, PsiExpression falseExpression) {
        if (!(type2 instanceof PsiClassType)) {
            return "";
        }
        String text2 = expression2.getText();
        if (text2.isEmpty()) {
            return "";
        }
        PsiExpression copy = JavaPsiFacade.getElementFactory((Project)expression2.getProject()).createExpressionFromText(text2, (PsiElement)expression2);
        PsiType exprType = copy.getType();
        if (exprType != null && !exprType.equals(PsiType.NULL) && !LambdaUtil.notInferredType((PsiType)exprType) && TypeConversionUtil.isAssignable((PsiType)type2, (PsiType)exprType)) {
            if (falseExpression == null) {
                return "";
            }
            PsiType falseType = falseExpression.getType();
            if (falseType != null && (falseType.isAssignableFrom(exprType) || falseType.equals(PsiType.NULL))) {
                return "";
            }
        }
        return "<" + type2.getCanonicalText() + ">";
    }
}

