/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtilBase {
    public static LocalQuickFix createAddToSpecialAnnotationsListQuickFix(final @NotNull String text2, final @NotNull String family, final @NotNull List<String> targetList, final @NotNull String qualifiedName, PsiElement context) {
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                return text2;
            }

            @NotNull
            public String getFamilyName() {
                return family;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                SpecialAnnotationsUtilBase.doQuickFixInternal(project, targetList, qualifiedName);
            }
        };
    }

    static void doQuickFixInternal(@NotNull Project project, @NotNull List<String> targetList, @NotNull String qualifiedName) {
        targetList.add(qualifiedName);
        Collections.sort(targetList);
        ProjectInspectionProfileManager.getInstance((Project)project).fireProfileChanged();
    }

    public static void createAddToSpecialAnnotationFixes(@NotNull PsiModifierListOwner owner, @NotNull Processor<? super String> processor) {
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            PsiAnnotation psiAnnotation;
            String name;
            PsiAnnotation[] psiAnnotations;
            PsiAnnotation[] psiAnnotationArray = psiAnnotations = modifierList.getAnnotations();
            int n = psiAnnotationArray.length;
            for (int i = 0; i < n && ((name = (psiAnnotation = psiAnnotationArray[i]).getQualifiedName()) == null || name.startsWith("java.") || name.startsWith("org.jetbrains.") || NullableNotNullManager.isNullableAnnotation((PsiAnnotation)psiAnnotation) || NullableNotNullManager.isNotNullAnnotation((PsiAnnotation)psiAnnotation) || processor.process((Object)name)); ++i) {
            }
        }
    }
}

