/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConvertToLocalQuickFix<V extends PsiVariable>
implements LocalQuickFix {
    protected static final Logger LOG = Logger.getInstance(BaseConvertToLocalQuickFix.class);

    @NotNull
    public final String getFamilyName() {
        return InspectionsBundle.message((String)"inspection.convert.to.local.quickfix", (Object[])new Object[0]);
    }

    public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        V variable = this.getVariable(descriptor);
        if (variable == null || !variable.isValid()) {
            return;
        }
        PsiFile myFile = variable.getContainingFile();
        try {
            List<PsiElement> newDeclarations = this.moveDeclaration(project, variable);
            if (newDeclarations.isEmpty()) {
                return;
            }
            BaseConvertToLocalQuickFix.positionCaretToDeclaration(project, myFile, newDeclarations.get(newDeclarations.size() - 1));
            newDeclarations.forEach(declaration2 -> BaseConvertToLocalQuickFix.inlineRedundant(declaration2));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void inlineRedundant(@Nullable PsiElement declaration2) {
        if (declaration2 == null) {
            return;
        }
        PsiLocalVariable newVariable = BaseConvertToLocalQuickFix.extractDeclared(declaration2);
        if (newVariable != null) {
            PsiExpression initializer = ParenthesesUtils.stripParentheses(newVariable.getInitializer());
            WriteAction.run(() -> {
                if (VariableAccessUtils.isLocalVariableCopy(newVariable, initializer)) {
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)newVariable).findAll()) {
                        InlineUtil.inlineVariable((PsiVariable)newVariable, initializer, (PsiJavaCodeReferenceElement)reference);
                    }
                    declaration2.delete();
                }
            });
        }
    }

    @Nullable
    private static PsiLocalVariable extractDeclared(@NotNull PsiElement declaration2) {
        if (!(declaration2 instanceof PsiDeclarationStatement)) {
            return null;
        }
        PsiElement[] declaredElements = ((PsiDeclarationStatement)declaration2).getDeclaredElements();
        if (declaredElements.length != 1) {
            return null;
        }
        return (PsiLocalVariable)ObjectUtils.tryCast((Object)declaredElements[0], PsiLocalVariable.class);
    }

    @Nullable
    protected abstract V getVariable(@NotNull ProblemDescriptor var1);

    protected static void positionCaretToDeclaration(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement declaration2) {
        PsiFile openedFile;
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null && (IJSwingUtilities.hasFocus((Component)editor.getComponent()) || ApplicationManager.getApplication().isUnitTestMode()) && (openedFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument())) == psiFile) {
            editor.getCaretModel().moveToOffset(declaration2.getTextOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected void beforeDelete(@NotNull Project project, @NotNull V variable, @NotNull PsiElement newDeclaration) {
    }

    @NotNull
    protected List<PsiElement> moveDeclaration(@NotNull Project project, @NotNull V variable) {
        Collection references = ReferencesSearch.search(variable).findAll();
        if (references.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.moveDeclaration(project, variable, references, true));
    }

    protected PsiElement moveDeclaration(Project project, V variable, Collection<? extends PsiReference> references, boolean delete) {
        PsiCodeBlock anchorBlock = BaseConvertToLocalQuickFix.findAnchorBlock(references);
        if (anchorBlock == null) {
            return null;
        }
        PsiElement firstElement = BaseConvertToLocalQuickFix.getLowestOffsetElement(references);
        String localName = this.suggestLocalName(project, variable, anchorBlock);
        PsiElement anchor = BaseConvertToLocalQuickFix.getAnchorElement(anchorBlock, firstElement);
        PsiAssignmentExpression anchorAssignmentExpression = BaseConvertToLocalQuickFix.searchAssignmentExpression(anchor);
        if (anchorAssignmentExpression != null && BaseConvertToLocalQuickFix.isVariableAssignment(anchorAssignmentExpression, variable)) {
            HashSet<? extends PsiReference> refsSet = new HashSet<PsiReference>(references);
            refsSet.remove(anchorAssignmentExpression.getLExpression());
            return this.applyChanges(project, localName, anchorAssignmentExpression.getRExpression(), variable, refsSet, delete, (NotNullFunction<PsiDeclarationStatement, PsiElement>)((NotNullFunction)declaration2 -> new CommentTracker().replaceAndRestoreComments(anchor, (PsiElement)declaration2)));
        }
        return this.applyChanges(project, localName, variable.getInitializer(), variable, references, delete, (NotNullFunction<PsiDeclarationStatement, PsiElement>)((NotNullFunction)declaration2 -> {
            PsiElement parent = anchorBlock.getParent();
            if (parent instanceof PsiSwitchStatement) {
                PsiElement switchContainer = parent.getParent();
                return switchContainer.addBefore((PsiElement)declaration2, parent);
            }
            return anchorBlock.addBefore((PsiElement)declaration2, anchor);
        }));
    }

    protected PsiElement applyChanges(@NotNull Project project, @NotNull String localName, @Nullable PsiExpression initializer, @NotNull V variable, @NotNull Collection<? extends PsiReference> references, boolean delete, @NotNull NotNullFunction<? super PsiDeclarationStatement, ? extends PsiElement> action) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
        return (PsiElement)WriteAction.compute(() -> {
            PsiElement newDeclaration = this.moveDeclaration(elementFactory, localName, variable, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
            if (delete) {
                this.deleteSourceVariable(project, variable, newDeclaration);
            }
            return newDeclaration;
        });
    }

    protected void deleteSourceVariable(@NotNull Project project, @NotNull V variable, PsiElement newDeclaration) {
        CommentTracker tracker = new CommentTracker();
        this.beforeDelete(project, variable, newDeclaration);
        variable.normalizeDeclaration();
        tracker.delete((PsiElement)variable);
        tracker.insertCommentsBefore(newDeclaration);
    }

    protected PsiElement moveDeclaration(PsiElementFactory elementFactory, String localName, V variable, PsiExpression initializer, NotNullFunction<? super PsiDeclarationStatement, ? extends PsiElement> action, Collection<? extends PsiReference> references) {
        PsiDeclarationStatement declaration2 = elementFactory.createVariableDeclarationStatement(localName, variable.getType(), initializer);
        if (references.stream().map(PsiReference::getElement).anyMatch(element -> element instanceof PsiExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)element)))) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiLocalVariable)declaration2.getDeclaredElements()[0]), (String)"final", (boolean)false);
        }
        PsiElement newDeclaration = (PsiElement)action.fun((Object)declaration2);
        BaseConvertToLocalQuickFix.retargetReferences(elementFactory, localName, references);
        return newDeclaration;
    }

    @Nullable
    private static PsiAssignmentExpression searchAssignmentExpression(@Nullable PsiElement anchor) {
        if (!(anchor instanceof PsiExpressionStatement)) {
            return null;
        }
        PsiExpression anchorExpression = ((PsiExpressionStatement)anchor).getExpression();
        if (!(anchorExpression instanceof PsiAssignmentExpression)) {
            return null;
        }
        return (PsiAssignmentExpression)anchorExpression;
    }

    private static boolean isVariableAssignment(@NotNull PsiAssignmentExpression expression2, @NotNull PsiVariable variable) {
        if (expression2.getOperationTokenType() != JavaTokenType.EQ) {
            return false;
        }
        if (!(expression2.getLExpression() instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression leftExpression = (PsiReferenceExpression)expression2.getLExpression();
        return leftExpression.isReferenceTo((PsiElement)variable);
    }

    @NotNull
    protected abstract String suggestLocalName(@NotNull Project var1, @NotNull V var2, @NotNull PsiCodeBlock var3);

    private static void retargetReferences(PsiElementFactory elementFactory, String localName, Collection<? extends PsiReference> refs) throws IncorrectOperationException {
        PsiReferenceExpression refExpr = (PsiReferenceExpression)elementFactory.createExpressionFromText(localName, null);
        for (PsiReference psiReference : refs) {
            if (!(psiReference instanceof PsiReferenceExpression)) continue;
            ((PsiReferenceExpression)psiReference).replace((PsiElement)refExpr);
        }
    }

    @Nullable
    private static PsiElement getAnchorElement(PsiCodeBlock anchorBlock, @NotNull PsiElement firstElement) {
        PsiElement element;
        for (element = firstElement; element != null && element.getParent() != anchorBlock; element = element.getParent()) {
        }
        return element;
    }

    @Nullable
    private static PsiElement getLowestOffsetElement(@NotNull Collection<? extends PsiReference> refs) {
        PsiElement firstElement = null;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            if (!(element instanceof PsiReferenceExpression) || firstElement != null && firstElement.getTextRange().getStartOffset() <= element.getTextRange().getStartOffset()) continue;
            firstElement = element;
        }
        return firstElement;
    }

    private static PsiCodeBlock findAnchorBlock(Collection<? extends PsiReference> refs) {
        PsiCodeBlock result = null;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            PsiCodeBlock block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class);
            if (result == null || block == null) {
                result = block;
                continue;
            }
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)result, (PsiElement)block);
            result = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)commonParent, PsiCodeBlock.class, (boolean)false);
        }
        return result;
    }
}

