/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.varScopeCanBeNarrowed.BaseConvertToLocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.NotNullFunction;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterCanBeLocalInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "ParameterCanBeLocal";

    protected ConvertParameterToLocalQuickFix createFix() {
        return new ConvertParameterToLocalQuickFix();
    }

    @NotNull
    public String getGroupDisplayName() {
        return GroupNames.CLASS_LAYOUT_GROUP_NAME;
    }

    @NotNull
    public String getDisplayName() {
        return InspectionsBundle.message((String)"inspection.parameter.can.be.local.display.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return SHORT_NAME;
    }

    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        List<PsiParameter> parameters2 = ParameterCanBeLocalInspection.filterFinal(method.getParameterList().getParameters());
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || parameters2.isEmpty() || ParameterCanBeLocalInspection.isOverrides(method) || MethodUtils.isOverridden(method)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (PsiParameter parameter2 : ParameterCanBeLocalInspection.getWriteBeforeRead(parameters2, body2)) {
            PsiIdentifier identifier = parameter2.getNameIdentifier();
            if (identifier == null || !identifier.isPhysical()) continue;
            result.add(this.createProblem(manager, identifier, isOnTheFly));
        }
        return result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private ProblemDescriptor createProblem(@NotNull InspectionManager manager, @NotNull PsiIdentifier identifier, boolean isOnTheFly) {
        return manager.createProblemDescriptor((PsiElement)identifier, InspectionsBundle.message((String)"inspection.parameter.can.be.local.problem.descriptor", (Object[])new Object[0]), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly, new LocalQuickFix[]{this.createFix()});
    }

    @NotNull
    private static List<PsiParameter> filterFinal(PsiParameter[] parameters2) {
        ArrayList<PsiParameter> result = new ArrayList<PsiParameter>(parameters2.length);
        for (PsiParameter parameter2 : parameters2) {
            if (parameter2.hasModifierProperty("final")) continue;
            result.add(parameter2);
        }
        return result;
    }

    private static Collection<PsiParameter> getWriteBeforeRead(@NotNull Collection<? extends PsiParameter> parameters2, @NotNull PsiCodeBlock body2) {
        ControlFlow controlFlow = ParameterCanBeLocalInspection.getControlFlow((PsiElement)body2);
        if (controlFlow == null) {
            return Collections.emptyList();
        }
        Set<PsiParameter> result = ParameterCanBeLocalInspection.filterParameters(controlFlow, parameters2);
        result.retainAll(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        for (PsiReferenceExpression readBeforeWrite : ControlFlowUtil.getReadBeforeWrite(controlFlow)) {
            PsiElement resolved = readBeforeWrite.resolve();
            if (!(resolved instanceof PsiParameter)) continue;
            result.remove(resolved);
        }
        return result;
    }

    private static Set<PsiParameter> filterParameters(@NotNull ControlFlow controlFlow, @NotNull Collection<? extends PsiParameter> parameters2) {
        HashSet<PsiVariable> usedVars = new HashSet<PsiVariable>(ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize()));
        HashSet<PsiParameter> result = new HashSet<PsiParameter>();
        for (PsiParameter psiParameter : parameters2) {
            if (!usedVars.contains(psiParameter)) continue;
            result.add(psiParameter);
        }
        return result;
    }

    private static boolean isOverrides(PsiMethod method) {
        return SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst() != null;
    }

    @Nullable
    private static ControlFlow getControlFlow(PsiElement context) {
        try {
            return ControlFlowFactory.getInstance(context.getProject()).getControlFlow(context, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    public static class ConvertParameterToLocalQuickFix
    extends BaseConvertToLocalQuickFix<PsiParameter> {
        @Override
        protected PsiParameter getVariable(@NotNull ProblemDescriptor descriptor) {
            return (PsiParameter)descriptor.getPsiElement().getParent();
        }

        @Override
        protected PsiElement applyChanges(final @NotNull Project project, final @NotNull String localName, final @Nullable PsiExpression initializer, final @NotNull PsiParameter parameter2, final @NotNull Collection<? extends PsiReference> references, boolean delete, final @NotNull NotNullFunction<? super PsiDeclarationStatement, ? extends PsiElement> action) {
            PsiElement scope = parameter2.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                ArrayList<ParameterInfoImpl> info = new ArrayList<ParameterInfoImpl>();
                for (int i = 0; i < parameters2.length; ++i) {
                    PsiParameter psiParameter = parameters2[i];
                    if (psiParameter == parameter2) continue;
                    info.add(new ParameterInfoImpl(i, psiParameter.getName(), psiParameter.getType()));
                }
                ParameterInfoImpl[] newParams = info.toArray(new ParameterInfoImpl[0]);
                String visibilityModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
                PsiType returnType = method.getReturnType();
                JavaChangeInfoImpl changeInfo = new JavaChangeInfoImpl(visibilityModifier, method, method.getName(), returnType != null ? CanonicalTypes.createTypeWrapper(returnType) : null, newParams, null, false, ContainerUtil.newHashSet(), ContainerUtil.newHashSet());
                class ParameterToLocalProcessor
                extends ChangeSignatureProcessor {
                    private PsiElement newDeclaration;

                    ParameterToLocalProcessor(Project project3, JavaChangeInfo changeInfo) {
                        super(project3, changeInfo);
                    }

                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                        this.newDeclaration = ConvertParameterToLocalQuickFix.this.moveDeclaration(elementFactory, localName, parameter2, initializer, (NotNullFunction<PsiDeclarationStatement, PsiElement>)action, references);
                        super.performRefactoring(usages);
                    }
                }
                ParameterToLocalProcessor processor = new ParameterToLocalProcessor(project, changeInfo);
                processor.run();
                return processor.newDeclaration;
            }
            return null;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @Override
        @NotNull
        protected String suggestLocalName(@NotNull Project project, @NotNull PsiParameter parameter2, @NotNull PsiCodeBlock scope) {
            return parameter2.getName();
        }
    }
}

