/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalSystem;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.util.DisposeAwareProjectChange;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaProjectDataService
extends AbstractProjectDataService<JavaProjectData, Project> {
    @NotNull
    public Key<JavaProjectData> getTargetDataKey() {
        return JavaProjectData.KEY;
    }

    public void importData(@NotNull Collection<DataNode<JavaProjectData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport.isEmpty() || projectData == null) {
            return;
        }
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single project but got %d: %s", toImport.size(), toImport));
        }
        DataNode<JavaProjectData> javaProjectDataNode = toImport.iterator().next();
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(javaProjectDataNode, (Key)ProjectKeys.PROJECT);
        assert (projectDataNode != null);
        if (!ExternalSystemApiUtil.isOneToOneMapping((Project)project, (ProjectData)((ProjectData)projectDataNode.getData()))) {
            return;
        }
        JavaProjectData javaProjectData = (JavaProjectData)((Object)javaProjectDataNode.getData());
        JavaSdkVersion version = javaProjectData.getJdkVersion();
        JavaSdk javaSdk = JavaSdk.getInstance();
        ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project);
        Sdk sdk = rootManager.getProjectSdk();
        if (sdk != null) {
            JavaSdkVersion currentVersion = javaSdk.getVersion(sdk);
            if (currentVersion == null || !currentVersion.isAtLeast(version)) {
                JavaProjectDataService.updateSdk(project, version);
            }
        } else {
            JavaProjectDataService.updateSdk(project, version);
        }
        this.setLanguageLevel(javaProjectData.getLanguageLevel(), project);
    }

    private static void updateSdk(final @NotNull Project project, final @NotNull JavaSdkVersion version) {
        final Sdk sdk = JavaSdkVersionUtil.findJdkByVersion((JavaSdkVersion)version);
        if (sdk == null) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                ProjectRootManager.getInstance((Project)project).setProjectSdk(sdk);
                LanguageLevel level = version.getMaxLanguageLevel();
                LanguageLevelProjectExtension languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project);
                if (level.compareTo((Enum)languageLevelExtension.getLanguageLevel()) < 0) {
                    languageLevelExtension.setLanguageLevel(level);
                }
            }
        });
    }

    public void setLanguageLevel(final @NotNull LanguageLevel languageLevel, @NotNull Project project) {
        final LanguageLevelProjectExtension languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project);
        if (languageLevelExtension.getLanguageLevel().isAtLeast(languageLevel)) {
            return;
        }
        ExternalSystemApiUtil.executeProjectChangeAction((DisposeAwareProjectChange)new DisposeAwareProjectChange((ComponentManager)project){

            public void execute() {
                languageLevelExtension.setLanguageLevel(languageLevel);
            }
        });
    }
}

