/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.SearchScope;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class JavaMethodFindUsagesOptions
extends JavaFindUsagesOptions {
    public boolean isOverridingMethods;
    public boolean isImplementingMethods;
    public boolean isCheckDeepInheritance = true;
    public boolean isIncludeInherited;
    public boolean isIncludeOverloadUsages;
    public boolean isImplicitToString = true;

    public JavaMethodFindUsagesOptions(@NotNull Project project) {
        super(project);
        this.isSearchForTextOccurrences = false;
    }

    public JavaMethodFindUsagesOptions(@NotNull SearchScope searchScope) {
        super(searchScope);
        this.isSearchForTextOccurrences = false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaMethodFindUsagesOptions that = (JavaMethodFindUsagesOptions)((Object)o);
        if (this.isCheckDeepInheritance != that.isCheckDeepInheritance) {
            return false;
        }
        if (this.isImplementingMethods != that.isImplementingMethods) {
            return false;
        }
        if (this.isIncludeInherited != that.isIncludeInherited) {
            return false;
        }
        if (this.isIncludeOverloadUsages != that.isIncludeOverloadUsages) {
            return false;
        }
        if (this.isOverridingMethods != that.isOverridingMethods) {
            return false;
        }
        return this.isImplicitToString == that.isImplicitToString;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isOverridingMethods ? 1 : 0);
        result = 31 * result + (this.isImplementingMethods ? 1 : 0);
        result = 31 * result + (this.isCheckDeepInheritance ? 1 : 0);
        result = 31 * result + (this.isIncludeInherited ? 1 : 0);
        result = 31 * result + (this.isIncludeOverloadUsages ? 1 : 0);
        result = 31 * result + (this.isImplicitToString ? 1 : 0);
        return result;
    }

    @Override
    protected void addUsageTypes(@NotNull LinkedHashSet<String> strings) {
        super.addUsageTypes(strings);
        if (this.isIncludeOverloadUsages) {
            strings.add(FindBundle.message((String)"find.usages.panel.title.overloaded.methods.usages", (Object[])new Object[0]));
        }
        if (this.isImplementingMethods) {
            strings.add(FindBundle.message((String)"find.usages.panel.title.implementing.methods", (Object[])new Object[0]));
        }
        if (this.isOverridingMethods) {
            strings.add(FindBundle.message((String)"find.usages.panel.title.overriding.methods", (Object[])new Object[0]));
        }
    }
}

