/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.actions.SearchEverywhereClassifier;
import com.intellij.ide.actions.searcheverywhere.PsiElementsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SEResultsEqualityProvider;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereFoundElementInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaClassAndFileEqualityProvider
implements SEResultsEqualityProvider {
    @NotNull
    public SEResultsEqualityProvider.SEEqualElementsActionType compareItems(@NotNull SearchEverywhereFoundElementInfo newItemInfo, @NotNull SearchEverywhereFoundElementInfo alreadyFoundItemInfo) {
        PsiElement newElementPsi = PsiElementsEqualityProvider.toPsi((Object)newItemInfo.getElement());
        PsiElement alreadyFoundPsi = PsiElementsEqualityProvider.toPsi((Object)alreadyFoundItemInfo.getElement());
        if (newElementPsi == null || alreadyFoundPsi == null) {
            return SEResultsEqualityProvider.SEEqualElementsActionType.DO_NOTHING;
        }
        if (JavaClassAndFileEqualityProvider.isClassAndFile(newItemInfo, alreadyFoundItemInfo) && JavaClassAndFileEqualityProvider.isSameFile(newElementPsi, alreadyFoundPsi)) {
            return newItemInfo.priority > alreadyFoundItemInfo.priority ? SEResultsEqualityProvider.SEEqualElementsActionType.REPLACE : SEResultsEqualityProvider.SEEqualElementsActionType.SKIP;
        }
        return SEResultsEqualityProvider.SEEqualElementsActionType.DO_NOTHING;
    }

    private static boolean isClassAndFile(@NotNull SearchEverywhereFoundElementInfo newItemInfo, @NotNull SearchEverywhereFoundElementInfo alreadyFoundItemInfo) {
        Object newElement = newItemInfo.getElement();
        Object oldElement = alreadyFoundItemInfo.getElement();
        return JavaClassAndFileEqualityProvider.isClass(newElement) && JavaClassAndFileEqualityProvider.isFile(oldElement) || JavaClassAndFileEqualityProvider.isClass(oldElement) && JavaClassAndFileEqualityProvider.isFile(newElement);
    }

    private static boolean isFile(Object element) {
        return element instanceof PsiFile || element instanceof VirtualFile;
    }

    private static boolean isClass(Object element) {
        return element instanceof PsiClass;
    }

    private static boolean isSameFile(@NotNull PsiElement newItem, @NotNull PsiElement alreadyFound) {
        VirtualFile newItemFile = JavaClassAndFileEqualityProvider.convertToFileIsPossible(newItem);
        VirtualFile foundItemFile = JavaClassAndFileEqualityProvider.convertToFileIsPossible(alreadyFound);
        return newItemFile != null && newItemFile.equals(foundItemFile);
    }

    @Nullable
    private static VirtualFile convertToFileIsPossible(@NotNull PsiElement element) {
        if (element instanceof VirtualFile) {
            return (VirtualFile)element;
        }
        if (element instanceof PsiFile) {
            return ((PsiFile)element).getVirtualFile();
        }
        if (element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile();
        }
        if (element instanceof PsiNamedElement) {
            String name = ((PsiNamedElement)element).getName();
            VirtualFile virtualFile = SearchEverywhereClassifier.EP_Manager.getVirtualFile((Object)element);
            if (virtualFile != null && StringUtil.equals((CharSequence)name, (CharSequence)virtualFile.getNameWithoutExtension())) {
                return virtualFile;
            }
        }
        return null;
    }
}

