/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVirtualFileQualifiedNameProvider
implements CopyReferenceAction.VirtualFileQualifiedNameProvider {
    @Nullable
    public String getQualifiedName(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        String relative;
        VirtualFile logicalRootFile;
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(virtualFile, false);
        if (module == null || !ModuleType.is((Module)module, (ModuleType)JavaModuleType.getModuleType())) {
            return null;
        }
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project).findLogicalRoot(virtualFile);
        VirtualFile virtualFile2 = logicalRootFile = logicalRoot != null ? logicalRoot.getVirtualFile() : null;
        if (logicalRootFile != null && !virtualFile.equals(logicalRootFile)) {
            return (String)ObjectUtils.assertNotNull((Object)VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)logicalRootFile, (char)'/'));
        }
        Object outerMostRoot = null;
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (VirtualFile each = virtualFile; each != null && (each = index.getContentRootForFile(each, false)) != null; each = each.getParent()) {
            outerMostRoot = each;
        }
        if (outerMostRoot != null && !outerMostRoot.equals(virtualFile) && (relative = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)outerMostRoot, (char)'/')) != null) {
            return relative;
        }
        return virtualFile.getPath();
    }
}

