/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.util.ObjectUtils;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class JavaTemplateUtil {
    public static final String TEMPLATE_CATCH_BODY = "Catch Statement Body.java";
    public static final String TEMPLATE_CATCH_DECLARATION = "Catch Statement Declaration.java";
    public static final String TEMPLATE_SWITCH_DEFAULT_BRANCH = "Switch Default Branch.java";
    public static final String TEMPLATE_IMPLEMENTED_METHOD_BODY = "Implemented Method Body.java";
    public static final String TEMPLATE_OVERRIDDEN_METHOD_BODY = "Overridden Method Body.java";
    public static final String TEMPLATE_FROM_USAGE_METHOD_BODY = "New Method Body.java";
    public static final String TEMPLATE_I18NIZED_EXPRESSION = "I18nized Expression.java";
    public static final String TEMPLATE_I18NIZED_CONCATENATION = "I18nized Concatenation.java";
    public static final String TEMPLATE_I18NIZED_JSP_EXPRESSION = "I18nized JSP Expression.jsp";
    public static final String INTERNAL_CLASS_TEMPLATE_NAME = "Class";
    public static final String INTERNAL_INTERFACE_TEMPLATE_NAME = "Interface";
    public static final String INTERNAL_ANNOTATION_TYPE_TEMPLATE_NAME = "AnnotationType";
    public static final String INTERNAL_ENUM_TEMPLATE_NAME = "Enum";
    public static final String[] INTERNAL_CLASS_TEMPLATES = new String[]{"Class", "Interface", "AnnotationType", "Enum"};
    public static final String INTERNAL_PACKAGE_INFO_TEMPLATE_NAME = "package-info";
    public static final String INTERNAL_MODULE_INFO_TEMPLATE_NAME = "module-info";
    public static final String[] INTERNAL_FILE_TEMPLATES = new String[]{"package-info", "module-info"};

    private JavaTemplateUtil() {
    }

    public static void setClassAndMethodNameProperties(@NotNull Properties properties, @NotNull PsiClass aClass, @NotNull PsiMethod method) {
        properties.setProperty("CLASS_NAME", (String)ObjectUtils.notNull((Object)aClass.getQualifiedName(), (Object)""));
        properties.setProperty("SIMPLE_CLASS_NAME", (String)ObjectUtils.notNull((Object)aClass.getName(), (Object)""));
        properties.setProperty("METHOD_NAME", method.getName());
    }

    @NotNull
    public static String getPackageName(@NotNull PsiDirectory directory) {
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        return aPackage != null ? aPackage.getQualifiedName() : "";
    }

    public static void setPackageNameAttribute(@NotNull Properties properties, @NotNull PsiDirectory directory) {
        properties.setProperty("PACKAGE_NAME", JavaTemplateUtil.getPackageName(directory));
    }
}

