/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CalleeMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CalleeMethodsTreeStructure(@NotNull Project project, @NotNull PsiMethod method, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new CallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        if (!(enclosingElement instanceof PsiMethod)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiMethod method = (PsiMethod)enclosingElement;
        ArrayList methods = new ArrayList();
        PsiCodeBlock body2 = method.getBody();
        if (body2 != null) {
            CalleeMethodsTreeStructure.visitor((PsiElement)body2, methods);
        }
        PsiMethod baseMethod = (PsiMethod)((CallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
        PsiClass baseClass = baseMethod.getContainingClass();
        HashMap<PsiMethod, CallHierarchyNodeDescriptor> methodToDescriptorMap = new HashMap<PsiMethod, CallHierarchyNodeDescriptor>();
        ArrayList<CallHierarchyNodeDescriptor> result = new ArrayList<CallHierarchyNodeDescriptor>();
        Iterable methodsToAdd = ContainerUtil.concat((Iterable[])new Iterable[]{methods, OverridingMethodsSearch.search((PsiMethod)method)});
        for (PsiMethod calledMethod : methodsToAdd) {
            if (!this.isInScope((PsiElement)baseClass, (PsiElement)calledMethod, this.myScopeType)) continue;
            CallHierarchyNodeDescriptor d = (CallHierarchyNodeDescriptor)((Object)methodToDescriptorMap.get(calledMethod));
            if (d == null) {
                d = new CallHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)calledMethod, false, false);
                methodToDescriptorMap.put(calledMethod, d);
                result.add(d);
                continue;
            }
            d.incrementUsageCount();
        }
        return ArrayUtil.toObjectArray(result);
    }

    private static void visitor(PsiElement element, List<? super PsiMethod> methods) {
        PsiElement[] children;
        for (PsiElement child : children = element.getChildren()) {
            PsiElement method;
            CalleeMethodsTreeStructure.visitor(child, methods);
            if (child instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)child;
                PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
                PsiMethod method2 = (PsiMethod)methodExpression.resolve();
                if (method2 == null) continue;
                methods.add((PsiMethod)method2);
                continue;
            }
            if (child instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)child;
                PsiMethod method3 = newExpression.resolveConstructor();
                if (method3 == null) continue;
                methods.add((PsiMethod)method3);
                continue;
            }
            if (!(child instanceof PsiMethodReferenceExpression) || !((method = ((PsiMethodReferenceExpression)child).resolve()) instanceof PsiMethod)) continue;
            methods.add((PsiMethod)((PsiMethod)method));
        }
    }
}

