/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallReferenceProcessor;
import com.intellij.ide.hierarchy.call.JavaCallHierarchyData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class CallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public CallerMethodsTreeStructure(@NotNull Project project, @NotNull PsiMethod method, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new CallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiClass clazz;
        PsiMember enclosingElement = ((CallHierarchyNodeDescriptor)descriptor).getEnclosingElement();
        HierarchyNodeDescriptor nodeDescriptor = this.getBaseDescriptor();
        if (enclosingElement instanceof PsiMethod && CallerMethodsTreeStructure.isLocalOrAnonymousClass((PsiMember)(clazz = enclosingElement.getContainingClass()))) {
            PsiElement grandParent;
            PsiElement parent = clazz.getParent();
            PsiElement psiElement = grandParent = parent instanceof PsiNewExpression ? parent.getParent() : null;
            if (grandParent instanceof PsiExpressionList) {
                enclosingElement = CallHierarchyNodeDescriptor.getEnclosingElement(grandParent);
            }
        }
        if (!(enclosingElement instanceof PsiMethod) || nodeDescriptor == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiMethod baseMethod = (PsiMethod)((CallHierarchyNodeDescriptor)nodeDescriptor).getTargetElement();
        if (baseMethod == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        SearchScope searchScope = this.getSearchScope(this.myScopeType, (PsiElement)baseMethod.getContainingClass());
        PsiMethod method = (PsiMethod)enclosingElement;
        PsiClass originalClass = method.getContainingClass();
        assert (originalClass != null);
        PsiClassType originalType = JavaPsiFacade.getElementFactory((Project)this.myProject).createType(originalClass);
        HashSet<PsiMethod> methodsToFind = new HashSet<PsiMethod>();
        methodsToFind.add(method);
        ContainerUtil.addAll(methodsToFind, (Object[])method.findDeepestSuperMethods());
        HashMap methodToDescriptorMap = new HashMap();
        for (PsiMethod methodToFind : methodsToFind) {
            JavaCallHierarchyData data = new JavaCallHierarchyData(originalClass, methodToFind, originalType, method, methodsToFind, (NodeDescriptor)descriptor, methodToDescriptorMap, this.myProject);
            MethodReferencesSearch.search((PsiMethod)methodToFind, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                for (CallReferenceProcessor processor : (CallReferenceProcessor[])CallReferenceProcessor.EP_NAME.getExtensions()) {
                    if (!processor.process(reference, data)) break;
                }
                return true;
            });
        }
        return ArrayUtil.toObjectArray(methodToDescriptorMap.values());
    }

    private static boolean isLocalOrAnonymousClass(PsiMember enclosingElement) {
        return enclosingElement instanceof PsiClass && ((PsiClass)enclosingElement).getQualifiedName() == null;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    public String toString() {
        return "Caller Hierarchy for " + this.formatBaseElementText();
    }
}

