/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.call.CallHierarchyBrowser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JavaCallHierarchyProvider
implements HierarchyProvider {
    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        return new CallHierarchyBrowser(target.getProject(), (PsiMethod)target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        ((CallHierarchyBrowser)hierarchyBrowser).changeView(CallHierarchyBrowserBase.CALLER_TYPE);
    }
}

