/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.hierarchy.HierarchyBrowser;
import com.intellij.ide.hierarchy.HierarchyProvider;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.TypeHierarchyBrowser;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiSyntheticClass;
import org.jetbrains.annotations.NotNull;

public class JavaTypeHierarchyProvider
implements HierarchyProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.type.JavaTypeHierarchyProvider");

    public PsiElement getTarget(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (LOG.isDebugEnabled()) {
            LOG.debug("editor " + editor);
        }
        if (editor != null) {
            PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file == null) {
                return null;
            }
            PsiElement targetElement = TargetElementUtil.findTargetElement((Editor)editor, (int)11);
            if (LOG.isDebugEnabled()) {
                LOG.debug("target element " + targetElement);
            }
            if (targetElement instanceof PsiClass) {
                return targetElement;
            }
            int offset = editor.getCaretModel().getOffset();
            for (PsiElement element = file.findElementAt(offset); element != null; element = element.getParent()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("context element " + element);
                }
                if (element instanceof PsiFile) {
                    if (!(element instanceof PsiClassOwner)) {
                        return null;
                    }
                    PsiClass[] classes2 = ((PsiClassOwner)element).getClasses();
                    return classes2.length == 1 ? classes2[0] : null;
                }
                if (!(element instanceof PsiClass) || element instanceof PsiAnonymousClass || element instanceof PsiSyntheticClass) continue;
                return element;
            }
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return element instanceof PsiClass ? (PsiClass)element : null;
    }

    @NotNull
    public HierarchyBrowser createHierarchyBrowser(@NotNull PsiElement target) {
        return new TypeHierarchyBrowser(target.getProject(), (PsiClass)target);
    }

    public void browserActivated(@NotNull HierarchyBrowser hierarchyBrowser) {
        TypeHierarchyBrowser browser = (TypeHierarchyBrowser)hierarchyBrowser;
        String typeName = browser.isInterface() ? TypeHierarchyBrowserBase.SUBTYPES_HIERARCHY_TYPE : TypeHierarchyBrowserBase.TYPE_HIERARCHY_TYPE;
        browser.changeView(typeName);
    }
}

