/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class SubtypesHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myCurrentScopeType;

    protected SubtypesHierarchyTreeStructure(Project project, HierarchyNodeDescriptor descriptor, String currentScopeType) {
        super(project, descriptor);
        this.myCurrentScopeType = currentScopeType;
    }

    public SubtypesHierarchyTreeStructure(Project project, PsiClass psiClass, String currentScopeType) {
        super(project, (HierarchyNodeDescriptor)new TypeHierarchyNodeDescriptor(project, null, (PsiElement)psiClass, true));
        this.myCurrentScopeType = currentScopeType;
    }

    @NotNull
    protected final Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PsiElement element = ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
        if (!(element instanceof PsiClass)) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        PsiClass psiClass = (PsiClass)element;
        if ("java.lang.Object".equals(psiClass.getQualifiedName())) {
            return new Object[]{IdeBundle.message((String)"node.hierarchy.java.lang.object", (Object[])new Object[0])};
        }
        if (psiClass instanceof PsiAnonymousClass) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        if (psiClass.hasModifierProperty("final")) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        SearchScope searchScope = psiClass.getUseScope().intersectWith(this.getSearchScope(this.myCurrentScopeType, (PsiElement)psiClass));
        ArrayList<PsiClass> classes2 = new ArrayList<PsiClass>(SubtypesHierarchyTreeStructure.searchInheritors(psiClass, searchScope));
        ArrayList<TypeHierarchyNodeDescriptor> descriptors = new ArrayList<TypeHierarchyNodeDescriptor>(classes2.size());
        for (PsiClass aClass : classes2) {
            descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)aClass, false));
        }
        FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)searchScope).forEach(expression2 -> {
            descriptors.add(new TypeHierarchyNodeDescriptor(this.myProject, descriptor, (PsiElement)expression2, false));
            return true;
        });
        return descriptors.toArray(new HierarchyNodeDescriptor[0]);
    }

    @NotNull
    private static Collection<PsiClass> searchInheritors(@NotNull PsiClass psiClass, @NotNull SearchScope searchScope) {
        if (psiClass.isAnnotationType()) {
            HashSet result = ContainerUtil.newHashSet();
            AnnotatedElementsSearch.searchPsiClasses((PsiClass)psiClass, (SearchScope)searchScope).forEach(processorResult -> {
                if (processorResult.isAnnotationType()) {
                    result.add(processorResult);
                }
                return true;
            });
            return result;
        }
        return ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)searchScope, (boolean)false).findAll();
    }
}

