/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy.type;

import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.TypeHierarchyBrowserBase;
import com.intellij.ide.hierarchy.type.SubtypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.SupertypesHierarchyTreeStructure;
import com.intellij.ide.hierarchy.type.TypeHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.type.TypeHierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.presentation.java.ClassPresentationUtil;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeHierarchyBrowser
extends TypeHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.type.TypeHierarchyBrowser");

    public TypeHierarchyBrowser(Project project, PsiClass psiClass) {
        super(project, (PsiElement)psiClass);
    }

    protected boolean isInterface(@NotNull PsiElement psiElement) {
        return psiElement instanceof PsiClass && ((PsiClass)psiElement).isInterface();
    }

    protected void createTrees(@NotNull Map<String, JTree> trees) {
        this.createTreeAndSetupCommonActions(trees, "TypeHierarchyPopupMenu");
    }

    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        super.prependActions(actionGroup);
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.ChangeScopeAction(){

            protected boolean isEnabled() {
                return !Comparing.strEqual((String)TypeHierarchyBrowser.this.getCurrentViewType(), (String)TypeHierarchyBrowserBase.SUPERTYPES_HIERARCHY_TYPE);
            }
        });
    }

    protected String getContentDisplayName(@NotNull String typeName, @NotNull PsiElement element) {
        return MessageFormat.format(typeName, ClassPresentationUtil.getNameForClass((PsiClass)element, false));
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (!(descriptor instanceof TypeHierarchyNodeDescriptor)) {
            return null;
        }
        return ((TypeHierarchyNodeDescriptor)descriptor).getPsiClass();
    }

    @Nullable
    protected JPanel createLegendPanel() {
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        return element instanceof PsiClass;
    }

    protected boolean isApplicableElementForBaseOn(@NotNull PsiElement element) {
        return element instanceof PsiClass && !"java.lang.Object".equals(((PsiClass)element).getQualifiedName());
    }

    protected Comparator<NodeDescriptor> getComparator() {
        return JavaHierarchyUtil.getComparator(this.myProject);
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (SUPERTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new SupertypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement);
        }
        if (SUBTYPES_HIERARCHY_TYPE.equals(typeName)) {
            return new SubtypesHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        if (TYPE_HIERARCHY_TYPE.equals(typeName)) {
            return new TypeHierarchyTreeStructure(this.myProject, (PsiClass)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected boolean canBeDeleted(PsiElement psiElement) {
        return psiElement instanceof PsiClass && !(psiElement instanceof PsiAnonymousClass);
    }

    protected String getQualifiedName(PsiElement psiElement) {
        if (psiElement instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName();
        }
        return "";
    }
}

