/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class UnmarkGeneratedSourceRootAction
extends MarkRootActionBase {
    public UnmarkGeneratedSourceRootAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        ModuleSourceRootEditHandler handler = ModuleSourceRootEditHandler.getEditHandler((JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
        if (handler == null) {
            return;
        }
        String typeName = handler.getFullRootTypeName();
        presentation.setText("Unmark Generated " + typeName);
        presentation.setDescription("Mark directory as an ordinary " + typeName.toLowerCase(Locale.getDefault()));
    }

    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        for (SourceFolder root : selection.mySelectedRoots) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)root.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties == null || !properties.isForGeneratedSources()) continue;
            return true;
        }
        return false;
    }

    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        entry.addSourceFolder(vFile, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
    }
}

