/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.SelectableTreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ClassTreeNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.util.ClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class ClassesTreeStructureProvider
implements SelectableTreeStructureProvider,
DumbAware {
    private final Project myProject;

    public ClassesTreeStructureProvider(@NotNull Project project) {
        this.myProject = project;
    }

    @NotNull
    public Collection<AbstractTreeNode> modify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children, ViewSettings settings) {
        return (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> this.doModify(parent, children));
    }

    @NotNull
    private Collection<AbstractTreeNode> doModify(@NotNull AbstractTreeNode parent, @NotNull Collection<AbstractTreeNode> children) {
        ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>();
        for (AbstractTreeNode child : children) {
            ProgressManager.checkCanceled();
            Object o = child.getValue();
            if (o instanceof PsiClassOwner && !(o instanceof ServerPageFile)) {
                ViewSettings settings1 = ((ProjectViewNode)parent).getSettings();
                PsiClassOwner classOwner = (PsiClassOwner)o;
                VirtualFile file = classOwner.getVirtualFile();
                if (!(classOwner instanceof PsiCompiledElement)) {
                    PsiFile classFile;
                    VirtualFile virtualClassFile;
                    PsiElement originalElement;
                    ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
                    if (file != null && fileIndex.isInLibrarySource(file) && (originalElement = classOwner.getOriginalElement()) instanceof PsiFile && (virtualClassFile = (classFile = (PsiFile)originalElement).getVirtualFile()) != null && fileIndex.isInLibraryClasses(virtualClassFile) && !classOwner.getManager().areElementsEquivalent((PsiElement)classOwner, (PsiElement)classFile) && classOwner.getManager().areElementsEquivalent((PsiElement)classOwner.getContainingDirectory(), (PsiElement)classFile.getContainingDirectory())) continue;
                }
                if (this.fileInRoots(file)) {
                    PsiClass[] classes2 = (PsiClass[])ReadAction.compute(() -> ((PsiClassOwner)classOwner).getClasses());
                    if (classes2.length == 1 && ClassesTreeStructureProvider.isClassForTreeNode(file, classes2[0])) {
                        result.add((AbstractTreeNode)new ClassTreeNode(this.myProject, classes2[0], settings1, child.getChildren()));
                        continue;
                    }
                    result.add((AbstractTreeNode)new PsiClassOwnerTreeNode(classOwner, settings1, child.getChildren()));
                    continue;
                }
            }
            result.add(child);
        }
        return result;
    }

    private static boolean isClassForTreeNode(VirtualFile file, PsiClass psiClass) {
        if (psiClass == null || psiClass instanceof SyntheticElement) {
            return false;
        }
        if (file == null || file.getNameWithoutExtension().equals(psiClass.getName())) {
            return true;
        }
        Project project = psiClass.getProject();
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors(file)) {
            if (!(fileEditor instanceof TextEditor)) continue;
            TextEditor textEditor = (TextEditor)fileEditor;
            Template template = TemplateManager.getInstance((Project)project).getActiveTemplate(textEditor.getEditor());
            if (template == null) continue;
            return true;
        }
        return false;
    }

    private boolean fileInRoots(VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        return file != null && (index.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || index.isInLibrary(file));
    }

    public PsiElement getTopLevelElement(PsiElement element) {
        PsiClass[] classes2;
        PsiElement current;
        PsiFile baseRootFile = ClassesTreeStructureProvider.getBaseRootFile(element);
        if (baseRootFile == null) {
            return null;
        }
        if (!this.fileInRoots(baseRootFile.getVirtualFile())) {
            return baseRootFile;
        }
        for (current = element; current != null && !ClassesTreeStructureProvider.isSelectable(current) && !ClassesTreeStructureProvider.isTopLevelClass(current); current = current.getParent()) {
        }
        if (current instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)current).getClasses()).length == 1 && !(classes2[0] instanceof SyntheticElement) && ClassesTreeStructureProvider.isTopLevelClass((PsiElement)classes2[0])) {
            current = classes2[0];
        }
        return current != null ? current : baseRootFile;
    }

    private static boolean isSelectable(PsiElement element) {
        if (element instanceof PsiFileSystemItem) {
            return true;
        }
        if (element instanceof PsiJavaModule) {
            return true;
        }
        if (element instanceof PsiField || element instanceof PsiClass || element instanceof PsiMethod) {
            return !(element instanceof PsiAnonymousClass) && !(element.getParent() instanceof PsiAnonymousClass);
        }
        return false;
    }

    @Nullable
    private static PsiFile getBaseRootFile(PsiElement element) {
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        return viewProvider.getPsi(viewProvider.getBaseLanguage());
    }

    private static boolean isTopLevelClass(PsiElement element) {
        return element instanceof PsiClass && ClassUtil.isTopLevelClass((PsiClass)((PsiClass)element));
    }

    private static class PsiClassOwnerTreeNode
    extends PsiFileNode {
        @NotNull
        private final Collection<? extends AbstractTreeNode> myMandatoryChildren;

        PsiClassOwnerTreeNode(@NotNull PsiClassOwner classOwner, ViewSettings settings, @NotNull Collection<? extends AbstractTreeNode> mandatoryChildren) {
            super(classOwner.getProject(), (PsiFile)classOwner, settings);
            this.myMandatoryChildren = mandatoryChildren;
        }

        public Collection<AbstractTreeNode> getChildrenImpl() {
            ArrayList<AbstractTreeNode> result = new ArrayList<AbstractTreeNode>(this.myMandatoryChildren);
            PsiFile value2 = (PsiFile)this.getValue();
            if (value2 instanceof PsiClassOwner) {
                ViewSettings settings = this.getSettings();
                for (PsiClass aClass : ((PsiClassOwner)value2).getClasses()) {
                    if (aClass instanceof SyntheticElement) continue;
                    result.add((AbstractTreeNode)new ClassTreeNode(this.myProject, aClass, settings));
                }
            }
            return result;
        }
    }
}

