/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.impl.PackagesPaneSelectInTarget;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewImpl;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.ShowModulesAction;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewProjectNode;
import com.intellij.ide.util.DeleteHandler;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUpdater;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageViewPane
extends AbstractProjectViewPSIPane {
    @NonNls
    public static final String ID = "PackagesPane";
    private final MyDeletePSIElementProvider myDeletePSIElementProvider = new MyDeletePSIElementProvider();

    public PackageViewPane(Project project) {
        super(project);
    }

    @NotNull
    public String getTitle() {
        return IdeBundle.message((String)"title.packages", (Object[])new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.Nodes.CopyOfFolder;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public List<PsiElement> getElementsFromNode(@Nullable Object node) {
        Object o = this.getValueFromNode(node);
        if (o instanceof PackageElement) {
            PsiPackage aPackage = ((PackageElement)o).getPackage();
            return ContainerUtil.createMaybeSingletonList((Object)(aPackage.isValid() ? aPackage : null));
        }
        return super.getElementsFromNode(node);
    }

    protected Module getNodeModule(@Nullable Object element) {
        if (element instanceof PackageElement) {
            return ((PackageElement)element).getModule();
        }
        return super.getNodeModule(element);
    }

    public Object getData(@NotNull String dataId) {
        PackageElement packageElement;
        PackageElement selectedPackageElement;
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) && (selectedPackageElement = this.getSelectedPackageElement()) != null) {
            return this.myDeletePSIElementProvider;
        }
        if (PackageElement.DATA_KEY.is(dataId)) {
            selectedPackageElement = this.getSelectedPackageElement();
        }
        if (LangDataKeys.MODULE.is(dataId) && (packageElement = this.getSelectedPackageElement()) != null) {
            return packageElement.getModule();
        }
        return super.getData(dataId);
    }

    @Nullable
    private PackageElement getSelectedPackageElement() {
        AbstractTreeNode node = (AbstractTreeNode)TreeUtil.getLastUserObject(AbstractTreeNode.class, (TreePath)this.getSelectedPath());
        Object selected = node == null ? null : node.getValue();
        return selected instanceof PackageElement ? (PackageElement)selected : null;
    }

    @NotNull
    public PsiDirectory[] getSelectedDirectories() {
        ArrayList directories = ContainerUtil.newArrayList();
        for (PackageElementNode node : this.getSelectedNodes(PackageElementNode.class)) {
            PsiPackage parentNodePackage;
            Module module;
            PackageElement packageElement = (PackageElement)node.getValue();
            PsiPackage aPackage = packageElement != null ? packageElement.getPackage() : null;
            Module module2 = module = packageElement != null ? packageElement.getModule() : null;
            if (aPackage == null || module == null) continue;
            GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)module);
            Collections.addAll(directories, aPackage.getDirectories(scope));
            if (!Registry.is((String)"projectView.choose.directory.on.compacted.middle.packages")) continue;
            Object parentValue = node.getParent().getValue();
            PsiPackage psiPackage = parentNodePackage = parentValue instanceof PackageElement ? ((PackageElement)parentValue).getPackage() : null;
            while ((aPackage = aPackage.getParentPackage()) != null && !aPackage.getQualifiedName().isEmpty() && !aPackage.equals(parentNodePackage)) {
                Collections.addAll(directories, aPackage.getDirectories(scope));
            }
        }
        if (!directories.isEmpty()) {
            return directories.toArray(PsiDirectory.EMPTY_ARRAY);
        }
        return super.getSelectedDirectories();
    }

    public void addToolbarActions(@NotNull DefaultActionGroup actionGroup) {
        actionGroup.addAction((AnAction)new ShowModulesAction(this.myProject, ID)).setAsSecondary(true);
        actionGroup.addAction((AnAction)this.createFlattenModulesAction(() -> true)).setAsSecondary(true);
        actionGroup.addAction((AnAction)new ShowLibraryContentsAction()).setAsSecondary(true);
        AnAction editScopesAction = ActionManager.getInstance().getAction("ScopeView.EditScopes");
        if (editScopesAction != null) {
            actionGroup.addAction(editScopesAction).setAsSecondary(true);
        }
    }

    @NotNull
    protected AbstractTreeUpdater createTreeUpdater(@NotNull AbstractTreeBuilder treeBuilder) {
        return new PackageViewTreeUpdater(treeBuilder);
    }

    @NotNull
    public SelectInTarget createSelectInTarget() {
        return new PackagesPaneSelectInTarget(this.myProject);
    }

    @NotNull
    protected ProjectAbstractTreeStructureBase createStructure() {
        return new ProjectTreeStructure(this.myProject, ID){

            protected AbstractTreeNode createRoot(@NotNull Project project, @NotNull ViewSettings settings) {
                return new PackageViewProjectNode(project, settings);
            }

            public boolean isToBuildChildrenInBackground(@NotNull Object element) {
                return Registry.is((String)"ide.projectView.PackageViewTreeStructure.BuildChildrenInBackground");
            }
        };
    }

    @NotNull
    protected ProjectViewTree createTree(@NotNull DefaultTreeModel treeModel) {
        return new ProjectViewTree(treeModel){

            public String toString() {
                return PackageViewPane.this.getTitle() + " " + super.toString();
            }
        };
    }

    @NotNull
    public String getComponentName() {
        return ID;
    }

    public int getWeight() {
        return 1;
    }

    protected BaseProjectTreeBuilder createBuilder(@NotNull DefaultTreeModel model) {
        return null;
    }

    private final class MyDeletePSIElementProvider
    implements DeleteProvider {
        private MyDeletePSIElementProvider() {
        }

        public boolean canDeleteElement(@NotNull DataContext dataContext) {
            for (PsiDirectory directory : PackageViewPane.this.getSelectedDirectories()) {
                if (directory.getManager().isInProject((PsiElement)directory)) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deleteElement(@NotNull DataContext dataContext) {
            PsiDirectory[] allElements = PackageViewPane.this.getSelectedDirectories();
            ArrayList<PsiDirectory> validElements = new ArrayList<PsiDirectory>();
            for (PsiDirectory psiElement : allElements) {
                if (psiElement == null || !psiElement.isValid()) continue;
                validElements.add(psiElement);
            }
            PsiElement[] elements = PsiUtilCore.toPsiElementArray(validElements);
            LocalHistoryAction a = LocalHistory.getInstance().startAction(IdeBundle.message((String)"progress.deleting", (Object[])new Object[0]));
            try {
                DeleteHandler.deletePsiElement((PsiElement[])elements, (Project)PackageViewPane.this.myProject);
            }
            finally {
                a.finish();
            }
        }
    }

    private final class PackageViewTreeUpdater
    extends AbstractTreeUpdater {
        private PackageViewTreeUpdater(AbstractTreeBuilder treeBuilder) {
            super(treeBuilder);
        }

        public boolean addSubtreeToUpdateByElement(@NotNull Object element) {
            if (element instanceof PsiDirectory) {
                PsiDirectory dir = (PsiDirectory)element;
                PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(dir);
                if (ProjectView.getInstance((Project)PackageViewPane.this.myProject).isShowModules(PackageViewPane.this.getId())) {
                    Module[] modules = this.getModulesFor(dir);
                    boolean rv = false;
                    for (Module module : modules) {
                        rv |= this.addPackageElementToUpdate(aPackage, module);
                    }
                    return rv;
                }
                return this.addPackageElementToUpdate(aPackage, null);
            }
            return super.addSubtreeToUpdateByElement(element);
        }

        private boolean addPackageElementToUpdate(PsiPackage aPackage, Module module) {
            boolean addedOk;
            PsiPackage packageToUpdateFrom;
            ProjectTreeStructure packageTreeStructure = (ProjectTreeStructure)PackageViewPane.this.myTreeStructure;
            if (!packageTreeStructure.isFlattenPackages() && packageTreeStructure.isHideEmptyMiddlePackages()) {
                for (packageToUpdateFrom = aPackage; packageToUpdateFrom != null && packageToUpdateFrom.isValid() && PackageUtil.isPackageEmpty(packageToUpdateFrom, module, true, false); packageToUpdateFrom = packageToUpdateFrom.getParentPackage()) {
                }
            }
            while (!(addedOk = super.addSubtreeToUpdateByElement(this.getTreeElementToUpdateFrom(packageToUpdateFrom, module))) && packageToUpdateFrom != null) {
                packageToUpdateFrom = packageToUpdateFrom.getParentPackage();
            }
            return addedOk;
        }

        @NotNull
        private Object getTreeElementToUpdateFrom(PsiPackage packageToUpdateFrom, Module module) {
            if (packageToUpdateFrom == null || !packageToUpdateFrom.isValid() || "".equals(packageToUpdateFrom.getQualifiedName())) {
                return module == null ? PackageViewPane.this.myTreeStructure.getRootElement() : module;
            }
            return new PackageElement(module, packageToUpdateFrom, false);
        }

        private Module[] getModulesFor(PsiDirectory dir) {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)PackageViewPane.this.myProject).getFileIndex();
            VirtualFile vFile = dir.getVirtualFile();
            HashSet<Module> modules = new HashSet<Module>();
            Module module = fileIndex.getModuleForFile(vFile);
            if (module != null) {
                modules.add(module);
            }
            if (fileIndex.isInLibrary(vFile)) {
                List orderEntries = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries.isEmpty()) {
                    return Module.EMPTY_ARRAY;
                }
                for (OrderEntry entry : orderEntries) {
                    modules.add(entry.getOwnerModule());
                }
            }
            return modules.toArray(Module.EMPTY_ARRAY);
        }
    }

    private final class ShowLibraryContentsAction
    extends ToggleAction {
        private ShowLibraryContentsAction() {
            super(IdeBundle.message((String)"action.show.libraries.contents", (Object[])new Object[0]), IdeBundle.message((String)"action.show.hide.library.contents", (Object[])new Object[0]), AllIcons.ObjectBrowser.ShowLibraryContents);
        }

        public boolean isSelected(@NotNull AnActionEvent event) {
            return ProjectView.getInstance((Project)PackageViewPane.this.myProject).isShowLibraryContents(PackageViewPane.this.getId());
        }

        public void setSelected(@NotNull AnActionEvent event, boolean flag) {
            ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance((Project)PackageViewPane.this.myProject);
            projectView.setShowLibraryContents(PackageViewPane.this.getId(), flag);
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            Presentation presentation = e.getPresentation();
            ProjectViewImpl projectView = (ProjectViewImpl)ProjectView.getInstance((Project)PackageViewPane.this.myProject);
            presentation.setVisible(projectView.getCurrentProjectViewPane() == PackageViewPane.this);
        }
    }
}

