/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PackageElement;
import com.intellij.ide.projectView.impl.nodes.PackageElementNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.TreeViewUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageUtil {
    @NotNull
    static PsiPackage[] getSubpackages(@NotNull PsiPackage aPackage, @Nullable Module module, boolean searchInLibraries) {
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, searchInLibraries);
        ArrayList<PsiPackage> result = new ArrayList<PsiPackage>();
        for (PsiPackage psiPackage : aPackage.getSubPackages(scopeToShow)) {
            String name = psiPackage.getName();
            if (name == null || name.isEmpty()) continue;
            result.add(psiPackage);
        }
        return result.toArray(PsiPackage.EMPTY_ARRAY);
    }

    static void addPackageAsChild(@NotNull Collection<? super AbstractTreeNode> children, @NotNull PsiPackage aPackage, @Nullable Module module, @NotNull ViewSettings settings, boolean inLibrary) {
        boolean shouldSkipPackage = settings.isHideEmptyMiddlePackages() && PackageUtil.isPackageEmpty(aPackage, module, !settings.isFlattenPackages(), inLibrary);
        Project project = aPackage.getProject();
        if (!shouldSkipPackage) {
            children.add((AbstractTreeNode)new PackageElementNode(project, new PackageElement(module, aPackage, inLibrary), settings));
        }
        if (settings.isFlattenPackages() || shouldSkipPackage) {
            PsiPackage[] subpackages;
            for (PsiPackage subpackage : subpackages = PackageUtil.getSubpackages(aPackage, module, inLibrary)) {
                PackageUtil.addPackageAsChild(children, subpackage, module, settings, inLibrary);
            }
        }
    }

    public static boolean isPackageEmpty(@NotNull PsiPackage aPackage, @Nullable Module module, boolean strictlyEmpty, boolean inLibrary) {
        Project project = aPackage.getProject();
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(project, module, inLibrary);
        PsiFile[] children = aPackage.getFiles(scopeToShow);
        if (children.length > 0) {
            return false;
        }
        PsiPackage[] subPackages = aPackage.getSubPackages(scopeToShow);
        if (strictlyEmpty) {
            return subPackages.length == 1;
        }
        return subPackages.length > 0;
    }

    @NotNull
    public static PsiDirectory[] getDirectories(@NotNull PsiPackage aPackage, @Nullable Module module, boolean inLibrary) {
        GlobalSearchScope scopeToShow = PackageUtil.getScopeToShow(aPackage.getProject(), module, inLibrary);
        return aPackage.getDirectories(scopeToShow);
    }

    @NotNull
    static GlobalSearchScope getScopeToShow(@NotNull Project project, @Nullable Module module, boolean forLibraries) {
        if (module == null) {
            if (forLibraries) {
                return new ProjectLibrariesSearchScope(project);
            }
            return GlobalSearchScope.projectScope((Project)project);
        }
        if (forLibraries) {
            return new ModuleLibrariesSearchScope(module);
        }
        return GlobalSearchScope.moduleScope((Module)module);
    }

    public static boolean isPackageDefault(@NotNull PsiPackage directoryPackage) {
        String qName = directoryPackage.getQualifiedName();
        return qName.isEmpty();
    }

    @NotNull
    static Collection<AbstractTreeNode> createPackageViewChildrenOnFiles(@NotNull List<? extends VirtualFile> sourceRoots, @NotNull Project project, @NotNull ViewSettings settings, @Nullable Module module, boolean inLibrary) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile virtualFile : sourceRoots) {
            ProgressManager.checkCanceled();
            PsiDirectory directory = psiManager.findDirectory(virtualFile);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance((Project)project).getDirectoryChildren(directory, settings, false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage psiPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, psiPackage, module, settings, inLibrary);
        }
        return children;
    }

    @NotNull
    public static String getNodeName(@NotNull ViewSettings settings, PsiPackage aPackage, PsiPackage parentPackageInTree, @NotNull String defaultShortName, boolean isFQNameShown) {
        String name;
        if (isFQNameShown) {
            name = settings.isAbbreviatePackageNames() ? (aPackage == null ? defaultShortName : TreeViewUtil.calcAbbreviatedPackageFQName(aPackage)) : (aPackage == null ? defaultShortName : aPackage.getQualifiedName());
        } else if (parentPackageInTree != null || aPackage != null && aPackage.getParentPackage() != null) {
            String parentPackageName;
            if (parentPackageInTree != null && aPackage != null) {
                String prefix = parentPackageInTree.getQualifiedName();
                String string = aPackage.getQualifiedName();
                int length = prefix.length();
                if (length == 0) {
                    if (!string.isEmpty()) {
                        return string;
                    }
                } else if (string.startsWith(prefix)) {
                    if (length < string.length() && '.' == string.charAt(length)) {
                        ++length;
                    }
                    if (length < string.length()) {
                        return string.substring(length);
                    }
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append(aPackage.getName());
            for (PsiPackage parentPackage = aPackage.getParentPackage(); parentPackage != null && !parentPackage.equals(parentPackageInTree) && (parentPackageName = parentPackage.getName()) != null && !parentPackageName.isEmpty(); parentPackage = parentPackage.getParentPackage()) {
                buf.insert(0, ".");
                buf.insert(0, parentPackageName);
            }
            name = buf.toString();
        } else {
            name = defaultShortName;
        }
        return name;
    }

    private static class ProjectLibrariesSearchScope
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        ProjectLibrariesSearchScope(@NotNull Project project) {
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        }

        public boolean contains(@NotNull VirtualFile file) {
            return this.myFileIndex.isInLibraryClasses(file);
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }

    private static class ModuleLibrariesSearchScope
    extends GlobalSearchScope {
        private final Module myModule;

        ModuleLibrariesSearchScope(@NotNull Module module) {
            super(module.getProject());
            this.myModule = module;
        }

        public boolean contains(@NotNull VirtualFile file) {
            OrderEntry orderEntry = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex().getOrderEntryForFile(file);
            return orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)this.myModule).getFileIndex();
            return Comparing.compare((Comparable)fileIndex.getOrderEntryForFile(file2), (Comparable)fileIndex.getOrderEntryForFile(file1));
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return false;
        }

        public boolean isSearchInLibraries() {
            return true;
        }
    }
}

