/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.AbstractModuleNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewLibrariesNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeUi;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageViewModuleNode
extends AbstractModuleNode {
    public PackageViewModuleNode(Project project, @NotNull Module value2, ViewSettings viewSettings) {
        super(project, value2, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        return (Collection)AbstractTreeUi.calculateYieldingToWriteAction(() -> {
            List<VirtualFile> roots = Arrays.asList(ModuleRootManager.getInstance((Module)((Module)this.getValue())).getSourceRoots());
            Collection<AbstractTreeNode> result = PackageUtil.createPackageViewChildrenOnFiles(roots, this.myProject, this.getSettings(), (Module)this.getValue(), false);
            if (this.getSettings().isShowLibraryContents()) {
                result.add((AbstractTreeNode)new PackageViewLibrariesNode(this.getProject(), (Module)this.getValue(), this.getSettings()));
            }
            return result;
        });
    }

    public boolean contains(@NotNull VirtualFile file) {
        Module module = (Module)this.getValue();
        return module != null && !module.isDisposed() && (ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file, (boolean)false) || ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)file, (boolean)true));
    }

    public boolean validate() {
        return this.getValue() != null;
    }

    public boolean someChildContainsFile(VirtualFile file) {
        return true;
    }

    public void update(PresentationData presentation) {
        super.update(presentation);
        Icon icon = this.getModuleIcon();
        if (icon != null) {
            presentation.setIcon(icon);
        }
    }

    @Nullable
    private Icon getModuleIcon() {
        Module module = (Module)this.getValue();
        if (module != null && !module.isDisposed()) {
            VirtualFile virtualFile = module.getModuleFile();
            Icon icon = null;
            if (virtualFile != null) {
                icon = IconUtil.getIcon((VirtualFile)virtualFile, (int)0, (Project)module.getProject());
            }
            if (icon == null) {
                icon = ModuleType.get((Module)module).getIcon();
            }
            return icon;
        }
        return null;
    }
}

