/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.SuperMethodWarningDialog;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    public static Key<PsiMethod[]> SIBLINGS = Key.create((String)"MULTIPLE_INHERITANCE");

    private SuperMethodWarningUtil() {
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return SuperMethodWarningUtil.checkSuperMethods(method, actionString, Collections.emptyList());
    }

    @NotNull
    public static PsiMethod[] getTargetMethodCandidates(@NotNull PsiMethod method, @NotNull Collection<PsiElement> ignore) {
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return new PsiMethod[]{method};
        }
        Collection<PsiMethod> superMethods = SuperMethodWarningUtil.getSuperMethods(method, aClass, ignore);
        if (superMethods.isEmpty()) {
            return new PsiMethod[]{method};
        }
        return superMethods.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method, @NotNull String actionString, @NotNull Collection<PsiElement> ignore) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiMethod[] methodTargetCandidates = SuperMethodWarningUtil.getTargetMethodCandidates(method, ignore);
        if (methodTargetCandidates.length == 1 && methodTargetCandidates[0] == method) {
            return methodTargetCandidates;
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : methodTargetCandidates) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        SuperMethodWarningDialog dialog = new SuperMethodWarningDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, superAbstract, parentInterface, method.getContainingClass().isInterface(), ArrayUtil.toStringArray(superClasses));
        dialog.show();
        if (dialog.getExitCode() == 0) {
            return methodTargetCandidates;
        }
        if (dialog.getExitCode() == 3) {
            return new PsiMethod[]{method};
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    static Collection<PsiMethod> getSuperMethods(@NotNull PsiMethod method, PsiClass aClass, @NotNull Collection<PsiElement> ignore) {
        VirtualFile virtualFile;
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method).findAll();
        superMethods.removeAll(ignore);
        if (superMethods.isEmpty() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass)) != null && ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInSourceContent(virtualFile)) {
            PsiMethod[] siblingSuperMethod = new PsiMethod[1];
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                siblingSuperMethod[0] = (PsiMethod)ReadAction.compute(() -> FindSuperElementsHelper.getSiblingInheritedViaSubClass(method));
            }, "Searching for sub-classes", true, aClass.getProject())) {
                throw new ProcessCanceledException();
            }
            if (siblingSuperMethod[0] != null) {
                superMethods.add(siblingSuperMethod[0]);
            }
        }
        return superMethods;
    }

    public static PsiMethod checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return method;
        }
        PsiMethod superMethod = method.findDeepestSuperMethod();
        if (superMethod == null) {
            return method;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        SuperMethodWarningDialog dialog = new SuperMethodWarningDialog(method.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        dialog.show();
        if (dialog.getExitCode() == 0) {
            return superMethod;
        }
        if (dialog.getExitCode() == 3) {
            return method;
        }
        return null;
    }

    public static void checkSuperMethod(@NotNull PsiMethod method, @NotNull String actionString, @NotNull PsiElementProcessor<? super PsiMethod> processor, @NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            processor.execute((PsiElement)method);
            return;
        }
        PsiMethod[] superMethods = method.findDeepestSuperMethods();
        if (superMethods.length == 0) {
            processor.execute((PsiElement)method);
            return;
        }
        PsiClass containingClass = superMethods[0].getContainingClass();
        if (containingClass == null) {
            processor.execute((PsiElement)method);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor.execute((PsiElement)superMethods[0]);
            return;
        }
        PsiMethod[] methods = new PsiMethod[]{superMethods[0], method};
        String renameBase = actionString + " base method" + (superMethods.length > 1 ? "s" : "");
        String renameCurrent = actionString + " only current method";
        String title = method.getName() + (superMethods.length > 1 ? " has super methods" : (containingClass.isInterface() && !aClass.isInterface() ? " implements" : " overrides") + " method of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass));
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])new String[]{renameBase, renameCurrent})).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(value2 -> {
            if (value2.equals(renameBase)) {
                try {
                    methods[0].putUserData(SIBLINGS, (Object)superMethods);
                    processor.execute((PsiElement)methods[0]);
                }
                finally {
                    methods[0].putUserData(SIBLINGS, null);
                }
            } else {
                processor.execute((PsiElement)methods[1]);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Messages.YesNoCancelResult
    public static int askWhetherShouldAnnotateBaseMethod(@NotNull PsiMethod method, @NotNull PsiMethod superMethod) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        String implement = !method.hasModifierProperty("abstract") && superMethod.hasModifierProperty("abstract") ? InspectionsBundle.message((String)"inspection.annotate.quickfix.implements", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.annotate.quickfix.overrides", (Object[])new Object[0]);
        String message2 = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.messages", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)method), implement, DescriptiveNameUtil.getDescriptiveName((PsiElement)superMethod)});
        String title = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.warning", (Object[])new Object[0]);
        return Messages.showYesNoCancelDialog((Project)method.getProject(), (String)message2, (String)title, (String)"Annotate", (String)"Don't Annotate", (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
    }
}

