/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarStatisticsService;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FUSLibraryJarUsagesCollector
extends ProjectUsagesCollector {
    private static final String DIGIT_VERSION_PATTERN_PART = "(\\d+.\\d+|\\d+)";
    private static final Pattern JAR_FILE_NAME_PATTERN = Pattern.compile("[\\w|\\-|\\.]+-((\\d+.\\d+|\\d+)[\\w|\\.]*)jar");

    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        LibraryJarDescriptor[] descriptors = LibraryJarStatisticsService.getInstance().getTechnologyDescriptors();
        HashSet result = new HashSet(descriptors.length);
        ApplicationManager.getApplication().runReadAction(() -> FUSLibraryJarUsagesCollector.lambda$getUsages$0(descriptors, project, (Set)result));
        return result;
    }

    @Nullable
    private static String getVersionByJarManifest(@NotNull VirtualFile file) {
        return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)file), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Nullable
    private static String getVersionByJarFileName(@NotNull String fileName) {
        Matcher fileNameMatcher = JAR_FILE_NAME_PATTERN.matcher(fileName);
        if (!fileNameMatcher.matches()) {
            return null;
        }
        return StringUtil.trimTrailing((String)fileNameMatcher.group(1), (char)'.');
    }

    @NotNull
    public String getGroupId() {
        return "javaLibraryJars";
    }

    private static /* synthetic */ void lambda$getUsages$0(LibraryJarDescriptor[] descriptors, Project project, Set result) {
        for (LibraryJarDescriptor descriptor : descriptors) {
            PsiClass[] psiClasses;
            String className = descriptor.myClass;
            if (className == null) continue;
            for (PsiClass psiClass : psiClasses = JavaPsiFacade.getInstance((Project)project).findClasses(className, ProjectScope.getLibrariesScope((Project)project))) {
                VirtualFile jarFile = JarFileSystem.getInstance().getVirtualFileForJar(psiClass.getContainingFile().getVirtualFile());
                if (jarFile == null) continue;
                String version = FUSLibraryJarUsagesCollector.getVersionByJarManifest(jarFile);
                if (version == null) {
                    version = FUSLibraryJarUsagesCollector.getVersionByJarFileName(jarFile.getName());
                }
                if (!StringUtil.isNotEmpty((String)version)) continue;
                result.add(new UsageDescriptor(descriptor.myName, 1, new FeatureUsageData().addOS().addVersionByString(version)));
            }
        }
    }
}

