/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.facet.frameworks.LibrariesDownloadConnectionService;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptors;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarStatisticsService
implements DumbAware {
    private static final String FILE_NAME = "statistics/library-jar-statistics.xml";
    private static final LibraryJarStatisticsService ourInstance = new LibraryJarStatisticsService();
    private LibraryJarDescriptor[] ourDescriptors;

    @NotNull
    public static LibraryJarStatisticsService getInstance() {
        return ourInstance;
    }

    @NotNull
    public LibraryJarDescriptor[] getTechnologyDescriptors() {
        if (this.ourDescriptors == null) {
            if (!StatisticsUploadAssistant.isSendAllowed()) {
                return LibraryJarDescriptor.EMPTY;
            }
            URL url = LibraryJarStatisticsService.createVersionsUrl();
            if (url == null) {
                return LibraryJarDescriptor.EMPTY;
            }
            LibraryJarDescriptors descriptors = LibraryJarStatisticsService.deserialize(url);
            this.ourDescriptors = descriptors == null ? LibraryJarDescriptor.EMPTY : descriptors.getDescriptors();
        }
        return this.ourDescriptors;
    }

    @Nullable
    private static LibraryJarDescriptors deserialize(@Nullable URL url) {
        if (url == null) {
            return null;
        }
        LibraryJarDescriptors libraryJarDescriptors = null;
        try {
            libraryJarDescriptors = (LibraryJarDescriptors)XmlSerializer.deserialize((URL)url, LibraryJarDescriptors.class);
        }
        catch (XmlSerializationException xmlSerializationException) {
            // empty catch block
        }
        return libraryJarDescriptors;
    }

    @Nullable
    private static URL createVersionsUrl() {
        String serviceUrl = LibrariesDownloadConnectionService.getInstance().getServiceUrl();
        if (StringUtil.isNotEmpty((String)serviceUrl)) {
            try {
                String url = serviceUrl + "/" + FILE_NAME;
                HttpConfigurable.getInstance().prepareURL(url);
                return new URL(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

