/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import org.cyberneko.html.parsers.DOMParser;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class FindJarFix<T extends PsiElement>
implements IntentionAction,
Iconable {
    private static final Logger LOG = Logger.getInstance(FindJarFix.class);
    private static final String CLASS_ROOT_URL = "http://findjar.com/class/";
    private static final String CLASS_PAGE_EXT = ".html";
    private static final String SERVICE_URL = "http://findjar.com";
    private static final String LINK_TAG_NAME = "a";
    private static final String LINK_ATTR_NAME = "href";
    protected final T myRef;
    protected final Module myModule;
    protected JComponent myEditorComponent;

    public FindJarFix(T ref) {
        this.myRef = ref;
        this.myModule = ModuleUtilCore.findModuleForPsiElement(ref);
    }

    @NotNull
    public String getText() {
        return "Find JAR on web";
    }

    @NotNull
    public String getFamilyName() {
        return "Family name";
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myRef.isValid() && JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Object", file.getResolveScope()) != null && this.myModule != null && FindJarFix.isFqnsOk(project, this.getPossibleFqns(this.myRef));
    }

    private static boolean isFqnsOk(Project project, List<String> fqns) {
        if (fqns.isEmpty()) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        for (String fqn : fqns) {
            if (facade.findClass(fqn, scope) == null) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        List<String> fqns = this.getPossibleFqns(this.myRef);
        this.myEditorComponent = editor.getComponent();
        if (fqns.size() > 1) {
            JBPopupFactory.getInstance().createPopupChooserBuilder(fqns).setTitle("Select Qualified Name").setItemChosenCallback(value2 -> this.findJarsForFqn((String)value2, editor)).createPopup().showInBestPositionFor(editor);
        } else if (fqns.size() == 1) {
            this.findJarsForFqn(fqns.get(0), editor);
        }
    }

    private void findJarsForFqn(final String fqn, final Editor editor) {
        final HashMap libs = new HashMap();
        final Runnable runnable = () -> {
            try {
                DOMParser parser = new DOMParser();
                parser.parse(CLASS_ROOT_URL + fqn.replace('.', '/') + CLASS_PAGE_EXT);
                Document doc = parser.getDocument();
                if (doc != null) {
                    NodeList links = doc.getElementsByTagName(LINK_TAG_NAME);
                    for (int i = 0; i < links.getLength(); ++i) {
                        String pathToJar;
                        Node href;
                        Node link = links.item(i);
                        String libName = link.getTextContent();
                        NamedNodeMap attributes = link.getAttributes();
                        if (attributes == null || (href = attributes.getNamedItem(LINK_ATTR_NAME)) == null || (pathToJar = href.getTextContent()) == null || !pathToJar.startsWith("/jar/") && !pathToJar.startsWith("/class/../")) continue;
                        libs.put(libName, SERVICE_URL + pathToJar);
                    }
                }
            }
            catch (IOException parser) {
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        };
        Task.Modal task = new Task.Modal(editor.getProject(), "Looking for Libraries", true){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                FindJarFix.runUncanceledRunnableWithProgress(runnable, indicator);
            }

            public void onSuccess() {
                super.onSuccess();
                if (libs.isEmpty()) {
                    HintManager.getInstance().showInformationHint(editor, "No libraries found for '" + fqn + "'");
                } else {
                    JBList libNames = new JBList((Collection)ContainerUtil.sorted(libs.keySet()));
                    libNames.installCellRenderer(o -> new JLabel(o.toString(), PlatformIcons.JAR_ICON, 2));
                    if (libs.size() == 1) {
                        String jarName = (String)libs.keySet().iterator().next();
                        String url = (String)libs.get(jarName);
                        FindJarFix.this.initiateDownload(url, jarName);
                    } else {
                        JBPopupFactory.getInstance().createListPopupBuilder((JList)libNames).setTitle("Select a JAR file").setItemChoosenCallback(() -> {
                            String jarName = (String)libNames.getSelectedValue();
                            String url = (String)libs.get(jarName);
                            if (url != null) {
                                FindJarFix.this.initiateDownload(url, jarName);
                            }
                        }).createPopup().showInBestPositionFor(editor);
                    }
                }
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    private void initiateDownload(String url, String jarName) {
        DOMParser parser = new DOMParser();
        try {
            NodeList links;
            parser.parse(url);
            Document doc = parser.getDocument();
            if (doc != null && (links = doc.getElementsByTagName(LINK_TAG_NAME)) != null) {
                for (int i = 0; i < links.getLength(); ++i) {
                    String jarUrl;
                    Node link;
                    NamedNodeMap attributes;
                    Node item = links.item(i);
                    if (item == null || (attributes = item.getAttributes()) == null || (link = attributes.getNamedItem(LINK_ATTR_NAME)) == null || (jarUrl = link.getTextContent()) == null || !jarUrl.endsWith(jarName)) continue;
                    this.downloadJar(jarUrl, jarName);
                }
            }
        }
        catch (IOException | SAXException exception) {
            // empty catch block
        }
    }

    private static void runUncanceledRunnableWithProgress(Runnable run, ProgressIndicator indicator) {
        Thread t = new Thread(run, "FindJar download thread");
        t.setDaemon(true);
        t.start();
        try {
            while (t.isAlive()) {
                t.join(500L);
                indicator.checkCanceled();
            }
        }
        catch (InterruptedException e) {
            indicator.checkCanceled();
        }
    }

    private void downloadJar(String jarUrl, String jarName) {
        Project project = this.myModule.getProject();
        String dirPath = PropertiesComponent.getInstance((Project)project).getValue("findjar.last.used.dir");
        VirtualFile toSelect = dirPath == null ? null : LocalFileSystem.getInstance().findFileByIoFile(new File(dirPath));
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select Path to Save Jar").withDescription("Choose where to save '" + jarName + "'");
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, (VirtualFile)toSelect);
        if (file != null) {
            PropertiesComponent.getInstance((Project)project).setValue("findjar.last.used.dir", file.getPath());
            DownloadableFileService downloader = DownloadableFileService.getInstance();
            DownloadableFileDescription description = downloader.createFileDescription(jarUrl, jarName);
            List jars = downloader.createDownloader(Collections.singletonList(description), jarName).downloadFilesWithProgress(file.getPath(), project, this.myEditorComponent);
            if (jars != null && jars.size() == 1) {
                WriteAction.run(() -> OrderEntryFix.addJarToRoots(((VirtualFile)jars.get(0)).getPresentableUrl(), this.myModule, this.myRef));
            }
        }
    }

    protected abstract Collection<String> getFqns(@NotNull T var1);

    protected List<String> getPossibleFqns(T ref) {
        Collection<String> fqns = this.getFqns(ref);
        ArrayList<String> res = new ArrayList<String>(fqns.size());
        for (String fqn : fqns) {
            String className;
            int index;
            if (fqn.startsWith("java.") || fqn.startsWith("javax.swing.") || (index = fqn.lastIndexOf(46)) == -1 || (className = fqn.substring(index + 1)).length() == 0 || Character.isLowerCase(className.charAt(0))) continue;
            res.add(fqn);
        }
        return res;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public Icon getIcon(int flags) {
        return PlatformIcons.WEB_ICON;
    }
}

